/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class BookmarkContentProvider
implements IStructuredContentProvider,
IResourceChangeListener,
IBasicPropertyConstants {
    private IResource input;
    private Viewer viewer;

    public BookmarkContentProvider(BookmarkNavigator bookmarkNavigator) {
    }

    public void dispose() {
        IResource iResource = (IResource)this.viewer.getInput();
        if (iResource != null) {
            iResource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    Object[] getBookmarks(IResource iResource) {
        try {
            return iResource.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IResource) {
            return this.getBookmarks((IResource)object);
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    void getMarkerDeltas(IResourceDelta iResourceDelta, List list, List list2, List list3) {
        IMarkerDelta[] iMarkerDeltaArray = iResourceDelta.getMarkerDeltas();
        int n = 0;
        while (n < iMarkerDeltaArray.length) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[n];
            IMarker iMarker = iMarkerDelta.getMarker();
            switch (iMarkerDelta.getKind()) {
                case 1: {
                    if (!iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    list.add(iMarker);
                    break;
                }
                case 2: {
                    if (!iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    list2.add(iMarker);
                    break;
                }
                case 4: {
                    if (!iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    list3.add(iMarker);
                }
            }
            ++n;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n2 = 0;
        while (n2 < iResourceDeltaArray.length) {
            this.getMarkerDeltas(iResourceDeltaArray[n2], list, list2, list3);
            ++n2;
        }
    }

    public Object getParent(Object object) {
        return this.input;
    }

    public boolean hasChildren(Object object) {
        return object instanceof IWorkspace;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object == null) {
            IResource iResource = (IResource)object2;
            iResource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.viewer = viewer;
        this.input = (IResource)object2;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        this.getMarkerDeltas(iResourceDelta, arrayList, arrayList2, arrayList3);
        if (arrayList.size() + arrayList2.size() + arrayList3.size() > 0) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control control = BookmarkContentProvider.this.viewer.getControl();
                    if (control == null || control.isDisposed()) {
                        return;
                    }
                    BookmarkContentProvider.this.viewer.refresh();
                }
            });
        }
    }
}

