/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class BookmarkLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image image;
    private ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/bkmrk_tsk.gif");
    static final int COLUMN_ICON = 0;
    static final int COLUMN_DESCRIPTION = 1;
    static final int COLUMN_RESOURCE = 2;
    static final int COLUMN_FOLDER = 3;
    static final int COLUMN_LOCATION = 4;

    public BookmarkLabelProvider(BookmarkNavigator bookmarkNavigator) {
        this.image = JFaceResources.getResources().createImageWithDefault(this.desc);
    }

    public void dispose() {
        if (this.image != null) {
            JFaceResources.getResources().destroyImage(this.desc);
            this.image = null;
        }
    }

    public Image getImage(Object object) {
        return this.image;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof IMarker)) {
            return "";
        }
        IMarker iMarker = (IMarker)object;
        switch (n) {
            case 1: {
                return iMarker.getAttribute("message", "");
            }
            case 2: {
                return iMarker.getResource().getName();
            }
            case 3: {
                return BookmarkLabelProvider.getContainerName(iMarker);
            }
            case 4: {
                int n2 = iMarker.getAttribute("lineNumber", -1);
                if (n2 == -1) {
                    return "";
                }
                return NLS.bind((String)BookmarkMessages.LineIndicator_text, (Object)String.valueOf(n2));
            }
        }
        return "";
    }

    public Image getColumnImage(Object object, int n) {
        if (n == 0) {
            return this.image;
        }
        return null;
    }

    public static String getContainerName(IMarker iMarker) {
        IPath iPath = iMarker.getResource().getFullPath();
        int n = iPath.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += iPath.segment(n3).length();
            ++n3;
        }
        if (n > 1) {
            n2 += n - 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(iPath.segment(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }
}

