/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkContentProvider;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkLabelProvider;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkSorter;
import org.eclipse.ui.views.bookmarkexplorer.CopyBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.EditBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.OpenBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.PasteBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.RemoveBookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.SelectAllAction;
import org.eclipse.ui.views.navigator.ShowInNavigatorAction;

public class BookmarkNavigator
extends ViewPart {
    private Table table;
    private TableViewer viewer;
    private OpenBookmarkAction openAction;
    private CopyBookmarkAction copyAction;
    private PasteBookmarkAction pasteAction;
    private RemoveBookmarkAction removeAction;
    private EditBookmarkAction editAction;
    private SelectAllAction selectAllAction;
    private ShowInNavigatorAction showInNavigatorAction;
    private SortByAction sortByDescriptionAction;
    private SortByAction sortByResourceAction;
    private SortByAction sortByFolderAction;
    private SortByAction sortByLineAction;
    private SortByAction sortByCreationTime;
    private ChangeSortDirectionAction sortAscendingAction;
    private ChangeSortDirectionAction sortDescendingAction;
    private IMemento memento;
    private BookmarkSorter comparator;
    private Clipboard clipboard;
    private final String[] columnHeaders = new String[]{BookmarkMessages.ColumnIcon_header, BookmarkMessages.ColumnDescription_header, BookmarkMessages.ColumnResource_header, BookmarkMessages.ColumnFolder_header, BookmarkMessages.ColumnLocation_header};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(16, false, true), new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ID = "id";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void addContributions() {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.openAction = new OpenBookmarkAction(this);
        this.openAction.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.gif"));
        this.copyAction = new CopyBookmarkAction(this);
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.pasteAction = new PasteBookmarkAction(this);
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.removeAction = new RemoveBookmarkAction(this);
        this.removeAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.editAction = new EditBookmarkAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.showInNavigatorAction = new ShowInNavigatorAction(this.getViewSite().getPage(), (ISelectionProvider)this.viewer);
        this.handleSelectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                BookmarkNavigator.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.removeAction);
        iToolBarManager.add((IAction)this.openAction);
        iToolBarManager.update(false);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeAction);
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                BookmarkNavigator.this.openAction.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                BookmarkNavigator.this.handleSelectionChanged((IStructuredSelection)selectionChangedEvent.getSelection());
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                BookmarkNavigator.this.handleKeyPressed(keyEvent);
            }
        });
    }

    public void createPartControl(Composite composite) {
        this.clipboard = new Clipboard(composite.getDisplay());
        this.createTable(composite);
        this.viewer = new TableViewer(this.table);
        this.createColumns();
        this.comparator = new BookmarkSorter();
        this.viewer.setContentProvider((IContentProvider)new BookmarkContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new BookmarkLabelProvider(this));
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IDialogSettings iDialogSettings = BookmarkNavigator.getPlugin().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("BookmarkSortState");
        this.comparator.restoreState(iDialogSettings2);
        this.addContributions();
        this.initDragAndDrop();
        this.createSortActions();
        this.fillActionBars();
        this.updateSortState();
        this.updatePasteEnablement();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.ui.bookmark_view_context");
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.openAction);
        iMenuManager.add((IAction)this.copyAction);
        this.updatePasteEnablement();
        iMenuManager.add((IAction)this.pasteAction);
        iMenuManager.add((IAction)this.removeAction);
        iMenuManager.add((IAction)this.selectAllAction);
        iMenuManager.add((IAction)this.showInNavigatorAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.editAction);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, BookmarkNavigator.this.getViewer().getSelection());
                }
            };
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(clazz);
    }

    static AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    Shell getShell() {
        return this.getViewSite().getShell();
    }

    StructuredViewer getViewer() {
        return this.viewer;
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.removeAction.isEnabled()) {
            this.removeAction.run();
        }
    }

    void handleSelectionChanged(IStructuredSelection iStructuredSelection) {
        this.openAction.selectionChanged(iStructuredSelection);
        this.removeAction.selectionChanged(iStructuredSelection);
        this.editAction.selectionChanged(iStructuredSelection);
        this.selectAllAction.selectionChanged(iStructuredSelection);
        this.showInNavigatorAction.selectionChanged(iStructuredSelection);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    protected void initDragAndDrop() {
        int n = 1;
        Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter dragSourceAdapter = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                BookmarkNavigator.this.performDragSetData(dragSourceEvent);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }
        };
        this.viewer.addDragSupport(n, transferArray, (DragSourceListener)dragSourceAdapter);
    }

    void performDragSetData(DragSourceEvent dragSourceEvent) {
        if (MarkerTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            Object[] objectArray = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            if (objectArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                ILabelProvider iLabelProvider = (ILabelProvider)this.getViewer().getLabelProvider();
                int n = 0;
                while (n < objectArray.length) {
                    String string;
                    if (n > 0) {
                        stringBuffer.append(System.getProperty("line.separator"));
                    }
                    if ((string = iLabelProvider.getText(objectArray[n])) != null) {
                        stringBuffer.append(string);
                    }
                    ++n;
                }
                dragSourceEvent.data = stringBuffer.toString();
            }
            return;
        }
    }

    void restoreState(IMemento iMemento) {
        ScrollBar scrollBar;
        Scrollable scrollable;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMemento iMemento2 = iMemento.getChild(TAG_SELECTION);
        if (iMemento2 != null) {
            scrollable = new ArrayList();
            scrollBar = iMemento2.getChildren(TAG_MARKER);
            int n = 0;
            while (n < ((ScrollBar)scrollBar).length) {
                try {
                    IMarker iMarker;
                    long l = new Long(scrollBar[n].getString(TAG_ID));
                    IResource iResource = iWorkspaceRoot.findMember(scrollBar[n].getString(TAG_RESOURCE));
                    if (iResource != null && (iMarker = iResource.findMarker(l)) != null) {
                        scrollable.add(iMarker);
                    }
                }
                catch (CoreException coreException) {}
                ++n;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection((List)scrollable));
        }
        if ((scrollBar = (scrollable = (Scrollable)this.viewer.getControl()).getVerticalBar()) != null) {
            try {
                String string = iMemento.getString(TAG_VERTICAL_POSITION);
                int n = new Integer(string);
                scrollBar.setSelection(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((scrollBar = scrollable.getHorizontalBar()) != null) {
            try {
                String string = iMemento.getString(TAG_HORIZONTAL_POSITION);
                int n = new Integer(string);
                scrollBar.setSelection(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.updateSortState();
        this.viewer.refresh();
    }

    public void saveState(IMemento iMemento) {
        int n;
        ScrollBar scrollBar;
        if (this.viewer == null) {
            if (this.memento != null) {
                iMemento.putMemento(this.memento);
            }
            return;
        }
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        Object[] objectArray = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        if (objectArray.length > 0) {
            scrollBar = iMemento.createChild(TAG_SELECTION);
            n = 0;
            while (n < objectArray.length) {
                IMemento iMemento2 = scrollBar.createChild(TAG_MARKER);
                IMarker iMarker = (IMarker)objectArray[n];
                iMemento2.putString(TAG_RESOURCE, iMarker.getResource().getFullPath().toString());
                iMemento2.putString(TAG_ID, String.valueOf(iMarker.getId()));
                ++n;
            }
        }
        n = (scrollBar = scrollable.getVerticalBar()) != null ? scrollBar.getSelection() : 0;
        iMemento.putString(TAG_VERTICAL_POSITION, String.valueOf(n));
        scrollBar = scrollable.getHorizontalBar();
        n = scrollBar != null ? scrollBar.getSelection() : 0;
        iMemento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(n));
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    void createColumns() {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = BookmarkNavigator.this.table.indexOf((TableColumn)selectionEvent.widget) - 1;
                if (n == BookmarkNavigator.this.comparator.getTopPriority()) {
                    BookmarkNavigator.this.comparator.reverseTopPriority();
                } else {
                    BookmarkNavigator.this.comparator.setTopPriority(n);
                }
                BookmarkNavigator.this.updateSortState();
                BookmarkNavigator.this.viewer.refresh();
                IDialogSettings iDialogSettings = BookmarkNavigator.getPlugin().getDialogSettings();
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection("BookmarkSortState");
                if (iDialogSettings2 == null) {
                    iDialogSettings2 = iDialogSettings.addNewSection("BookmarkSortState");
                }
                BookmarkNavigator.this.comparator.saveState(iDialogSettings2);
            }
        };
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        int n = 0;
        while (n < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[n]);
            TableColumn tableColumn = new TableColumn(this.table, 0, n);
            tableColumn.setResizable(this.columnLayouts[n].resizable);
            tableColumn.setText(this.columnHeaders[n]);
            if (n > 0) {
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++n;
        }
    }

    void createTable(Composite composite) {
        this.table = new Table(composite, 66306);
        this.table.setLinesVisible(true);
    }

    void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        MenuManager menuManager = new MenuManager(BookmarkMessages.SortMenuGroup_text);
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.sortByDescriptionAction);
        menuManager.add((IAction)this.sortByResourceAction);
        menuManager.add((IAction)this.sortByFolderAction);
        menuManager.add((IAction)this.sortByLineAction);
        menuManager.add((IAction)this.sortByCreationTime);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.sortAscendingAction);
        menuManager.add((IAction)this.sortDescendingAction);
    }

    void createSortActions() {
        this.sortByDescriptionAction = new SortByAction(0);
        this.sortByDescriptionAction.setText(BookmarkMessages.ColumnDescription_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByDescriptionAction, "org.eclipse.ui.bookmark_sort_description_action_context");
        this.sortByResourceAction = new SortByAction(1);
        this.sortByResourceAction.setText(BookmarkMessages.ColumnResource_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByResourceAction, "org.eclipse.ui.bookmark_sort_resource_action_context");
        this.sortByFolderAction = new SortByAction(2);
        this.sortByFolderAction.setText(BookmarkMessages.ColumnFolder_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByFolderAction, "org.eclipse.ui.bookmark_sort_folder_action_context");
        this.sortByLineAction = new SortByAction(3);
        this.sortByLineAction.setText(BookmarkMessages.ColumnLocation_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByLineAction, "org.eclipse.ui.bookmark_sort_location_action_context");
        this.sortByCreationTime = new SortByAction(4);
        this.sortByCreationTime.setText(BookmarkMessages.ColumnCreationTime_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCreationTime, "org.eclipse.ui.bookmark_sort_creation_time_action_context");
        this.sortAscendingAction = new ChangeSortDirectionAction(1);
        this.sortAscendingAction.setText(BookmarkMessages.SortDirectionAscending_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortAscendingAction, "org.eclipse.ui.bookmark_sort_ascending_action_context");
        this.sortDescendingAction = new ChangeSortDirectionAction(-1);
        this.sortDescendingAction.setText(BookmarkMessages.SortDirectionDescending_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortDescendingAction, "org.eclipse.ui.bookmark_sort_descending_action_context");
    }

    void updateSortState() {
        int n = this.comparator.getTopPriority();
        this.sortByDescriptionAction.setChecked(n == 0);
        this.sortByResourceAction.setChecked(n == 1);
        this.sortByFolderAction.setChecked(n == 2);
        this.sortByLineAction.setChecked(n == 3);
        this.sortByCreationTime.setChecked(n == 4);
        int n2 = this.comparator.getTopPriorityDirection();
        this.sortAscendingAction.setChecked(n2 == 1);
        this.sortDescendingAction.setChecked(n2 == -1);
    }

    void updatePasteEnablement() {
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        IMarker[] iMarkerArray = (IMarker[])this.getClipboard().getContents((Transfer)markerTransfer);
        boolean bl = false;
        if (iMarkerArray != null) {
            int n = 0;
            while (n < iMarkerArray.length) {
                try {
                    if (iMarkerArray[n].getType().equals("org.eclipse.core.resources.bookmark")) {
                        bl = true;
                        break;
                    }
                }
                catch (CoreException coreException) {
                    bl = false;
                }
                ++n;
            }
        }
        this.pasteAction.setEnabled(bl);
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    class ChangeSortDirectionAction
    extends Action {
        private int direction;

        public ChangeSortDirectionAction(int n) {
            this.direction = n;
        }

        public void run() {
            BookmarkNavigator.this.comparator.setTopPriorityDirection(this.direction);
            BookmarkNavigator.this.updateSortState();
            BookmarkNavigator.this.viewer.refresh();
            IDialogSettings iDialogSettings = BookmarkNavigator.getPlugin().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("BookmarkSortState");
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection("BookmarkSortState");
            }
            BookmarkNavigator.this.comparator.saveState(iDialogSettings2);
        }
    }

    class SortByAction
    extends Action {
        private int column;

        public SortByAction(int n) {
            this.column = n;
        }

        public void run() {
            BookmarkNavigator.this.comparator.setTopPriority(this.column);
            BookmarkNavigator.this.updateSortState();
            BookmarkNavigator.this.viewer.refresh();
            IDialogSettings iDialogSettings = BookmarkNavigator.getPlugin().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("BookmarkSortState");
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection("BookmarkSortState");
            }
            BookmarkNavigator.this.comparator.saveState(iDialogSettings2);
        }
    }
}

