/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkLabelProvider;

class BookmarkSorter
extends ViewerComparator {
    private int[] directions;
    private int[] priorities;
    static final int ASCENDING = 1;
    static final int DESCENDING = -1;
    static final int DESCRIPTION = 0;
    static final int RESOURCE = 1;
    static final int FOLDER = 2;
    static final int LOCATION = 3;
    static final int CREATION_TIME = 4;
    static final int[] DEFAULT_PRIORITIES;
    static final int[] DEFAULT_DIRECTIONS;

    static {
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[4] = 4;
        DEFAULT_PRIORITIES = nArray;
        DEFAULT_DIRECTIONS = new int[]{1, 1, 1, 1, 1};
    }

    public BookmarkSorter() {
        this.resetState();
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void setTopPriority(int n) {
        if (n < 0 || n >= this.priorities.length) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.priorities.length) {
            if (this.priorities[n3] == n) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            this.resetState();
            return;
        }
        n3 = n2;
        while (n3 > 0) {
            this.priorities[n3] = this.priorities[n3 - 1];
            --n3;
        }
        this.priorities[0] = n;
        this.directions[n] = DEFAULT_DIRECTIONS[n];
    }

    public void setTopPriorityDirection(int n) {
        if (n == 1 || n == -1) {
            this.directions[this.priorities[0]] = n;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    public void resetState() {
        this.priorities = new int[DEFAULT_PRIORITIES.length];
        System.arraycopy(DEFAULT_PRIORITIES, 0, this.priorities, 0, this.priorities.length);
        this.directions = new int[DEFAULT_DIRECTIONS.length];
        System.arraycopy(DEFAULT_DIRECTIONS, 0, this.directions, 0, this.directions.length);
    }

    private int compare(IMarker iMarker, IMarker iMarker2, int n) {
        if (n >= this.priorities.length) {
            return 0;
        }
        int n2 = this.priorities[n];
        switch (n2) {
            case 0: {
                String string = iMarker.getAttribute("message", "");
                String string2 = iMarker2.getAttribute("message", "");
                int n3 = this.getComparator().compare(string, string2);
                if (n3 == 0) {
                    return this.compare(iMarker, iMarker2, n + 1);
                }
                return n3 * this.directions[n2];
            }
            case 1: {
                String string = iMarker.getResource().getName();
                String string3 = iMarker2.getResource().getName();
                int n4 = this.getComparator().compare(string, string3);
                if (n4 == 0) {
                    return this.compare(iMarker, iMarker2, n + 1);
                }
                return n4 * this.directions[n2];
            }
            case 2: {
                String string = BookmarkLabelProvider.getContainerName(iMarker);
                String string4 = BookmarkLabelProvider.getContainerName(iMarker2);
                int n5 = this.getComparator().compare(string, string4);
                if (n5 == 0) {
                    return this.compare(iMarker, iMarker2, n + 1);
                }
                return n5 * this.directions[n2];
            }
            case 3: {
                int n6 = iMarker.getAttribute("lineNumber", -1);
                int n7 = iMarker2.getAttribute("lineNumber", -1);
                int n8 = n6 - n7;
                if (n8 == 0) {
                    return this.compare(iMarker, iMarker2, n + 1);
                }
                return n8 * this.directions[n2];
            }
            case 4: {
                long l;
                try {
                    l = iMarker.getCreationTime() - iMarker2.getCreationTime();
                }
                catch (CoreException coreException) {
                    l = 0L;
                }
                if (l == 0L) {
                    return this.compare(iMarker, iMarker2, n + 1);
                }
                return (int)l * this.directions[n2];
            }
        }
        return 0;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        IMarker iMarker = (IMarker)object;
        IMarker iMarker2 = (IMarker)object2;
        return this.compare(iMarker, iMarker2, 0);
    }

    public void saveState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        int n = 0;
        while (n < this.priorities.length) {
            iDialogSettings.put("priority" + n, this.priorities[n]);
            iDialogSettings.put("direction" + n, this.directions[n]);
            ++n;
        }
    }

    public void restoreState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        try {
            int n = 0;
            while (n < this.priorities.length) {
                this.priorities[n] = iDialogSettings.getInt("priority" + n);
                this.directions[n] = iDialogSettings.getInt("direction" + n);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.resetState();
        }
    }
}

