/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.MarkerUtil;

class CopyBookmarkAction
extends BookmarkAction {
    public CopyBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.CopyBookmark_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.copy_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        BookmarkNavigator bookmarkNavigator = this.getView();
        StructuredViewer structuredViewer = bookmarkNavigator.getViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)structuredViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        List list = iStructuredSelection.toList();
        IMarker[] iMarkerArray = new IMarker[list.size()];
        list.toArray(iMarkerArray);
        this.setClipboard(iMarkerArray, this.createBookmarkReport(iMarkerArray));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!iStructuredSelection.isEmpty());
    }

    private void setClipboard(IMarker[] iMarkerArray, String string) {
        block3: {
            try {
                Object[] objectArray = new Object[]{iMarkerArray, string};
                Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                this.getView().getClipboard().setContents(objectArray, transferArray);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.getView().getShell(), (String)BookmarkMessages.CopyToClipboardProblemDialog_title, (String)BookmarkMessages.CopyToClipboardProblemDialog_message)) break block3;
                this.setClipboard(iMarkerArray, string);
            }
        }
    }

    private String createBookmarkReport(IMarker[] iMarkerArray) {
        String string = "";
        string = String.valueOf(string) + BookmarkMessages.ColumnDescription_header + '\t';
        string = String.valueOf(string) + BookmarkMessages.ColumnResource_header + '\t';
        string = String.valueOf(string) + BookmarkMessages.ColumnFolder_header + '\t';
        string = String.valueOf(string) + BookmarkMessages.ColumnLocation_header;
        string = String.valueOf(string) + System.getProperty("line.separator");
        int n = 0;
        while (n < iMarkerArray.length) {
            string = String.valueOf(string) + MarkerUtil.getMessage(iMarkerArray[n]) + '\t';
            string = String.valueOf(string) + MarkerUtil.getResourceName(iMarkerArray[n]) + '\t';
            string = String.valueOf(string) + MarkerUtil.getContainerName(iMarkerArray[n]) + '\t';
            int n2 = MarkerUtil.getLineNumber(iMarkerArray[n]);
            string = String.valueOf(string) + NLS.bind((String)BookmarkMessages.LineIndicator_text, (Object)String.valueOf(n2));
            string = String.valueOf(string) + System.getProperty("line.separator");
            ++n;
        }
        return string;
    }
}

