/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkPropertiesDialog;

class EditBookmarkAction
extends BookmarkAction {
    private IMarker marker;

    protected EditBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.Properties_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.bookmark_properties_action_context");
        this.setEnabled(false);
    }

    public void run() {
        if (this.marker != null) {
            this.editBookmark();
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.marker = null;
        this.setEnabled(false);
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IMarker)) {
            return;
        }
        IMarker iMarker = (IMarker)object;
        IResource iResource = iMarker.getResource();
        if (iResource instanceof IFile) {
            this.marker = iMarker;
            this.setEnabled(true);
        }
    }

    private void editBookmark() {
        BookmarkPropertiesDialog bookmarkPropertiesDialog = new BookmarkPropertiesDialog(this.getView().getSite().getShell());
        bookmarkPropertiesDialog.setMarker(this.marker);
        bookmarkPropertiesDialog.open();
    }
}

