/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class MarkerUtil {
    private MarkerUtil() {
    }

    static int getCharEnd(IMarker iMarker) {
        return iMarker.getAttribute("charEnd", -1);
    }

    static int getCharStart(IMarker iMarker) {
        return iMarker.getAttribute("charStart", -1);
    }

    static String getContainerName(IMarker iMarker) {
        IPath iPath = iMarker.getResource().getFullPath();
        int n = iPath.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += iPath.segment(n3).length();
            ++n3;
        }
        if (n > 1) {
            n2 += n - 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(iPath.segment(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }

    static int getLineNumber(IMarker iMarker) {
        return iMarker.getAttribute("lineNumber", -1);
    }

    static String getLocation(IMarker iMarker) {
        return iMarker.getAttribute("location", "");
    }

    static String getMessage(IMarker iMarker) {
        return iMarker.getAttribute("message", "");
    }

    static int getNumericValue(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        if (n < n2 && string.charAt(n) == '#') {
            ++n;
        }
        if (n < n2 && string.charAt(n) == '-') {
            bl = true;
            ++n;
        }
        int n3 = 0;
        while (n < n2) {
            int n4;
            if ((n4 = Character.digit(string.charAt(n++), 10)) < 0) {
                return n3;
            }
            n3 = n3 * 10 + n4;
        }
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    static String getResourceName(IMarker iMarker) {
        return iMarker.getResource().getName();
    }

    static String getCreationTime(IMarker iMarker) {
        try {
            return DateFormat.getDateTimeInstance((int)1, (int)2).format(new Date(iMarker.getCreationTime()));
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

