/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class OpenBookmarkAction
extends BookmarkAction {
    public OpenBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.OpenBookmark_text);
        this.setToolTipText(BookmarkMessages.OpenBookmark_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.open_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        IWorkbenchPage iWorkbenchPage = this.getView().getSite().getPage();
        Iterator iterator = this.getStructuredSelection().iterator();
        while (iterator.hasNext()) {
            IMarker iMarker = (IMarker)iterator.next();
            try {
                IDE.openEditor(iWorkbenchPage, iMarker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException partInitException) {
                CoreException coreException = null;
                IStatus iStatus = partInitException.getStatus();
                if (iStatus != null && iStatus.getException() instanceof CoreException) {
                    coreException = (CoreException)iStatus.getException();
                }
                if (coreException != null) {
                    ErrorDialog.openError((Shell)this.getView().getShell(), (String)BookmarkMessages.OpenBookmark_errorTitle, (String)partInitException.getMessage(), (IStatus)coreException.getStatus());
                    continue;
                }
                MessageDialog.openError((Shell)this.getView().getShell(), (String)BookmarkMessages.OpenBookmark_errorTitle, (String)partInitException.getMessage());
            }
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!iStructuredSelection.isEmpty());
    }
}

