/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class PasteBookmarkAction
extends BookmarkAction {
    private BookmarkNavigator view;

    public PasteBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.PasteBookmark_text);
        this.view = bookmarkNavigator;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.paste_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        final IMarker[] iMarkerArray = (IMarker[])this.view.getClipboard().getContents((Transfer)markerTransfer);
        if (iMarkerArray == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        if (iMarkerArray[n].getType().equals("org.eclipse.core.resources.bookmark")) {
                            arrayList2.add(iMarkerArray[n].getResource());
                            arrayList.add(iMarkerArray[n].getAttributes());
                        }
                        ++n;
                    }
                }
            }, null);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.view.getShell(), (String)BookmarkMessages.PasteBookmark_errorTitle, null, (IStatus)coreException.getStatus());
            return;
        }
        Map[] mapArray = arrayList.toArray(new Map[arrayList.size()]);
        IResource[] iResourceArray = arrayList2.toArray(new IResource[arrayList2.size()]);
        final CreateMarkersOperation createMarkersOperation = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", mapArray, iResourceArray, BookmarkMessages.PasteBookmark_undoText);
        this.execute((IUndoableOperation)createMarkersOperation, BookmarkMessages.PasteBookmark_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.view.getShell()));
        if (createMarkersOperation.getMarkers() != null) {
            this.view.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PasteBookmarkAction.this.view.getViewer().setSelection((ISelection)new StructuredSelection((Object[])createMarkersOperation.getMarkers()));
                    PasteBookmarkAction.this.view.updatePasteEnablement();
                }
            });
        }
    }
}

