/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class RemoveBookmarkAction
extends BookmarkAction {
    public RemoveBookmarkAction(BookmarkNavigator bookmarkNavigator) {
        super(bookmarkNavigator, BookmarkMessages.RemoveBookmark_text);
        this.setToolTipText(BookmarkMessages.RemoveBookmark_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.remove_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        List list = iStructuredSelection.toList();
        IMarker[] iMarkerArray = new IMarker[list.size()];
        list.toArray(iMarkerArray);
        DeleteMarkersOperation deleteMarkersOperation = new DeleteMarkersOperation(iMarkerArray, BookmarkMessages.RemoveBookmark_undoText);
        this.execute((IUndoableOperation)deleteMarkersOperation, BookmarkMessages.RemoveBookmark_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getView().getShell()));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!iStructuredSelection.isEmpty());
    }
}

