/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.framelist.FrameListMessages;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;

public class BackAction
extends FrameAction {
    public BackAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.Back_text);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK"));
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.back_action_context");
        this.update();
    }

    private Frame getPreviousFrame() {
        FrameList frameList = this.getFrameList();
        return frameList.getFrame(frameList.getCurrentIndex() - 1);
    }

    private String getToolTipText(Frame frame) {
        String string;
        if (frame != null && (string = frame.getToolTipText()) != null && string.length() > 0) {
            return NLS.bind((String)FrameListMessages.Back_toolTipOneArg, (Object)string);
        }
        return FrameListMessages.Back_toolTip;
    }

    public void run() {
        this.getFrameList().back();
    }

    public void update() {
        super.update();
        Frame frame = this.getPreviousFrame();
        this.setEnabled(frame != null);
        this.setToolTipText(this.getToolTipText(frame));
    }
}

