/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.IFrameSource;

public class FrameList
extends EventManager {
    public static final String P_CURRENT_FRAME = "currentFrame";
    private IFrameSource source;
    private List frames;
    private int current;

    public FrameList(IFrameSource iFrameSource) {
        this.source = iFrameSource;
        Frame frame = iFrameSource.getFrame(1, 0);
        frame.setParent(this);
        frame.setIndex(0);
        this.frames = new ArrayList();
        this.frames.add(frame);
        this.current = 0;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    public void back() {
        if (this.current > 0) {
            this.setCurrent(this.current - 1);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void forward() {
        if (this.current < this.frames.size() - 1) {
            this.setCurrent(this.current + 1);
        }
    }

    public Frame getCurrentFrame() {
        return this.getFrame(this.current);
    }

    public int getCurrentIndex() {
        return this.current;
    }

    public Frame getFrame(int n) {
        if (n < 0 || n >= this.frames.size()) {
            return null;
        }
        return (Frame)this.frames.get(n);
    }

    public IFrameSource getSource() {
        return this.source;
    }

    public void gotoFrame(Frame frame) {
        int n = this.frames.size();
        while (--n > this.current) {
            this.frames.remove(n);
        }
        frame.setParent(this);
        n = this.frames.size();
        frame.setIndex(n);
        this.frames.add(frame);
        this.setCurrent(n);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    void setCurrent(int n) {
        Assert.isTrue((n >= 0 && n < this.frames.size() ? 1 : 0) != 0);
        int n2 = this.current;
        if (n2 != n) {
            this.updateCurrentFrame();
            this.current = n;
            this.firePropertyChange(new PropertyChangeEvent((Object)this, P_CURRENT_FRAME, (Object)this.getFrame(n2), (Object)this.getFrame(n)));
        }
    }

    public void setCurrentIndex(int n) {
        if (n != -1 && n != this.current) {
            this.setCurrent(n);
        }
    }

    public int size() {
        return this.frames.size();
    }

    public void updateCurrentFrame() {
        Assert.isTrue((this.current >= 0 ? 1 : 0) != 0);
        Frame frame = this.source.getFrame(1, 1);
        frame.setParent(this);
        frame.setIndex(this.current);
        this.frames.set(this.current, frame);
    }
}

