/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.framelist.Frame;

public class TreeFrame
extends Frame {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_FRAME_INPUT = "frameInput";
    private static final String TAG_FACTORY_ID = "factoryID";
    private AbstractTreeViewer viewer;
    private Object input;
    private ISelection selection;
    private Object[] expandedElements;
    static /* synthetic */ Class class$0;

    public TreeFrame(AbstractTreeViewer abstractTreeViewer) {
        this.viewer = abstractTreeViewer;
    }

    public TreeFrame(AbstractTreeViewer abstractTreeViewer, Object object) {
        this(abstractTreeViewer);
        this.setInput(object);
        ILabelProvider iLabelProvider = (ILabelProvider)abstractTreeViewer.getLabelProvider();
        String string = iLabelProvider.getText(object);
        if (string == null) {
            string = "";
        }
        this.setName(string);
        this.setToolTipText(string);
    }

    public Object[] getExpandedElements() {
        return this.expandedElements;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    private List restoreElements(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren(TAG_ELEMENT);
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(iMementoArray.length);
        int n = 0;
        while (n < iMementoArray.length) {
            IElementFactory iElementFactory;
            String string = iMementoArray[n].getString(TAG_FACTORY_ID);
            if (string != null && (iElementFactory = PlatformUI.getWorkbench().getElementFactory(string)) != null) {
                arrayList.add(iElementFactory.createElement(iMementoArray[n]));
            }
            ++n;
        }
        return arrayList;
    }

    public void restoreState(IMemento iMemento) {
        List list;
        IElementFactory iElementFactory;
        IMemento iMemento2 = iMemento.getChild(TAG_FRAME_INPUT);
        if (iMemento2 == null) {
            return;
        }
        String string = iMemento2.getString(TAG_FACTORY_ID);
        IAdaptable iAdaptable = null;
        if (string != null && (iElementFactory = PlatformUI.getWorkbench().getElementFactory(string)) != null) {
            iAdaptable = iElementFactory.createElement(iMemento2);
        }
        if (iAdaptable != null) {
            this.input = iAdaptable;
        }
        if ((iElementFactory = iMemento.getChild(TAG_EXPANDED)) != null) {
            list = this.restoreElements((IMemento)iElementFactory);
            this.expandedElements = list.toArray(new Object[list.size()]);
        } else {
            this.expandedElements = new Object[0];
        }
        list = iMemento.getChild(TAG_SELECTION);
        if (list != null) {
            List list2 = this.restoreElements((IMemento)list);
            this.selection = new StructuredSelection(list2);
        } else {
            this.selection = StructuredSelection.EMPTY;
        }
    }

    private void saveElements(Object[] objectArray, IMemento iMemento) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IAdaptable) {
                IPersistableElement iPersistableElement;
                IAdaptable iAdaptable = (IAdaptable)objectArray[n];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iPersistableElement = (IPersistableElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IMemento iMemento2 = iMemento.createChild(TAG_ELEMENT);
                    iMemento2.putString(TAG_FACTORY_ID, iPersistableElement.getFactoryId());
                    iPersistableElement.saveState(iMemento2);
                }
            }
            ++n;
        }
    }

    public void saveState(IMemento iMemento) {
        IPersistableElement iPersistableElement;
        if (!(this.input instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)this.input;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IPersistableElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iPersistableElement = (IPersistableElement)iAdaptable.getAdapter((Class)clazz)) != null) {
            Object[] objectArray;
            IMemento iMemento2 = iMemento.createChild(TAG_FRAME_INPUT);
            iMemento2.putString(TAG_FACTORY_ID, iPersistableElement.getFactoryId());
            iPersistableElement.saveState(iMemento2);
            if (this.expandedElements.length > 0) {
                objectArray = iMemento.createChild(TAG_EXPANDED);
                this.saveElements(this.expandedElements, (IMemento)objectArray);
            }
            if (this.selection instanceof IStructuredSelection && (objectArray = ((IStructuredSelection)this.selection).toArray()).length > 0) {
                IMemento iMemento3 = iMemento.createChild(TAG_SELECTION);
                this.saveElements(objectArray, iMemento3);
            }
        }
    }

    public void setInput(Object object) {
        this.input = object;
    }

    public void setExpandedElements(Object[] objectArray) {
        this.expandedElements = objectArray;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }
}

