/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;

public class TreeViewerFrameSource
implements IFrameSource {
    private AbstractTreeViewer viewer;

    public TreeViewerFrameSource(AbstractTreeViewer abstractTreeViewer) {
        this.viewer = abstractTreeViewer;
    }

    public void connectTo(FrameList frameList) {
        frameList.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TreeViewerFrameSource.this.handlePropertyChange(propertyChangeEvent);
            }
        });
    }

    protected TreeFrame createFrame(Object object) {
        return new TreeFrame(this.viewer, object);
    }

    protected void frameChanged(TreeFrame treeFrame) {
        this.viewer.getControl().setRedraw(false);
        this.viewer.setInput(treeFrame.getInput());
        this.viewer.setExpandedElements(treeFrame.getExpandedElements());
        this.viewer.setSelection(treeFrame.getSelection(), true);
        this.viewer.getControl().setRedraw(true);
    }

    protected Frame getCurrentFrame(int n) {
        Object object = this.viewer.getInput();
        TreeFrame treeFrame = this.createFrame(object);
        if ((n & 1) != 0) {
            treeFrame.setSelection(this.viewer.getSelection());
            treeFrame.setExpandedElements(this.viewer.getExpandedElements());
        }
        return treeFrame;
    }

    public Frame getFrame(int n, int n2) {
        switch (n) {
            case 1: {
                return this.getCurrentFrame(n2);
            }
            case 3: {
                return this.getParentFrame(n2);
            }
            case 2: {
                return this.getSelectionFrame(n2);
            }
        }
        return null;
    }

    protected Frame getParentFrame(int n) {
        Object object = this.viewer.getInput();
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        Object object2 = iTreeContentProvider.getParent(object);
        if (object2 == null) {
            return null;
        }
        TreeFrame treeFrame = this.createFrame(object2);
        if ((n & 1) != 0) {
            treeFrame.setSelection(this.viewer.getSelection());
            Object[] objectArray = this.viewer.getExpandedElements();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
            treeFrame.setExpandedElements(objectArray2);
        }
        return treeFrame;
    }

    protected Frame getSelectionFrame(int n) {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1 && this.viewer.isExpandable(object = iStructuredSelection.getFirstElement())) {
            TreeFrame treeFrame = this.createFrame(object);
            if ((n & 1) != 0) {
                treeFrame.setSelection(this.viewer.getSelection());
                treeFrame.setExpandedElements(this.viewer.getExpandedElements());
            }
            return treeFrame;
        }
        return null;
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentFrame".equals(propertyChangeEvent.getProperty())) {
            this.frameChanged((TreeFrame)propertyChangeEvent.getNewValue());
        }
    }
}

