/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerItem;

public abstract class MarkerField {
    private IConfigurationElement configurationElement;
    private ResourceManager imageManager;

    public Image annotateImage(MarkerItem markerItem, Image image) {
        IMarker iMarker;
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        if (markerItem.getMarker() != null && (iMarker = markerItem.getMarker()) != null) {
            String string = IDE.getMarkerHelpRegistry().getHelp(iMarker);
            if (string != null) {
                if (image == null) {
                    image = JFaceResources.getImage((String)"dialog_help_image");
                } else {
                    imageDescriptorArray[1] = IDEWorkbenchPlugin.getIDEImageDescriptor("markers/help_small.gif");
                }
            }
            if (IDE.getMarkerHelpRegistry().hasResolutions(iMarker)) {
                if (image == null) {
                    image = this.getImageManager().createImage(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ELCL_QUICK_FIX_ENABLED"));
                } else {
                    imageDescriptorArray[3] = IDEWorkbenchPlugin.getIDEImageDescriptor("markers/contassist_ovr.gif");
                }
            }
            if (imageDescriptorArray[1] != null || imageDescriptorArray[3] != null) {
                image = this.getImageManager().createImage((ImageDescriptor)new DecorationOverlayIcon(image, imageDescriptorArray));
            }
        }
        return image;
    }

    public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
        return this.getValue(markerItem).compareTo(this.getValue(markerItem2));
    }

    public Image getColumnHeaderImage() {
        String string = this.configurationElement.getAttribute("icon");
        if (string == null) {
            return null;
        }
        URL uRL = BundleUtility.find((String)this.configurationElement.getContributor().getName(), (String)string);
        if (uRL == null) {
            return null;
        }
        return this.getImageManager().createImageWithDefault(ImageDescriptor.createFromURL((URL)uRL));
    }

    public String getColumnHeaderText() {
        return this.configurationElement.getAttribute("name");
    }

    public String getColumnTooltipText() {
        return this.getColumnHeaderText();
    }

    public final IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public int getDefaultColumnWidth(Control control) {
        return 15 * MarkerSupportInternalUtilities.getFontWidth(control);
    }

    public EditingSupport getEditingSupport(ColumnViewer columnViewer) {
        return null;
    }

    protected ResourceManager getImageManager() {
        if (this.imageManager == null) {
            return IDEWorkbenchPlugin.getDefault().getResourceManager();
        }
        return this.imageManager;
    }

    public abstract String getValue(MarkerItem var1);

    public final void setConfigurationElement(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
    }

    public final void setImageManager(ResourceManager resourceManager) {
        this.imageManager = resourceManager;
    }

    public void update(ViewerCell viewerCell) {
        viewerCell.setText(this.getValue((MarkerItem)viewerCell.getElement()));
    }
}

