/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerSupportView;

public abstract class MarkerViewHandler
extends AbstractHandler {
    private static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];

    public MarkerSupportView getView(ExecutionEvent executionEvent) {
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (iWorkbenchPart == null) {
            return null;
        }
        return (MarkerSupportView)iWorkbenchPart;
    }

    public void execute(IUndoableOperation iUndoableOperation, String string, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(iUndoableOperation, iProgressMonitor, iAdaptable);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, string, executionException.getCause()), 2);
            }
            StatusManager.getManager().handle(StatusUtil.newStatus(4, string, (Throwable)executionException));
        }
    }

    public IMarker[] getSelectedMarkers(ExecutionEvent executionEvent) {
        final MarkerSupportView markerSupportView = this.getView(executionEvent);
        if (markerSupportView == null) {
            return EMPTY_MARKER_ARRAY;
        }
        final IMarker[][] iMarkerArrayArray = new IMarker[1][];
        markerSupportView.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                iMarkerArrayArray[0] = markerSupportView.getSelectedMarkers();
            }
        });
        return iMarkerArrayArray[0];
    }
}

