/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.internal.MarkerView;

public class MarkerViewUtil {
    public static final String PATH_ATTRIBUTE = "org.eclipse.ui.views.markers.path";
    public static final String NAME_ATTRIBUTE = "org.eclipse.ui.views.markers.name";

    public static String getViewId(IMarker iMarker) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return "org.eclipse.ui.views.TaskList";
        }
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return "org.eclipse.ui.views.ProblemView";
        }
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return "org.eclipse.ui.views.BookmarkView";
        }
        return null;
    }

    public static boolean showMarker(IWorkbenchPage iWorkbenchPage, IMarker iMarker, boolean bl) {
        boolean bl2 = false;
        try {
            IViewPart iViewPart;
            String string = MarkerViewUtil.getViewId(iMarker);
            if (string == null) {
                string = "org.eclipse.ui.views.ProblemView";
            }
            IViewPart iViewPart2 = iViewPart = bl ? iWorkbenchPage.showView(string) : iWorkbenchPage.findView(string);
            if (iViewPart != null) {
                bl2 = MarkerSupportInternalUtilities.showMarker(iViewPart, iMarker);
            }
            if ((string = MarkerViewUtil.getLegacyViewId(iMarker)) != null) {
                if (bl2) {
                    iViewPart = iWorkbenchPage.findView(string);
                } else {
                    IViewPart iViewPart3 = iViewPart = bl ? iWorkbenchPage.showView(string) : iWorkbenchPage.findView(string);
                }
            }
            if (iViewPart != null && iViewPart instanceof MarkerView) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iMarker);
                MarkerView markerView = (MarkerView)iViewPart;
                markerView.setSelection((IStructuredSelection)structuredSelection, true);
                bl2 = true;
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
        return bl2;
    }

    private static String getLegacyViewId(IMarker iMarker) throws CoreException {
        String string = MarkerViewUtil.getViewId(iMarker);
        if (string == null) {
            return null;
        }
        return String.valueOf(string) + ".old";
    }
}

