/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionCopyMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private IField[] properties;

    public ActionCopyMarker(IWorkbenchPart iWorkbenchPart, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, MarkerMessages.copyAction_title);
        this.part = iWorkbenchPart;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    void setProperties(IField[] iFieldArray) {
        this.properties = iFieldArray;
    }

    public void run() {
        IMarker[] iMarkerArray = this.getSelectedMarkers();
        this.setClipboard(iMarkerArray, this.createMarkerReport(iMarkerArray));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(Util.allConcreteSelection(iStructuredSelection));
    }

    private void setClipboard(IMarker[] iMarkerArray, String string) {
        block5: {
            try {
                Transfer[] transferArray;
                Object[] objectArray;
                if (string == null) {
                    objectArray = new Object[]{iMarkerArray};
                    transferArray = new Transfer[]{MarkerTransfer.getInstance()};
                } else {
                    objectArray = new Object[]{iMarkerArray, string};
                    transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                }
                this.clipboard.setContents(objectArray, transferArray);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)MarkerMessages.CopyToClipboardProblemDialog_title, (String)MarkerMessages.CopyToClipboardProblemDialog_message)) break block5;
                this.setClipboard(iMarkerArray, string);
            }
        }
    }

    String createMarkerReport(IMarker[] iMarkerArray) {
        ConcreteMarker[] concreteMarkerArray;
        try {
            concreteMarkerArray = MarkerList.createMarkers(iMarkerArray);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)MarkerMessages.Error, null, (IStatus)coreException.getStatus());
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        if (this.properties == null) {
            return null;
        }
        int n = 0;
        while (n < this.properties.length) {
            stringBuffer.append(this.properties[n].getDescription());
            if (n == this.properties.length - 1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('\t');
            }
            ++n;
        }
        n = 0;
        while (n < concreteMarkerArray.length) {
            ConcreteMarker concreteMarker = concreteMarkerArray[n];
            int n2 = 0;
            while (n2 < this.properties.length) {
                stringBuffer.append(this.properties[n2].getValue(concreteMarker));
                if (n2 == this.properties.length - 1) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append('\t');
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

