/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.TaskMarker;
import org.eclipse.ui.views.markers.internal.TaskView;

public class ActionDeleteCompleted
extends MarkerSelectionProviderAction {
    private TaskView part;

    public ActionDeleteCompleted(TaskView taskView, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, MarkerMessages.deleteCompletedAction_title);
        this.part = taskView;
        this.setEnabled(false);
    }

    public void run() {
        List list = this.getCompletedTasks();
        if (list.size() == 0) {
            MessageDialog.openInformation((Shell)this.part.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)MarkerMessages.deleteCompletedTasks_noneCompleted);
            return;
        }
        String string = list.size() == 1 ? MarkerMessages.deleteCompletedTasks_permanentSingular : NLS.bind((String)MarkerMessages.deleteCompletedTasks_permanentPlural, (Object)String.valueOf(list.size()));
        if (!MessageDialog.openConfirm((Shell)this.part.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)string)) {
            return;
        }
        IMarker[] iMarkerArray = list.toArray(new IMarker[list.size()]);
        DeleteMarkersOperation deleteMarkersOperation = new DeleteMarkersOperation(iMarkerArray, this.getText());
        this.execute((IUndoableOperation)deleteMarkersOperation, MarkerMessages.deleteCompletedTasks_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.part.getSite().getShell()));
    }

    private List getCompletedTasks() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        MarkerList markerList = this.part.getVisibleMarkers();
        ConcreteMarker[] concreteMarkerArray = markerList.toArray();
        int n = 0;
        while (n < concreteMarkerArray.length) {
            TaskMarker taskMarker;
            ConcreteMarker concreteMarker = concreteMarkerArray[n];
            if (concreteMarker instanceof TaskMarker && (taskMarker = (TaskMarker)concreteMarker).getDone() == 1) {
                arrayList.add(taskMarker.getMarker());
            }
            ++n;
        }
        return arrayList;
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!iStructuredSelection.isEmpty());
    }
}

