/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionOpenMarker
extends MarkerSelectionProviderAction {
    private final String IMAGE_PATH = "elcl16/gotoobj_tsk.gif";
    private final String DISABLED_IMAGE_PATH = "dlcl16/gotoobj_tsk.gif";
    protected IWorkbenchPart part;

    public ActionOpenMarker(IWorkbenchPart iWorkbenchPart, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, MarkerMessages.openAction_title);
        this.part = iWorkbenchPart;
        this.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.gif"));
        this.setDisabledImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/gotoobj_tsk.gif"));
        this.setEnabled(false);
    }

    public void run() {
        IMarker[] iMarkerArray = this.getSelectedMarkers();
        int n = 0;
        while (n < iMarkerArray.length) {
            IEditorInput iEditorInput;
            Object object;
            IMarker iMarker = iMarkerArray[n];
            IEditorPart iEditorPart = this.part.getSite().getPage().getActiveEditor();
            if (iEditorPart != null && (object = ResourceUtil.getFile(iEditorInput = iEditorPart.getEditorInput())) != null && iMarker.getResource().equals(object)) {
                this.part.getSite().getPage().activate((IWorkbenchPart)iEditorPart);
            }
            if (iMarker.getResource() instanceof IFile) {
                try {
                    iEditorInput = (IFile)iMarker.getResource();
                    if (iEditorInput.getLocation() == null || iEditorInput.getLocationURI() == null) {
                        return;
                    }
                    IDE.openEditor(this.part.getSite().getPage(), iMarker, OpenStrategy.activateOnOpen());
                }
                catch (PartInitException partInitException) {
                    object = null;
                    IStatus iStatus = partInitException.getStatus();
                    if (iStatus != null && iStatus.getException() instanceof CoreException) {
                        object = (CoreException)iStatus.getException();
                    }
                    if (object != null) {
                        this.reportStatus(object.getStatus());
                    }
                    this.reportError(partInitException.getLocalizedMessage());
                }
            }
            ++n;
        }
    }

    private void reportError(String string) {
        Status status = new Status(4, "org.eclipse.ui.ide", string);
        this.reportStatus((IStatus)status);
    }

    private void reportStatus(IStatus iStatus) {
        StatusAdapter statusAdapter = new StatusAdapter(iStatus);
        statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)MarkerMessages.OpenMarker_errorTitle);
        StatusManager.getManager().handle(statusAdapter, 2);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (Util.allConcreteSelection(iStructuredSelection)) {
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                ConcreteMarker concreteMarker = ((MarkerNode)iterator.next()).getConcreteRepresentative();
                if (concreteMarker.getResource().getType() != 1) continue;
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }
}

