/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionPasteMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private String[] pastableTypes;
    private String markerName;

    public ActionPasteMarker(IWorkbenchPart iWorkbenchPart, ISelectionProvider iSelectionProvider, String string) {
        super(iSelectionProvider, MarkerMessages.pasteAction_title);
        this.part = iWorkbenchPart;
        this.pastableTypes = new String[0];
        this.markerName = string;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void run() {
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        IMarker[] iMarkerArray = (IMarker[])this.clipboard.getContents((Transfer)markerTransfer);
        this.paste(iMarkerArray);
    }

    void paste(final IMarker[] iMarkerArray) {
        if (iMarkerArray == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        final ArrayList arrayList3 = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        arrayList.add(iMarkerArray[n].getType());
                        arrayList3.add(iMarkerArray[n].getResource());
                        arrayList2.add(iMarkerArray[n].getAttributes());
                        ++n;
                    }
                }
            }, null);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)MarkerMessages.PasteMarker_errorTitle, null, (IStatus)coreException.getStatus());
            return;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Map[] mapArray = arrayList2.toArray(new Map[arrayList2.size()]);
        IResource[] iResourceArray = arrayList3.toArray(new IResource[arrayList3.size()]);
        String string = NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.pasteAction_title, (Object)this.markerName);
        final CreateMarkersOperation createMarkersOperation = new CreateMarkersOperation(stringArray, mapArray, iResourceArray, string);
        this.execute((IUndoableOperation)createMarkersOperation, MarkerMessages.PasteMarker_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.part.getSite().getShell()));
        if (this.getSelectionProvider() != null && createMarkersOperation.getMarkers() != null) {
            this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ActionPasteMarker.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object[])createMarkersOperation.getMarkers()));
                }
            });
        }
    }

    void updateEnablement() {
        this.setEnabled(false);
        if (this.clipboard == null) {
            return;
        }
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        IMarker[] iMarkerArray = (IMarker[])this.clipboard.getContents((Transfer)markerTransfer);
        if (iMarkerArray == null || iMarkerArray.length < 1 || this.pastableTypes == null) {
            return;
        }
        int n = 0;
        while (n < iMarkerArray.length) {
            try {
                IMarker iMarker = iMarkerArray[n];
                if (!iMarker.exists()) break;
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.pastableTypes.length) {
                    if (iMarker.isSubtypeOf(this.pastableTypes[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return;
                }
                if (!Util.isEditable(iMarker)) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            ++n;
        }
        this.setEnabled(true);
    }

    void setPastableTypes(String[] stringArray) {
        this.pastableTypes = stringArray;
    }
}

