/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionRemoveMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private String markerName;

    public ActionRemoveMarker(IWorkbenchPart iWorkbenchPart, ISelectionProvider iSelectionProvider, String string) {
        super(iSelectionProvider, MarkerMessages.deleteAction_title);
        this.part = iWorkbenchPart;
        this.markerName = string;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setToolTipText(MarkerMessages.deleteAction_tooltip);
        this.setEnabled(false);
    }

    public void run() {
        String string = NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.deleteAction_title, (Object)this.markerName);
        DeleteMarkersOperation deleteMarkersOperation = new DeleteMarkersOperation(this.getSelectedMarkers(), string);
        this.execute((IUndoableOperation)deleteMarkersOperation, MarkerMessages.RemoveMarker_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.part.getSite().getShell()));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(false);
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ConcreteMarker)) {
                return;
            }
            if (Util.isEditable(((ConcreteMarker)e).getMarker())) continue;
            return;
        }
        this.setEnabled(true);
    }
}

