/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerResolutionDialog;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionResolveMarker
extends MarkerSelectionProviderAction {
    private MarkerView view;
    static /* synthetic */ Class class$0;

    public ActionResolveMarker(MarkerView markerView, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, MarkerMessages.resolveMarkerAction_title);
        this.setEnabled(false);
        this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ELCL_QUICK_FIX_ENABLED"));
        this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLCL_QUICK_FIX_DISABLED"));
        this.view = markerView;
    }

    public void run() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.view.getSite().getShell());
        final Object[] objectArray = new Object[1];
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(NLS.bind((String)MarkerMessages.resolveMarkerAction_computationAction, (Object)ActionResolveMarker.this.getMarkerDescription()), 100);
                iProgressMonitor.worked(25);
                objectArray[0] = IDE.getMarkerHelpRegistry().getResolutions(ActionResolveMarker.this.getSelectedMarker());
                iProgressMonitor.done();
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = this.view.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = iWorkbenchPartSite.getAdapter((Class)clazz);
        try {
            if (object == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, null);
            } else {
                ((IWorkbenchSiteProgressService)object).runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, null);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
            return;
        }
        IMarkerResolution[] iMarkerResolutionArray = (IMarkerResolution[])objectArray[0];
        if (iMarkerResolutionArray.length == 0) {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)MarkerMessages.MarkerResolutionDialog_CannotFixTitle, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_CannotFixMessage, (Object)this.getMarkerDescription()));
        } else {
            MarkerResolutionDialog markerResolutionDialog = new MarkerResolutionDialog(this.view.getSite().getShell(), this.getSelectedMarker(), iMarkerResolutionArray, this.view);
            markerResolutionDialog.open();
        }
    }

    private void handleException(Exception exception) {
        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
        ErrorDialog.openError((Shell)this.view.getSite().getShell(), (String)MarkerMessages.Error, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_CannotFixMessage, (Object)this.getMarkerDescription()), (IStatus)Util.errorStatus(exception));
    }

    private String getMarkerDescription() {
        return Util.getProperty("message", this.getSelectedMarker());
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (Util.isSingleConcreteSelection(iStructuredSelection) && IDE.getMarkerHelpRegistry().hasResolutions(this.getSelectedMarker())) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

