/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class BookmarkFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    private boolean contains;
    private String description;

    public BookmarkFilter() {
        this(MarkerMessages.MarkerFilter_defaultFilterName);
    }

    public BookmarkFilter(String string) {
        super(string, new String[]{"org.eclipse.core.resources.bookmark"});
    }

    public boolean selectMarker(ConcreteMarker concreteMarker) {
        return !this.isEnabled() || super.selectMarker(concreteMarker) && this.selectByDescription(concreteMarker);
    }

    private boolean selectByDescription(ConcreteMarker concreteMarker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String string = concreteMarker.getDescription();
        int n = string.indexOf(this.description);
        return this.contains ? n >= 0 : n < 0;
    }

    boolean getContains() {
        return this.contains;
    }

    String getDescription() {
        return this.description;
    }

    void setContains(boolean bl) {
        this.contains = bl;
    }

    void setDescription(String string) {
        this.description = string;
    }

    void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
    }

    public void restoreFilterSettings(IDialogSettings iDialogSettings) {
        super.restoreFilterSettings(iDialogSettings);
        String string = iDialogSettings.get(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
    }

    protected void restoreFilterSettings(IMemento iMemento) {
        super.restoreFilterSettings(iMemento);
        String string = iMemento.getString(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iMemento.getString(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
    }

    public void saveFilterSettings(IMemento iMemento) {
        super.saveFilterSettings(iMemento);
        iMemento.putString(TAG_CONTAINS, String.valueOf(this.contains));
        iMemento.putString(TAG_DESCRIPTION, this.description);
    }
}

