/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogBookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class BookmarkView
extends MarkerView {
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.bookmark"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"message", Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.bookmark";
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object object, String string) {
            if (object instanceof ConcreteMarker && "message".equals(string)) {
                return ((ConcreteMarker)object).getDescription();
            }
            return null;
        }

        public boolean canModify(Object object, String string) {
            return object instanceof ConcreteMarker && "message".equals(string);
        }

        public void modify(Object object, String string, Object object2) {
            Item item;
            Object object3;
            if (object instanceof Item && (object3 = (item = (Item)object).getData()) instanceof ConcreteMarker) {
                IMarker iMarker = ((ConcreteMarker)object3).getMarker();
                try {
                    if (!iMarker.getAttribute(string).equals(object2) && "message".equals(string)) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("message", object2);
                        UpdateMarkersOperation updateMarkersOperation = new UpdateMarkersOperation(iMarker, hashMap, MarkerMessages.modifyBookmark_title, true);
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)updateMarkersOperation, null, WorkspaceUndoUtil.getUIInfoAdapter(BookmarkView.this.getSite().getShell()));
                    }
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        ErrorDialog.openError((Shell)BookmarkView.this.getSite().getShell(), (String)MarkerMessages.errorModifyingBookmark, null, (IStatus)((CoreException)executionException.getCause()).getStatus());
                    } else {
                        IDEWorkbenchPlugin.log(MarkerMessages.errorModifyingBookmark, executionException);
                    }
                }
                catch (CoreException coreException) {
                    ErrorDialog.openError((Shell)BookmarkView.this.getSite().getShell(), (String)MarkerMessages.errorModifyingBookmark, null, (IStatus)coreException.getStatus());
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        TreeViewer treeViewer = this.getViewer();
        CellEditor[] cellEditorArray = new CellEditor[treeViewer.getTree().getColumnCount()];
        TextCellEditor textCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        cellEditorArray[0] = textCellEditor;
        treeViewer.setCellEditors(cellEditorArray);
        treeViewer.setCellModifier(this.cellModifier);
        treeViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)textCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
        this.cellEditorActionHandler.setUndoAction((IAction)this.undoAction);
        this.cellEditorActionHandler.setRedoAction((IAction)this.redoAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return iDialogSettings2;
    }

    protected IField[] getSortingFields() {
        IField[] iFieldArray = new IField[this.VISIBLE_FIELDS.length + this.HIDDEN_FIELDS.length];
        System.arraycopy(this.VISIBLE_FIELDS, 0, iFieldArray, 0, this.VISIBLE_FIELDS.length);
        System.arraycopy(this.HIDDEN_FIELDS, 0, iFieldArray, this.VISIBLE_FIELDS.length, this.HIDDEN_FIELDS.length);
        return iFieldArray;
    }

    protected IField[] getAllFields() {
        return this.getSortingFields();
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    public void setSelection(IStructuredSelection iStructuredSelection, boolean bl) {
        super.setSelection(iStructuredSelection, bl);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.bookmark"};
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] markerFilterArray = this.getUserFilters();
        BookmarkFilter[] bookmarkFilterArray = new BookmarkFilter[markerFilterArray.length];
        System.arraycopy(markerFilterArray, 0, bookmarkFilterArray, 0, markerFilterArray.length);
        return new DialogBookmarkFilter(this.getSite().getShell(), bookmarkFilterArray);
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.bookmark_view_context";
    }

    protected MarkerFilter createFilter(String string) {
        return new BookmarkFilter(string);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    void fillContextMenuAdditions(IMenuManager iMenuManager) {
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_BOOKMARKS";
    }

    String getMarkerLimitPreferenceName() {
        return "BOOKMARKS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "BOOKMARKS_FILTERS";
    }

    protected String getMarkerName() {
        return MarkerMessages.bookmark_title;
    }

    protected IUndoContext getUndoContext() {
        return WorkspaceUndoUtil.getBookmarksUndoContext();
    }
}

