/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DialogBookmarkFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;

    public DialogBookmarkFilter(Shell shell, BookmarkFilter[] bookmarkFilterArray) {
        super(shell, bookmarkFilterArray);
    }

    protected void createAttributesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.verticalSpacing = 7;
        composite2.setLayout((Layout)gridLayout);
        this.descriptionGroup = new DescriptionGroup(composite2);
    }

    protected void updateFilterFromUI(MarkerFilter markerFilter) {
        super.updateFilterFromUI(markerFilter);
        BookmarkFilter bookmarkFilter = (BookmarkFilter)markerFilter;
        bookmarkFilter.setContains(this.descriptionGroup.getContains());
        bookmarkFilter.setDescription(this.descriptionGroup.getDescription().trim());
    }

    protected void updateUIWithFilter(MarkerFilter markerFilter) {
        super.updateUIWithFilter(markerFilter);
        BookmarkFilter bookmarkFilter = (BookmarkFilter)markerFilter;
        this.descriptionGroup.setContains(bookmarkFilter.getContains());
        this.descriptionGroup.setDescription(bookmarkFilter.getDescription());
    }

    protected void updateEnabledState(boolean bl) {
        super.updateEnabledState(bl);
        this.descriptionGroup.updateEnablement(bl);
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        super.resetPressed();
    }

    protected MarkerFilter newFilter(String string) {
        return new BookmarkFilter(string);
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite composite) {
            this.descriptionLabel = new Label(composite, 0);
            this.descriptionLabel.setFont(composite.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(composite, 8);
            this.combo.setFont(composite.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DescriptionGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                        traverseEvent.doit = false;
                    }
                }
            });
            this.description = new Text(composite, 2052);
            this.description.setFont(composite.getFont());
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.description.setLayoutData((Object)gridData);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean bl) {
            if (bl) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String string) {
            if (string == null) {
                this.description.setText("");
            } else {
                this.description.setText(string);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean bl) {
            this.descriptionLabel.setEnabled(bl);
            this.combo.setEnabled(bl);
            this.description.setEnabled(bl);
        }

        static /* synthetic */ DialogBookmarkFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogBookmarkFilter.this;
        }
    }
}

