/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class DialogMarkerFilter
extends TrayDialog {
    static final int SELECT_ALL_FILTERS_ID = 1028;
    static final int DESELECT_ALL_FILTERS_ID = 1029;
    static final int RESET_ID = 1024;
    static final int SELECT_WORKING_SET_ID = 1025;
    static final int SELECT_ALL_ID = 1026;
    static final int DESELECT_ALL_ID = 1027;
    private MarkerFilter[] filters;
    private CheckboxTreeViewer typesViewer;
    private Button anyResourceButton;
    private Button anyResourceInSameProjectButton;
    private Button selectedResourceButton;
    private Button selectedResourceAndChildrenButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private WorkingSetGroup workingSetGroup;
    private boolean dirty = false;
    private CheckboxTableViewer filtersList;
    private MarkerFilter[] selectedFilters;
    private HashMap nodeToTypeMapping = new HashMap();
    private ITreeContentProvider typesContentProvider;

    DialogMarkerFilter(Shell shell, MarkerFilter[] markerFilterArray) {
        super(shell);
        this.setFilters(markerFilterArray);
    }

    private void setFilters(MarkerFilter[] markerFilterArray) {
        MarkerFilter[] markerFilterArray2 = new MarkerFilter[markerFilterArray.length];
        int n = 0;
        while (n < markerFilterArray.length) {
            MarkerFilter markerFilter;
            try {
                markerFilter = markerFilterArray[n].makeClone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)MarkerMessages.MarkerFilterDialog_errorTitle, (String)MarkerMessages.MarkerFilterDialog_failedFilterMessage, (IStatus)Util.errorStatus(cloneNotSupportedException));
                return;
            }
            markerFilterArray2[n] = markerFilter;
            ++n;
        }
        this.filters = markerFilterArray2;
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 1024: {
                this.resetPressed();
                this.markDirty();
                break;
            }
            case 1025: {
                this.workingSetGroup.selectPressed();
                break;
            }
            case 1026: {
                this.setAllTypesChecked(true);
                break;
            }
            case 1027: {
                this.setAllTypesChecked(false);
                break;
            }
            case 1028: {
                this.filtersList.setAllChecked(true);
                break;
            }
            case 1029: {
                this.filtersList.setAllChecked(false);
                break;
            }
        }
        super.buttonPressed(n);
    }

    private void setAllTypesChecked(boolean bl) {
        TreeItem[] treeItemArray = this.typesViewer.getTree().getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            Object object = treeItemArray[n].getData();
            this.typesViewer.setSubtreeChecked(object, bl);
            ++n;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MarkerMessages.filtersDialog_title);
    }

    protected void createResetArea(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(MarkerMessages.restoreDefaults_text);
        button.setData((Object)new Integer(1024));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogMarkerFilter.this.buttonPressed((Integer)selectionEvent.widget.getData());
            }
        });
        GridData gridData = new GridData(128);
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
    }

    protected Button createCheckbox(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 32);
        if (bl) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(string);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        button.setFont(composite.getFont());
        return button;
    }

    protected Combo createCombo(Composite composite, String[] stringArray, int n) {
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(composite.getFont());
        combo.setItems(stringArray);
        combo.select(n);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        return combo;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createFiltersArea(composite2);
        Composite composite3 = this.createSelectedFilterArea(composite2);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.updateUIFromFilter();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)this.filters[0]));
        this.createResetArea(composite2);
        this.createSeparatorLine(composite2);
        DialogMarkerFilter.applyDialogFont((Control)composite2);
        return composite2;
    }

    void createFiltersArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout());
        this.createUserFiltersArea(composite2);
        this.createFilterSelectButtons(composite2);
    }

    void createUserFiltersArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.MarkerFilter_filtersTitle);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.filtersList = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        this.filtersList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return DialogMarkerFilter.this.filters;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.filtersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((MarkerFilter)object).getName();
            }
        });
        this.selectedFilters = new MarkerFilter[]{this.filters[0]};
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object[])this.selectedFilters));
        this.filtersList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DialogMarkerFilter.this.updateFilterFromUI();
                DialogMarkerFilter.this.setSelectedFilter(selectionChangedEvent);
            }
        });
        this.filtersList.setInput((Object)this);
        int n = 0;
        while (n < this.filters.length) {
            this.filtersList.setChecked((Object)this.filters[n], this.filters[n].isEnabled());
            ++n;
        }
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.widthHint = this.convertHorizontalDLUsToPixels(100);
        this.filtersList.getControl().setLayoutData((Object)gridData2);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData3 = new GridData();
        gridData3.verticalAlignment = 1;
        composite3.setLayoutData((Object)gridData3);
        Button button = new Button(composite3, 8);
        button.setText(MarkerMessages.MarkerFilter_addFilterName);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InputDialog inputDialog = new InputDialog(DialogMarkerFilter.this.getShell(), MarkerMessages.MarkerFilterDialog_title, MarkerMessages.MarkerFilterDialog_message, MarkerMessages.MarkerFilter_newFilterName, new IInputValidator(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String string) {
                        if (string.length() == 0) {
                            return MarkerMessages.MarkerFilterDialog_emptyMessage;
                        }
                        int n = 0;
                        while (n < DialogMarkerFilter.access$6(7.access$0(this.this$1)).length) {
                            if (DialogMarkerFilter.access$6(7.access$0(this.this$1))[n].getName().equals(string)) {
                                return NLS.bind((String)MarkerMessages.filtersDialog_conflictingName, (Object)string);
                            }
                            ++n;
                        }
                        return null;
                    }
                });
                inputDialog.open();
                String string = inputDialog.getValue();
                if (string != null) {
                    DialogMarkerFilter.this.createNewFilter(string);
                }
            }

            static /* synthetic */ DialogMarkerFilter access$0(7 var0) {
                return var0.DialogMarkerFilter.this;
            }
        });
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite3, 8);
        button2.setText(MarkerMessages.MarkerFilter_deleteSelectedName);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogMarkerFilter.this.removeFilters(DialogMarkerFilter.this.filtersList.getSelection());
            }
        });
        this.setButtonLayoutData(button2);
    }

    protected void setSelectedFilter(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            MarkerFilter[] markerFilterArray = new MarkerFilter[list.size()];
            list.toArray(markerFilterArray);
            this.selectedFilters = markerFilterArray;
        } else {
            this.selectedFilters = new MarkerFilter[0];
        }
        this.updateUIFromFilter();
    }

    protected void removeFilters(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            MarkerFilter[] markerFilterArray = new MarkerFilter[this.filters.length - list.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < this.filters.length) {
                if (!list.contains(this.filters[n2])) {
                    markerFilterArray[n] = this.filters[n2];
                    ++n;
                }
                ++n2;
            }
            this.filters = markerFilterArray;
            this.filtersList.refresh();
            this.updateUIFromFilter();
        }
    }

    private void createNewFilter(String string) {
        MarkerFilter markerFilter;
        MarkerFilter[] markerFilterArray = new MarkerFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, markerFilterArray, 0, this.filters.length);
        markerFilterArray[this.filters.length] = markerFilter = this.newFilter(string);
        this.filters = markerFilterArray;
        this.filtersList.refresh();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)markerFilter), true);
        this.filtersList.getControl().setFocus();
    }

    protected abstract MarkerFilter newFilter(String var1);

    Composite createSelectedFilterArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createResourceArea(composite3);
        this.createAttributesArea(composite3);
        Composite composite4 = new Composite(composite2, 0);
        this.createTypesArea(composite4);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite2;
    }

    protected void createSeparatorLine(Composite composite) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    protected Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setFont(composite.getFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        return button;
    }

    protected void createResourceArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout());
        composite2.setFont(composite.getFont());
        this.anyResourceButton = this.createRadioButton(composite2, MarkerMessages.filtersDialog_anyResource);
        this.anyResourceInSameProjectButton = this.createRadioButton(composite2, MarkerMessages.filtersDialog_anyResourceInSameProject);
        this.selectedResourceButton = this.createRadioButton(composite2, MarkerMessages.filtersDialog_selectedResource);
        this.selectedResourceAndChildrenButton = this.createRadioButton(composite2, MarkerMessages.filtersDialog_selectedAndChildren);
        this.workingSetGroup = new WorkingSetGroup(composite2);
    }

    protected void createTypesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.filtersDialog_showItemsOfType);
        Tree tree = new Tree(composite2, 68386);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(false);
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        new TreeColumn(tree, 0, 0);
        this.typesViewer = new CheckboxTreeViewer(tree);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertVerticalDLUsToPixels(100);
        gridData.heightHint = this.convertVerticalDLUsToPixels(125);
        this.typesContentProvider = this.getTypesContentProvider();
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)this.typesContentProvider);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.typesViewer.setComparator(this.getComparator());
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                DialogMarkerFilter.this.markDirty();
                Object object = checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                DialogMarkerFilter.this.setChildrenChecked(object, bl);
                DialogMarkerFilter.this.setParentCheckState(object, bl);
            }
        });
        this.typesViewer.setInput((Object)this.getSelectedFilter().getRootTypes().toArray());
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        this.selectAllButton = this.createButton(composite3, 1026, MarkerMessages.filtersDialog_selectAllTypes, false);
        this.deselectAllButton = this.createButton(composite3, 1027, MarkerMessages.filtersDialog_deselectAllTypes, false);
    }

    protected MarkerFilter getSelectedFilter() {
        if (this.selectedFilters.length == 1) {
            return this.selectedFilters[0];
        }
        return null;
    }

    private ITreeContentProvider getTypesContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object object) {
                MarkerFilter markerFilter = DialogMarkerFilter.this.getSelectedFilter();
                if (markerFilter == null) {
                    return new Object[0];
                }
                return DialogMarkerFilter.this.getRootEntries(markerFilter);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getChildren(Object object) {
                return ((AbstractNode)object).getChildren();
            }

            public Object getParent(Object object) {
                return ((AbstractNode)object).getParent();
            }

            public boolean hasChildren(Object object) {
                return ((AbstractNode)object).hasChildren();
            }
        };
    }

    abstract void createAttributesArea(Composite var1);

    private ILabelProvider getLabelProvider() {
        return new TypesLabelProvider();
    }

    protected List getSelectedTypes() {
        Object[] objectArray = this.typesViewer.getCheckedElements();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            AbstractNode abstractNode = (AbstractNode)objectArray[n];
            if (!abstractNode.isCategory()) {
                arrayList.add(((MarkerTypeNode)abstractNode).getMarkerType());
            }
            ++n;
        }
        return arrayList;
    }

    protected ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return this.getComparator().compare(((AbstractNode)object).getName(), ((AbstractNode)object2).getName());
            }
        };
    }

    protected void okPressed() {
        this.updateFilterFromUI();
        int n = 0;
        while (n < this.filters.length) {
            this.filters[n].setEnabled(this.filtersList.getChecked((Object)this.filters[n]));
            ++n;
        }
        super.okPressed();
    }

    protected void resetPressed() {
        this.setAllTypesChecked(true);
        int n = 0;
        this.anyResourceButton.setSelection(n == 0);
        this.anyResourceInSameProjectButton.setSelection(n == 3);
        this.selectedResourceButton.setSelection(n == 1);
        this.selectedResourceAndChildrenButton.setSelection(n == 2);
        this.workingSetGroup.setSelection(n == 4);
        this.updateEnabledState(true);
    }

    void setSelectedTypes(List list) {
        this.typesViewer.setCheckedElements(new Object[0]);
        int n = 0;
        while (n < list.size()) {
            Object v;
            Object e = list.get(n);
            if (e instanceof MarkerType && (v = this.nodeToTypeMapping.get(((MarkerType)e).getId())) != null) {
                this.typesViewer.setChecked(v, true);
                this.setParentCheckState(v, true);
            }
            ++n;
        }
    }

    protected void updateEnabledState(boolean bl) {
        this.typesViewer.getTree().setEnabled(bl);
        this.selectAllButton.setEnabled(bl && this.typesViewer.getTree().getItemCount() > 0);
        this.deselectAllButton.setEnabled(bl && this.typesViewer.getTree().getItemCount() > 0);
        this.anyResourceButton.setEnabled(bl);
        this.anyResourceInSameProjectButton.setEnabled(bl);
        this.selectedResourceButton.setEnabled(bl);
        this.selectedResourceAndChildrenButton.setEnabled(bl);
        this.workingSetGroup.setEnabled(bl);
    }

    protected final void updateFilterFromUI() {
        MarkerFilter markerFilter = this.getSelectedFilter();
        if (markerFilter == null) {
            this.updateEnabledState(false);
            return;
        }
        this.updateFilterFromUI(markerFilter);
    }

    protected void updateFilterFromUI(MarkerFilter markerFilter) {
        markerFilter.setSelectedTypes(this.getSelectedTypes());
        if (this.selectedResourceButton.getSelection()) {
            markerFilter.setOnResource(1);
        } else if (this.selectedResourceAndChildrenButton.getSelection()) {
            markerFilter.setOnResource(2);
        } else if (this.anyResourceInSameProjectButton.getSelection()) {
            markerFilter.setOnResource(3);
        } else if (this.workingSetGroup.getSelection()) {
            markerFilter.setOnResource(4);
        } else {
            markerFilter.setOnResource(0);
        }
        markerFilter.setWorkingSet(this.workingSetGroup.getWorkingSet());
    }

    protected final void updateUIFromFilter() {
        MarkerFilter markerFilter = this.getSelectedFilter();
        if (markerFilter == null) {
            this.updateEnabledState(false);
            return;
        }
        this.updateUIWithFilter(markerFilter);
    }

    protected void updateUIWithFilter(MarkerFilter markerFilter) {
        this.setSelectedTypes(markerFilter.getSelectedTypes());
        int n = markerFilter.getOnResource();
        this.anyResourceButton.setSelection(n == 0);
        this.anyResourceInSameProjectButton.setSelection(n == 3);
        this.selectedResourceButton.setSelection(n == 1);
        this.selectedResourceAndChildrenButton.setSelection(n == 2);
        this.workingSetGroup.setSelection(n == 4);
        this.workingSetGroup.setWorkingSet(markerFilter.getWorkingSet());
        this.updateEnabledState(true);
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markDirty() {
        this.dirty = true;
    }

    public void setFilter(MarkerFilter markerFilter) {
        this.setFilters(new MarkerFilter[]{markerFilter});
        this.updateUIFromFilter();
    }

    public MarkerFilter[] getFilters() {
        return this.filters;
    }

    protected void updateForSelection() {
        this.updateEnabledState(true);
        this.markDirty();
    }

    Object[] getRootEntries(MarkerFilter markerFilter) {
        List list = markerFilter.getRootTypes();
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this.buildTypeTree(arrayList, e, hashMap);
            ++n;
        }
        return arrayList.toArray();
    }

    private void buildTypeTree(List list, Object object, HashMap hashMap) {
        if (object instanceof MarkerType) {
            MarkerType[] markerTypeArray;
            MarkerType markerType = (MarkerType)object;
            String string = MarkerSupportRegistry.getInstance().getCategory(markerType.getId());
            if (string == null) {
                list.add(new MarkerTypeNode(markerType));
            } else {
                if (hashMap.containsKey(string)) {
                    markerTypeArray = (MarkerType[])hashMap.get(string);
                } else {
                    markerTypeArray = new MarkerCategory(string);
                    hashMap.put(string, markerTypeArray);
                    list.add(markerTypeArray);
                }
                MarkerTypeNode markerTypeNode = new MarkerTypeNode(markerType);
                markerTypeArray.add(markerTypeNode);
            }
            markerTypeArray = ((MarkerType)object).getSubtypes();
            int n = 0;
            while (n < markerTypeArray.length) {
                this.buildTypeTree(list, markerTypeArray[n], hashMap);
                ++n;
            }
        }
    }

    private void setParentCheckState(Object object, boolean bl) {
        Object object2 = this.typesContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        Object[] objectArray = this.typesContentProvider.getChildren(object2);
        if (objectArray.length == 0) {
            return;
        }
        if (bl) {
            int n = 0;
            while (n < objectArray.length) {
                Object object3 = objectArray[n];
                if (!this.typesViewer.getChecked(object3)) {
                    this.typesViewer.setGrayChecked(object2, true);
                    return;
                }
                ++n;
            }
            this.typesViewer.setChecked(object2, true);
        } else {
            int n = 0;
            while (n < objectArray.length) {
                Object object4 = objectArray[n];
                if (this.typesViewer.getChecked(object4)) {
                    this.typesViewer.setGrayChecked(object2, true);
                    return;
                }
                ++n;
            }
            this.typesViewer.setChecked(object2, false);
        }
    }

    private void setChildrenChecked(Object object, boolean bl) {
        Object[] objectArray = this.typesContentProvider.getChildren(object);
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.typesViewer.setChecked(objectArray[n], bl);
                ++n;
            }
        }
    }

    protected void createFilterSelectButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createButton(composite2, 1028, MarkerMessages.filtersDialog_selectAll, false);
        this.createButton(composite2, 1029, MarkerMessages.filtersDialog_deselectAll, false);
    }

    protected boolean isResizable() {
        return true;
    }

    private abstract class AbstractNode {
        private AbstractNode() {
        }

        public abstract Object getParent();

        public abstract String getName();

        public abstract boolean hasChildren();

        public abstract Object[] getChildren();

        public abstract boolean isCategory();
    }

    private class MarkerCategory
    extends AbstractNode {
        String name;
        Collection types = new ArrayList();

        public MarkerCategory(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void add(MarkerTypeNode markerTypeNode) {
            this.types.add(markerTypeNode);
            markerTypeNode.setCategory(this);
        }

        public Object[] getMarkerTypes() {
            return this.types.toArray();
        }

        public Object[] getChildren() {
            return this.getMarkerTypes();
        }

        public Object getParent() {
            return null;
        }

        public boolean hasChildren() {
            return true;
        }

        public boolean isCategory() {
            return true;
        }
    }

    private class MarkerTypeNode
    extends AbstractNode {
        MarkerType type;
        MarkerCategory category;

        public MarkerTypeNode(MarkerType markerType) {
            this.type = markerType;
            DialogMarkerFilter.this.nodeToTypeMapping.put(markerType.getId(), this);
        }

        public void setCategory(MarkerCategory markerCategory) {
            this.category = markerCategory;
        }

        public Object[] getChildren() {
            return new Object[0];
        }

        public Object getParent() {
            return this.category;
        }

        public boolean hasChildren() {
            return false;
        }

        public String getName() {
            return this.type.getLabel();
        }

        public boolean isCategory() {
            return false;
        }

        public Object getMarkerType() {
            return this.type;
        }
    }

    private class TypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TypesLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ((AbstractNode)object).getName();
        }
    }

    private class WorkingSetGroup {
        private Button button;
        private Button selectButton;

        WorkingSetGroup(Composite composite) {
            this.button = DialogMarkerFilter.this.createRadioButton(composite, MarkerMessages.filtersDialog_noWorkingSet);
            GridData gridData = new GridData(768);
            this.button.setLayoutData((Object)gridData);
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            Button button = new Button(composite, 16);
            gridLayout.marginWidth = button.computeSize((int)-1, (int)-1).x;
            gridLayout.marginHeight = 0;
            button.dispose();
            composite2.setLayout((Layout)gridLayout);
            this.selectButton = DialogMarkerFilter.this.createButton(composite2, 1025, MarkerMessages.filtersDialog_workingSetSelect, false);
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean bl) {
            this.button.setSelection(bl);
            if (bl) {
                DialogMarkerFilter.this.anyResourceButton.setSelection(false);
                DialogMarkerFilter.this.anyResourceInSameProjectButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceAndChildrenButton.setSelection(false);
            }
        }

        void selectPressed() {
            IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(DialogMarkerFilter.this.getShell(), false);
            IWorkingSet iWorkingSet = this.getWorkingSet();
            if (iWorkingSet != null) {
                iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
            }
            if (iWorkingSetSelectionDialog.open() == 0) {
                DialogMarkerFilter.this.markDirty();
                IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
                if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                    this.setWorkingSet(iWorkingSetArray[0]);
                } else {
                    this.setWorkingSet(null);
                }
                if (!this.getSelection()) {
                    this.setSelection(true);
                }
            }
        }

        void setWorkingSet(IWorkingSet iWorkingSet) {
            this.button.setData((Object)iWorkingSet);
            if (iWorkingSet != null) {
                this.button.setText(NLS.bind((String)MarkerMessages.filtersDialog_workingSet, (Object)iWorkingSet.getLabel()));
            } else {
                this.button.setText(MarkerMessages.filtersDialog_noWorkingSet);
            }
        }

        void setEnabled(boolean bl) {
            this.button.setEnabled(bl);
            this.selectButton.setEnabled(bl);
        }
    }
}

