/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.AbstractMarkersOperation;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class DialogMarkerProperties
extends TrayDialog {
    private static final String DIALOG_SETTINGS_SECTION = "DialogMarkerPropertiesDialogSettings";
    private IMarker marker = null;
    private IResource resource = null;
    private String type = "org.eclipse.core.resources.marker";
    private Map initialAttributes = null;
    private Text descriptionText;
    private Label creationTime;
    private Text resourceText;
    private Text folderText;
    private Text locationText;
    private boolean dirty;
    private String title;
    private String markerName;

    public DialogMarkerProperties(Shell shell) {
        super(shell);
    }

    public DialogMarkerProperties(Shell shell, String string) {
        super(shell);
        this.title = string;
    }

    public DialogMarkerProperties(Shell shell, String string, String string2) {
        super(shell);
        this.title = string;
        this.markerName = string2;
    }

    public void setMarker(IMarker iMarker) {
        this.marker = iMarker;
        if (iMarker != null) {
            try {
                this.type = iMarker.getType();
            }
            catch (CoreException coreException) {}
        }
    }

    protected IMarker getMarker() {
        return this.marker;
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }

    protected IResource getResource() {
        return this.resource;
    }

    protected void setInitialAttributes(Map map) {
        this.initialAttributes = map;
    }

    protected Map getInitialAttributes() {
        if (this.initialAttributes == null) {
            this.initialAttributes = new HashMap();
        }
        return this.initialAttributes;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title == null) {
            shell.setText(MarkerMessages.propertiesDialog_title);
        } else {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite composite) {
        if (this.marker != null) {
            this.resource = this.marker.getResource();
            try {
                this.initialAttributes = this.marker.getAttributes();
            }
            catch (CoreException coreException) {}
        } else if (this.resource == null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite3);
        this.createDescriptionArea(composite3);
        if (this.marker != null) {
            this.createSeperator(composite3);
            this.createCreationTimeArea(composite3);
        }
        this.createAttributesArea(composite3);
        if (this.resource != null) {
            this.createSeperator(composite3);
            this.createResourceArea(composite3);
        }
        this.updateDialogFromMarker();
        this.updateEnablement();
        Dialog.applyDialogFont((Control)composite3);
        return composite3;
    }

    protected void createSeperator(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_creationTime_text);
        this.creationTime = new Label(composite, 0);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDescriptionArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_description_text);
        this.descriptionText = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DialogMarkerProperties.this.markDirty();
            }
        });
    }

    protected void createAttributesArea(Composite composite) {
    }

    private void createResourceArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_resource_text);
        this.resourceText = new Text(composite, 2124);
        GridData gridData = new GridData(768);
        this.resourceText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText(MarkerMessages.propertiesDialog_folder_text);
        this.folderText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.folderText.setLayoutData((Object)gridData);
        Label label3 = new Label(composite, 0);
        label3.setText(MarkerMessages.propertiesDialog_location_text);
        this.locationText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.locationText.setLayoutData((Object)gridData);
    }

    protected void updateDialogFromMarker() {
        if (this.marker == null) {
            this.updateDialogForNewMarker();
            return;
        }
        this.descriptionText.setText(Util.getProperty("message", this.marker));
        if (this.creationTime != null) {
            this.creationTime.setText(Util.getCreationTime(this.marker));
        }
        if (this.resourceText != null) {
            this.resourceText.setText(Util.getResourceName(this.marker));
        }
        if (this.folderText != null) {
            this.folderText.setText(Util.getContainerName(this.marker));
        }
        if (this.locationText != null) {
            String string = Util.getProperty("lineNumber", this.marker);
            if (string.equals("")) {
                this.locationText.setText("");
            } else {
                this.locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, (Object)string));
            }
        }
        this.descriptionText.selectAll();
    }

    protected void updateDialogForNewMarker() {
        Object object;
        if (this.resource != null && this.resourceText != null && this.folderText != null) {
            this.resourceText.setText(this.resource.getName());
            object = this.resource.getFullPath();
            int n = object.segmentCount() - 1;
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    n2 += object.segment(n3).length();
                    ++n3;
                }
                if (n > 1) {
                    n2 += n - 1;
                }
                StringBuffer stringBuffer = new StringBuffer(n2);
                int n4 = 0;
                while (n4 < n) {
                    if (n4 != 0) {
                        stringBuffer.append('/');
                    }
                    stringBuffer.append(object.segment(n4));
                    ++n4;
                }
                this.folderText.setText(stringBuffer.toString());
            }
        }
        if (this.initialAttributes != null) {
            object = this.initialAttributes.get("message");
            if (object != null && object instanceof String) {
                this.descriptionText.setText((String)object);
            }
            this.descriptionText.selectAll();
            Object v = this.initialAttributes.get("lineNumber");
            if (v != null && v instanceof Integer && this.locationText != null) {
                this.locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, v));
            }
        }
    }

    protected void okPressed() {
        if (this.marker == null || Util.isEditable(this.marker)) {
            this.saveChanges();
        }
        super.okPressed();
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    private void saveChanges() {
        Map map = this.getMarkerAttributes();
        AbstractMarkersOperation abstractMarkersOperation = null;
        if (this.marker == null) {
            if (this.resource == null) {
                return;
            }
            abstractMarkersOperation = new CreateMarkersOperation(this.type, map, this.resource, this.getCreateOperationTitle());
        } else if (this.isDirty()) {
            abstractMarkersOperation = new UpdateMarkersOperation(this.marker, map, this.getModifyOperationTitle(), true);
        }
        if (abstractMarkersOperation != null) {
            try {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)abstractMarkersOperation, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)MarkerMessages.Error, null, (IStatus)((CoreException)executionException.getCause()).getStatus());
                }
                IDEWorkbenchPlugin.log(executionException.getMessage(), executionException);
            }
        }
    }

    protected Map getMarkerAttributes() {
        Map map = this.getInitialAttributes();
        map.put("message", this.descriptionText.getText());
        return map;
    }

    protected void updateEnablement() {
        this.descriptionText.setEditable(this.isEditable());
    }

    protected boolean isEditable() {
        if (this.marker == null) {
            return true;
        }
        return Util.isEditable(this.marker);
    }

    protected void setType(String string) {
        this.type = string;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    protected String getModifyOperationTitle() {
        if (this.markerName == null) {
            return MarkerMessages.DialogMarkerProperties_ModifyMarker;
        }
        return NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.DialogMarkerProperties_Modify, (Object)this.markerName);
    }

    protected String getCreateOperationTitle() {
        if (this.markerName == null) {
            return MarkerMessages.DialogMarkerProperties_CreateMarker;
        }
        return NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.DialogMarkerProperties_Create, (Object)this.markerName);
    }

    protected boolean isResizable() {
        return true;
    }
}

