/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class DialogProblemFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private SeverityGroup severityGroup;
    private Composite userFilterComposite;
    private Label systemSettingsLabel;
    private CheckboxTableViewer definedList;

    public DialogProblemFilter(Shell shell, ProblemFilter[] problemFilterArray) {
        super(shell, problemFilterArray);
    }

    protected void createAttributesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.descriptionGroup = new DescriptionGroup(composite2);
        this.severityGroup = new SeverityGroup(composite2);
    }

    protected void updateFilterFromUI(MarkerFilter markerFilter) {
        super.updateFilterFromUI(markerFilter);
        ProblemFilter problemFilter = (ProblemFilter)markerFilter;
        problemFilter.setContains(this.descriptionGroup.getContains());
        problemFilter.setDescription(this.descriptionGroup.getDescription().trim());
        problemFilter.setSelectBySeverity(this.severityGroup.isSeveritySelected());
        int n = 0;
        if (this.severityGroup.isErrorSelected()) {
            n |= 4;
        }
        if (this.severityGroup.isWarningSelected()) {
            n |= 2;
        }
        if (this.severityGroup.isInfoSelected()) {
            n |= 1;
        }
        problemFilter.setSeverity(n);
    }

    protected void updateUIWithFilter(MarkerFilter markerFilter) {
        ProblemFilter problemFilter = (ProblemFilter)markerFilter;
        this.descriptionGroup.setContains(problemFilter.getContains());
        this.descriptionGroup.setDescription(problemFilter.getDescription());
        this.severityGroup.setEnabled(problemFilter.getSelectBySeverity());
        int n = problemFilter.getSeverity();
        this.severityGroup.setErrorSelected((n & 4) > 0);
        this.severityGroup.setWarningSelected((n & 2) > 0);
        this.severityGroup.setInfoSelected((n & 1) > 0);
        super.updateUIWithFilter(markerFilter);
    }

    protected void updateEnabledState(boolean bl) {
        super.updateEnabledState(bl);
        this.descriptionGroup.updateEnablement(bl);
        this.severityGroup.updateEnablement(bl);
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.severityGroup.setEnabled(false);
        this.severityGroup.setErrorSelected(false);
        this.severityGroup.setWarningSelected(false);
        this.severityGroup.setInfoSelected(false);
        super.resetPressed();
    }

    protected MarkerFilter newFilter(String string) {
        return new ProblemFilter(string);
    }

    void createFiltersArea(Composite composite) {
        if (MarkerSupportRegistry.getInstance().getRegisteredFilters().size() == 0) {
            super.createFiltersArea(composite);
            return;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, false, true));
        composite2.setLayout((Layout)new FormLayout());
        Composite composite3 = new Composite(composite2, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(50);
        composite3.setLayoutData((Object)formData);
        composite3.setLayout((Layout)new GridLayout());
        this.createUserFiltersArea(composite3);
        Composite composite4 = new Composite(composite2, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(50);
        formData2.left = new FormAttachment(0);
        formData2.right = new FormAttachment(100);
        formData2.bottom = new FormAttachment(100);
        composite4.setLayoutData((Object)formData2);
        composite4.setLayout((Layout)new GridLayout());
        this.createRegisteredFilters(composite4);
        this.createFilterSelectButtons(composite4);
    }

    private void createRegisteredFilters(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout());
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.ProblemFilterDialog_System_Filters_Title);
        this.definedList = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        this.definedList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return MarkerSupportRegistry.getInstance().getRegisteredFilters().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.definedList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((MarkerFilter)object).getName();
            }
        });
        this.definedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (object == null) {
                        DialogProblemFilter.this.systemSettingsLabel.setText(Util.EMPTY_STRING);
                    } else {
                        DialogProblemFilter.this.systemSettingsLabel.setText(DialogProblemFilter.this.getSystemFilterString((ProblemFilter)object));
                    }
                } else {
                    DialogProblemFilter.this.systemSettingsLabel.setText(Util.EMPTY_STRING);
                }
                DialogProblemFilter.this.showSystemLabel(true);
            }
        });
        Iterator iterator = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        this.definedList.setInput((Object)this);
        while (iterator.hasNext()) {
            MarkerFilter markerFilter = (MarkerFilter)iterator.next();
            this.definedList.setChecked((Object)markerFilter, markerFilter.isEnabled());
        }
        this.definedList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected String getSystemFilterString(ProblemFilter problemFilter) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.getScopeString(problemFilter);
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        if ((string2 = this.getDescriptionString(problemFilter)) != null) {
            stringBuffer.append(Util.TWO_LINE_FEED);
            stringBuffer.append(string2);
        }
        if ((string = this.getSeverityString(problemFilter)) != null) {
            stringBuffer.append(Util.TWO_LINE_FEED);
            stringBuffer.append(string);
        }
        String string4 = this.getProblemTypesString(problemFilter);
        stringBuffer.append(Util.TWO_LINE_FEED);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    private String getProblemTypesString(ProblemFilter problemFilter) {
        List list = problemFilter.getSelectedTypes();
        if (list.size() == this.getRootEntries(problemFilter).length) {
            return MarkerMessages.ProblemFilterDialog_All_Problems;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        stringBuffer.append(MarkerMessages.ProblemFilterDialog_Selected_Types);
        while (iterator.hasNext()) {
            stringBuffer.append(Util.LINE_FEED_AND_TAB);
            stringBuffer.append(((MarkerType)iterator.next()).getLabel());
        }
        return stringBuffer.toString();
    }

    private String getSeverityString(ProblemFilter problemFilter) {
        if (problemFilter.getSelectBySeverity()) {
            switch (problemFilter.getSeverity()) {
                case 1: {
                    return MarkerMessages.ProblemFilterDialog_Info_Severity;
                }
                case 2: {
                    return MarkerMessages.ProblemFilterDialog_Warning_Severity;
                }
                case 4: {
                    return MarkerMessages.ProblemFilterDialog_Error_Severity;
                }
            }
            return null;
        }
        return null;
    }

    private String getDescriptionString(ProblemFilter problemFilter) {
        if (problemFilter.getDescription().length() == 0) {
            return null;
        }
        if (problemFilter.getContains()) {
            return NLS.bind((String)MarkerMessages.ProblemFilterDialog_Contains_Description, (Object)problemFilter.getDescription());
        }
        return NLS.bind((String)MarkerMessages.ProblemFilterDialog_Does_Not_Contain_Description, (Object)problemFilter.getDescription());
    }

    private String getScopeString(ProblemFilter problemFilter) {
        switch (problemFilter.onResource) {
            case 0: {
                return MarkerMessages.ProblemFilterDialog_any;
            }
            case 3: {
                return MarkerMessages.ProblemFilterDialog_sameContainer;
            }
            case 2: {
                return MarkerMessages.ProblemFilterDialog_selectedAndChildren;
            }
            case 1: {
                return MarkerMessages.ProblemFilterDialog_selected;
            }
            case 4: {
                return NLS.bind((String)MarkerMessages.ProblemFilterDialog_workingSet, (Object)problemFilter.getWorkingSet());
            }
        }
        return null;
    }

    protected void setSelectedFilter(SelectionChangedEvent selectionChangedEvent) {
        this.showSystemLabel(false);
        super.setSelectedFilter(selectionChangedEvent);
    }

    protected void showSystemLabel(boolean bl) {
        this.systemSettingsLabel.setVisible(bl);
        this.userFilterComposite.setVisible(!bl);
        this.userFilterComposite.getParent().layout();
    }

    Composite createSelectedFilterArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        composite2.setLayout((Layout)formLayout);
        this.systemSettingsLabel = this.createSystemSettingsLabel(composite2);
        this.systemSettingsLabel.setVisible(false);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 7);
        formData.left = new FormAttachment(0, 7);
        formData.right = new FormAttachment(100, -7);
        formData.bottom = new FormAttachment(100, -7);
        this.systemSettingsLabel.setLayoutData((Object)formData);
        this.userFilterComposite = super.createSelectedFilterArea(composite2);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0);
        formData2.left = new FormAttachment(0);
        formData2.right = new FormAttachment(100);
        formData2.bottom = new FormAttachment(100);
        this.userFilterComposite.setLayoutData((Object)formData2);
        return composite2;
    }

    private Label createSystemSettingsLabel(Composite composite) {
        return new Label(composite, 0);
    }

    protected void buttonPressed(int n) {
        if (this.definedList != null) {
            if (n == 1028) {
                this.definedList.setAllChecked(true);
            } else if (n == 1029) {
                this.definedList.setAllChecked(false);
            }
        }
        super.buttonPressed(n);
    }

    protected void okPressed() {
        Iterator iterator = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        while (iterator.hasNext()) {
            ProblemFilter problemFilter = (ProblemFilter)iterator.next();
            problemFilter.setEnabled(this.definedList.getChecked((Object)problemFilter));
        }
        super.okPressed();
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            composite2.setLayoutData((Object)new GridData(768));
            this.descriptionLabel = new Label(composite2, 0);
            this.descriptionLabel.setFont(composite.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(composite2, 8);
            this.combo.setFont(composite.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DescriptionGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                        traverseEvent.doit = false;
                    }
                }
            });
            this.description = new Text(composite2, 2052);
            this.description.setFont(composite.getFont());
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.description.setLayoutData((Object)gridData);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean bl) {
            if (bl) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String string) {
            if (string == null) {
                this.description.setText("");
            } else {
                this.description.setText(string);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean bl) {
            this.descriptionLabel.setEnabled(bl);
            this.combo.setEnabled(bl);
            this.description.setEnabled(bl);
        }

        static /* synthetic */ DialogProblemFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogProblemFilter.this;
        }
    }

    private class SeverityGroup {
        private Button enablementButton;
        private Button errorButton;
        private Button warningButton;
        private Button infoButton;

        public SeverityGroup(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(4, false));
            composite2.setLayoutData((Object)new GridData(768));
            SelectionAdapter selectionAdapter = new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.updateEnablement(true);
                    SeverityGroup.access$0(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(composite2, 32);
            GridData gridData = new GridData(768);
            this.enablementButton.setLayoutData((Object)gridData);
            this.enablementButton.setFont(composite.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_severityLabel);
            this.enablementButton.addSelectionListener((SelectionListener)selectionAdapter);
            this.errorButton = new Button(composite2, 32);
            this.errorButton.setFont(composite.getFont());
            this.errorButton.setText(MarkerMessages.filtersDialog_severityError);
            this.errorButton.setLayoutData((Object)new GridData(768));
            this.errorButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.warningButton = new Button(composite2, 32);
            this.warningButton.setFont(composite.getFont());
            this.warningButton.setText(MarkerMessages.filtersDialog_severityWarning);
            this.warningButton.setLayoutData((Object)new GridData(768));
            this.warningButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.infoButton = new Button(composite2, 32);
            this.infoButton.setFont(composite.getFont());
            this.infoButton.setText(MarkerMessages.filtersDialog_severityInfo);
            this.infoButton.setLayoutData((Object)new GridData(768));
            this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
        }

        public boolean isSeveritySelected() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean bl) {
            this.enablementButton.setSelection(bl);
        }

        public boolean isErrorSelected() {
            return this.errorButton.getSelection();
        }

        public void setErrorSelected(boolean bl) {
            this.errorButton.setSelection(bl);
        }

        public boolean isWarningSelected() {
            return this.warningButton.getSelection();
        }

        public void setWarningSelected(boolean bl) {
            this.warningButton.setSelection(bl);
        }

        public boolean isInfoSelected() {
            return this.infoButton.getSelection();
        }

        public void setInfoSelected(boolean bl) {
            this.infoButton.setSelection(bl);
        }

        public void updateEnablement(boolean bl) {
            boolean bl2 = this.isSeveritySelected();
            this.enablementButton.setEnabled(bl);
            this.errorButton.setEnabled(bl2 && bl);
            this.warningButton.setEnabled(bl2 && bl);
            this.infoButton.setEnabled(bl2 && bl);
        }

        static /* synthetic */ DialogProblemFilter access$0(SeverityGroup severityGroup) {
            return severityGroup.DialogProblemFilter.this;
        }
    }
}

