/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class DialogProblemProperties
extends DialogMarkerProperties {
    private Label severityLabel;
    private Label severityImage;

    public DialogProblemProperties(Shell shell) {
        super(shell);
        this.setType("org.eclipse.core.resources.problemmarker");
    }

    protected void createAttributesArea(Composite composite) {
        this.createSeperator(composite);
        super.createAttributesArea(composite);
        new Label(composite, 0).setText(MarkerMessages.propertiesDialog_severityLabel);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.severityImage = new Label(composite2, 0);
        this.severityLabel = new Label(composite2, 0);
    }

    protected void updateDialogFromMarker() {
        super.updateDialogFromMarker();
        IMarker iMarker = this.getMarker();
        if (iMarker == null) {
            return;
        }
        this.severityImage.setImage(Util.getImage(iMarker.getAttribute("severity", -1)));
        int n = iMarker.getAttribute("severity", -1);
        if (n == 2) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_errorLabel);
        } else if (n == 1) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_warningLabel);
        } else if (n == 0) {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_infoLabel);
        } else {
            this.severityLabel.setText(MarkerMessages.propertiesDialog_noseverityLabel);
        }
    }
}

