/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.TaskFilter;

public class DialogTaskFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private PriorityGroup priorityGroup;
    private StatusGroup statusGroup;

    public DialogTaskFilter(Shell shell, TaskFilter[] taskFilterArray) {
        super(shell, taskFilterArray);
    }

    protected void createAttributesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.verticalSpacing = 7;
        composite2.setLayout((Layout)gridLayout);
        this.descriptionGroup = new DescriptionGroup(composite2);
        this.priorityGroup = new PriorityGroup(composite2);
        this.statusGroup = new StatusGroup(composite2);
    }

    protected void updateFilterFromUI(MarkerFilter markerFilter) {
        super.updateFilterFromUI(markerFilter);
        TaskFilter taskFilter = (TaskFilter)markerFilter;
        taskFilter.setContains(this.descriptionGroup.getContains());
        taskFilter.setDescription(this.descriptionGroup.getDescription().trim());
        taskFilter.setSelectByPriority(this.priorityGroup.isPriorityEnabled());
        int n = 0;
        if (this.priorityGroup.isHighSelected()) {
            n |= 4;
        }
        if (this.priorityGroup.isNormalSelected()) {
            n |= 2;
        }
        if (this.priorityGroup.isLowSelected()) {
            n |= 1;
        }
        taskFilter.setPriority(n);
        taskFilter.setSelectByDone(this.statusGroup.isStatusEnabled());
        taskFilter.setDone(this.statusGroup.getDone());
    }

    protected void updateUIWithFilter(MarkerFilter markerFilter) {
        TaskFilter taskFilter = (TaskFilter)markerFilter;
        this.descriptionGroup.setContains(taskFilter.getContains());
        this.descriptionGroup.setDescription(taskFilter.getDescription());
        this.priorityGroup.setEnabled(taskFilter.getSelectByPriority());
        int n = taskFilter.getPriority();
        this.priorityGroup.setHighSelected((n & 4) > 0);
        this.priorityGroup.setNormalSelected((n & 2) > 0);
        this.priorityGroup.setLowSelected((n & 1) > 0);
        this.statusGroup.setEnabled(taskFilter.getSelectByDone());
        this.statusGroup.setDone(taskFilter.getDone());
        super.updateUIWithFilter(markerFilter);
    }

    protected void updateEnabledState(boolean bl) {
        super.updateEnabledState(bl);
        this.descriptionGroup.updateEnablement(bl);
        this.priorityGroup.updateEnablement(bl);
        this.statusGroup.updateEnablement(bl);
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.priorityGroup.setEnabled(false);
        this.priorityGroup.setHighSelected(false);
        this.priorityGroup.setNormalSelected(false);
        this.priorityGroup.setLowSelected(false);
        this.statusGroup.setEnabled(false);
        this.statusGroup.setDone(false);
        super.resetPressed();
    }

    protected MarkerFilter newFilter(String string) {
        return new TaskFilter(string);
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite composite) {
            this.descriptionLabel = new Label(composite, 0);
            this.descriptionLabel.setFont(composite.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(composite, 8);
            this.combo.setFont(composite.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DescriptionGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                        traverseEvent.doit = false;
                    }
                }
            });
            this.description = new Text(composite, 2052);
            this.description.setFont(composite.getFont());
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.description.setLayoutData((Object)gridData);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean bl) {
            if (bl) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String string) {
            if (string == null) {
                this.description.setText("");
            } else {
                this.description.setText(string);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean bl) {
            this.descriptionLabel.setEnabled(bl);
            this.combo.setEnabled(bl);
            this.description.setEnabled(bl);
        }

        static /* synthetic */ DialogTaskFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogTaskFilter.this;
        }
    }

    private class PriorityGroup {
        private Button enablementButton;
        private Button highButton;
        private Button normalButton;
        private Button lowButton;

        public PriorityGroup(Composite composite) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(this){
                final /* synthetic */ PriorityGroup this$1;
                {
                    this.this$1 = priorityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.updateEnablement(true);
                    PriorityGroup.access$0(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(composite, 32);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)gridData);
            this.enablementButton.setFont(composite.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_priorityLabel);
            this.enablementButton.addSelectionListener((SelectionListener)selectionAdapter);
            this.highButton = new Button(composite, 32);
            this.highButton.setFont(composite.getFont());
            this.highButton.setText(MarkerMessages.filtersDialog_priorityHigh);
            this.highButton.setLayoutData((Object)new GridData(768));
            this.highButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PriorityGroup this$1;
                {
                    this.this$1 = priorityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PriorityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.normalButton = new Button(composite, 32);
            this.normalButton.setFont(composite.getFont());
            this.normalButton.setText(MarkerMessages.filtersDialog_priorityNormal);
            this.normalButton.setLayoutData((Object)new GridData(768));
            this.normalButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PriorityGroup this$1;
                {
                    this.this$1 = priorityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PriorityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.lowButton = new Button(composite, 32);
            this.lowButton.setFont(composite.getFont());
            this.lowButton.setText(MarkerMessages.filtersDialog_priorityLow);
            this.lowButton.setLayoutData((Object)new GridData(768));
            this.lowButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PriorityGroup this$1;
                {
                    this.this$1 = priorityGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PriorityGroup.access$0(this.this$1).updateForSelection();
                }
            });
        }

        public boolean isPriorityEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean bl) {
            this.enablementButton.setSelection(bl);
        }

        public boolean isHighSelected() {
            return this.highButton.getSelection();
        }

        public void setHighSelected(boolean bl) {
            this.highButton.setSelection(bl);
        }

        public boolean isNormalSelected() {
            return this.normalButton.getSelection();
        }

        public void setNormalSelected(boolean bl) {
            this.normalButton.setSelection(bl);
        }

        public boolean isLowSelected() {
            return this.lowButton.getSelection();
        }

        public void setLowSelected(boolean bl) {
            this.lowButton.setSelection(bl);
        }

        public void updateEnablement(boolean bl) {
            this.enablementButton.setEnabled(bl);
            this.highButton.setEnabled(bl && this.isPriorityEnabled());
            this.normalButton.setEnabled(bl && this.isPriorityEnabled());
            this.lowButton.setEnabled(bl && this.isPriorityEnabled());
        }

        static /* synthetic */ DialogTaskFilter access$0(PriorityGroup priorityGroup) {
            return priorityGroup.DialogTaskFilter.this;
        }
    }

    private class StatusGroup {
        private Button enablementButton;
        private Button completeButton;
        private Button incompleteButton;

        public StatusGroup(Composite composite) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(this){
                final /* synthetic */ StatusGroup this$1;
                {
                    this.this$1 = statusGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.updateEnablement(true);
                    StatusGroup.access$2(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(composite, 32);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)gridData);
            this.enablementButton.setFont(composite.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_statusLabel);
            this.enablementButton.addSelectionListener((SelectionListener)selectionAdapter);
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            composite2.setLayoutData((Object)gridData);
            SelectionAdapter selectionAdapter2 = new SelectionAdapter(this){
                final /* synthetic */ StatusGroup this$1;
                {
                    this.this$1 = statusGroup;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    StatusGroup.access$0(this.this$1).setSelection(!StatusGroup.access$1(this.this$1).getSelection());
                    StatusGroup.access$1(this.this$1).setSelection(!StatusGroup.access$0(this.this$1).getSelection());
                    StatusGroup.access$2(this.this$1).markDirty();
                }
            };
            this.completeButton = new Button(composite2, 16);
            this.completeButton.setFont(composite2.getFont());
            this.completeButton.setText(MarkerMessages.filtersDialog_statusComplete);
            this.completeButton.addSelectionListener((SelectionListener)selectionAdapter2);
            this.incompleteButton = new Button(composite2, 16);
            this.incompleteButton.setFont(composite2.getFont());
            this.incompleteButton.setText(MarkerMessages.filtersDialog_statusIncomplete);
            this.incompleteButton.addSelectionListener((SelectionListener)selectionAdapter2);
        }

        public boolean isStatusEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean bl) {
            this.enablementButton.setSelection(bl);
        }

        public boolean getDone() {
            return this.completeButton.getSelection();
        }

        public void setDone(boolean bl) {
            this.completeButton.setSelection(bl);
            this.incompleteButton.setSelection(!bl);
        }

        public void updateEnablement(boolean bl) {
            this.enablementButton.setEnabled(bl);
            this.completeButton.setEnabled(this.isStatusEnabled() && bl);
            this.incompleteButton.setEnabled(this.isStatusEnabled() && bl);
        }

        static /* synthetic */ Button access$0(StatusGroup statusGroup) {
            return statusGroup.completeButton;
        }

        static /* synthetic */ Button access$1(StatusGroup statusGroup) {
            return statusGroup.incompleteButton;
        }

        static /* synthetic */ DialogTaskFilter access$2(StatusGroup statusGroup) {
            return statusGroup.DialogTaskFilter.this;
        }
    }
}

