/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DialogTaskProperties
extends DialogMarkerProperties {
    private static final String PRIORITY_HIGH = MarkerMessages.propertiesDialog_priorityHigh;
    private static final String PRIORITY_NORMAL = MarkerMessages.propertiesDialog_priorityNormal;
    private static final String PRIORITY_LOW = MarkerMessages.propertiesDialog_priorityLow;
    protected Combo priorityCombo;
    protected Button completedCheckbox;

    public DialogTaskProperties(Shell shell) {
        super(shell);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    public DialogTaskProperties(Shell shell, String string) {
        super(shell, string);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    protected void createAttributesArea(Composite composite) {
        this.createSeperator(composite);
        super.createAttributesArea(composite);
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.propertiesDialog_priority);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.priorityCombo = new Combo(composite2, 8);
        this.priorityCombo.setItems(new String[]{PRIORITY_HIGH, PRIORITY_NORMAL, PRIORITY_LOW});
        this.priorityCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map map = DialogTaskProperties.this.getInitialAttributes();
                    map.put("priority", new Integer(DialogTaskProperties.this.getPriorityFromDialog()));
                }
                DialogTaskProperties.this.markDirty();
            }
        });
        this.completedCheckbox = new Button(composite2, 32);
        this.completedCheckbox.setText(MarkerMessages.propertiesDialog_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map map = DialogTaskProperties.this.getInitialAttributes();
                    map.put("done", DialogTaskProperties.this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
                }
                DialogTaskProperties.this.markDirty();
            }
        });
    }

    protected boolean getCompleted() {
        IMarker iMarker = this.getMarker();
        if (iMarker == null) {
            Map map = this.getInitialAttributes();
            Object v = map.get("done");
            return v != null && v instanceof Boolean && (Boolean)v != false;
        }
        return iMarker.getAttribute("done", false);
    }

    protected int getPriority() {
        IMarker iMarker = this.getMarker();
        int n = 1;
        if (iMarker == null) {
            Map map = this.getInitialAttributes();
            Object v = map.get("priority");
            if (v != null && v instanceof Integer) {
                n = (Integer)v;
            }
        } else {
            n = iMarker.getAttribute("priority", 1);
        }
        return n;
    }

    protected void updateEnablement() {
        super.updateEnablement();
        this.priorityCombo.setEnabled(this.isEditable());
        this.completedCheckbox.setEnabled(this.isEditable());
    }

    protected void updateDialogForNewMarker() {
        Map map = this.getInitialAttributes();
        int n = this.getPriority();
        map.put("priority", new Integer(n));
        if (n == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (n == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean bl = this.getCompleted();
        map.put("done", bl ? Boolean.TRUE : Boolean.FALSE);
        this.completedCheckbox.setSelection(bl);
        super.updateDialogForNewMarker();
    }

    protected void updateDialogFromMarker() {
        Map map = this.getInitialAttributes();
        int n = this.getPriority();
        map.put("priority", new Integer(n));
        if (n == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (n == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean bl = this.getCompleted();
        map.put("done", bl ? Boolean.TRUE : Boolean.FALSE);
        this.completedCheckbox.setSelection(bl);
        super.updateDialogFromMarker();
    }

    private int getPriorityFromDialog() {
        int n = 1;
        if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_HIGH)) {
            n = 2;
        } else if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_LOW)) {
            n = 0;
        }
        return n;
    }

    protected Map getMarkerAttributes() {
        Map map = super.getMarkerAttributes();
        map.put("priority", new Integer(this.getPriorityFromDialog()));
        map.put("done", this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
        Object v = map.get("userEditable");
        if (v == null || !(v instanceof Boolean)) {
            map.put("userEditable", Boolean.TRUE);
        }
        return map;
    }

    protected String getModifyOperationTitle() {
        return MarkerMessages.modifyTask_title;
    }

    protected String getCreateOperationTitle() {
        return MarkerMessages.DialogTaskProperties_CreateTask;
    }
}

