/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.internal.AbstractField;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Util;

public class FieldCategory
extends AbstractField {
    public String getDescription() {
        return MarkerMessages.description_type;
    }

    public Image getDescriptionImage() {
        return null;
    }

    public String getColumnHeaderText() {
        return this.getDescription();
    }

    public Image getColumnHeaderImage() {
        return null;
    }

    public String getValue(Object object) {
        if (object instanceof ConcreteMarker) {
            ConcreteMarker concreteMarker = (ConcreteMarker)object;
            if (concreteMarker.getGroup() == null) {
                if (!concreteMarker.getMarker().exists()) {
                    return MarkerMessages.FieldCategory_Uncategorized;
                }
                String string = MarkerSupportRegistry.getInstance().getCategory(concreteMarker.getMarker());
                if (string == null) {
                    String string2;
                    try {
                        string2 = concreteMarker.getMarker().getType();
                    }
                    catch (CoreException coreException) {
                        Policy.handle(coreException);
                        return MarkerMessages.FieldCategory_Uncategorized;
                    }
                    MarkerType markerType = MarkerTypesModel.getInstance().getType(string2);
                    string = markerType.getLabel();
                }
                concreteMarker.setGroup(string);
            }
            return (String)concreteMarker.getGroup();
        }
        return Util.EMPTY_STRING;
    }

    public Image getImage(Object object) {
        return null;
    }

    public int compare(Object object, Object object2) {
        return this.getValue(object).compareTo(this.getValue(object2));
    }

    public int getDefaultDirection() {
        return 1;
    }

    public int getPreferredWidth() {
        return 200;
    }
}

