/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.markers.internal.AbstractField;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.Util;

public class FieldLineNumber
extends AbstractField {
    private String description = MarkerMessages.description_lineNumber;
    private Image image;

    public String getDescription() {
        return this.description;
    }

    public Image getDescriptionImage() {
        return this.image;
    }

    public String getColumnHeaderText() {
        return this.description;
    }

    public Image getColumnHeaderImage() {
        return this.image;
    }

    public String getValue(Object object) {
        if (object == null) {
            return MarkerMessages.FieldMessage_NullMessage;
        }
        if (object instanceof MarkerNode) {
            MarkerNode markerNode = (MarkerNode)object;
            if (markerNode.isConcrete()) {
                ConcreteMarker concreteMarker = (ConcreteMarker)markerNode;
                if (concreteMarker.getLocationString().length() == 0) {
                    if (concreteMarker.getLine() < 0) {
                        return MarkerMessages.Unknown;
                    }
                    return NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(concreteMarker.getLine()));
                }
                return concreteMarker.getLocationString();
            }
            return Util.EMPTY_STRING;
        }
        if (object instanceof IWorkbenchAdapter) {
            return Util.EMPTY_STRING;
        }
        if (object instanceof IMarker) {
            return Util.getProperty("lineNumber", (IMarker)object);
        }
        return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)object.toString());
    }

    public Image getImage(Object object) {
        return null;
    }

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null || !(object instanceof ConcreteMarker) || !(object2 instanceof ConcreteMarker)) {
            return 0;
        }
        ConcreteMarker concreteMarker = (ConcreteMarker)object;
        ConcreteMarker concreteMarker2 = (ConcreteMarker)object2;
        String string = concreteMarker.getLocationString();
        String string2 = concreteMarker2.getLocationString();
        if (string.length() == 0 || string2.length() == 0) {
            return concreteMarker.getLine() - concreteMarker2.getLine();
        }
        return string.compareTo(string2);
    }

    public int getDefaultDirection() {
        return 1;
    }

    public int getPreferredWidth() {
        return 60;
    }
}

