/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.internal.CategoryComparator;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.SortUtil;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerAdapter {
    MarkerView view;
    private MarkerList lastMarkers;
    private MarkerCategory[] categories;
    private boolean building = true;

    MarkerAdapter(MarkerView markerView) {
        this.view = markerView;
    }

    public CategoryComparator getCategorySorter() {
        return (CategoryComparator)this.view.getViewer().getComparator();
    }

    public void buildAllMarkers(IProgressMonitor iProgressMonitor) {
        this.building = true;
        try {
            MarkerList markerList;
            int n;
            block23: {
                n = this.view.getMarkerLimit();
                iProgressMonitor.beginTask(MarkerMessages.MarkerView_19, n == -1 ? 60 : 100);
                try {
                    iProgressMonitor.subTask(MarkerMessages.MarkerView_waiting_on_changes);
                    if (!iProgressMonitor.isCanceled()) break block23;
                    return;
                }
                catch (CoreException coreException) {
                    Policy.handle(coreException);
                    markerList = new MarkerList();
                    return;
                }
            }
            iProgressMonitor.subTask(MarkerMessages.MarkerView_searching_for_markers);
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
            MarkerCategory[] markerCategoryArray = this.view.getEnabledFilters();
            markerList = markerCategoryArray.length > 0 ? MarkerList.compute((MarkerFilter[])markerCategoryArray, (IProgressMonitor)subProgressMonitor, true) : MarkerList.compute(new MarkerFilter[]{this.view.getAllFilters()[0]}, (IProgressMonitor)subProgressMonitor, true);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            this.view.refreshMarkerCounts(iProgressMonitor);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            subProgressMonitor = this.view.getViewer().getComparator();
            if (n == -1 || this.isShowingHierarchy()) {
                subProgressMonitor.sort((Viewer)this.view.getViewer(), (Object[])markerList.toArray());
            } else {
                iProgressMonitor.subTask(MarkerMessages.MarkerView_18);
                markerCategoryArray = new SubProgressMonitor(iProgressMonitor, 40);
                markerList = SortUtil.getFirst(markerList, (Comparator)subProgressMonitor, n, (IProgressMonitor)markerCategoryArray);
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                subProgressMonitor.sort((Viewer)this.view.getViewer(), (Object[])markerList.toArray());
            }
            if (markerList.getSize() == 0) {
                this.categories = new MarkerCategory[0];
                this.lastMarkers = markerList;
                iProgressMonitor.done();
                return;
            }
            iProgressMonitor.subTask(MarkerMessages.MarkerView_queueing_updates);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            if (this.isShowingHierarchy()) {
                markerCategoryArray = this.buildHierarchy(markerList, 0, markerList.getSize() - 1, 0);
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                this.categories = markerCategoryArray;
            }
            this.lastMarkers = markerList;
            iProgressMonitor.done();
        }
        finally {
            this.building = false;
        }
    }

    boolean isShowingHierarchy() {
        ViewerComparator viewerComparator = this.view.getViewer().getComparator();
        if (viewerComparator instanceof CategoryComparator) {
            return ((CategoryComparator)viewerComparator).getCategoryField() != null;
        }
        return false;
    }

    MarkerCategory[] buildHierarchy(MarkerList markerList, int n, int n2, int n3) {
        CategoryComparator categoryComparator = this.getCategorySorter();
        if (n3 > 0) {
            return null;
        }
        ArrayList<MarkerCategory> arrayList = new ArrayList<MarkerCategory>();
        Object object = null;
        int n4 = n;
        Object[] objectArray = markerList.getArray();
        int n5 = n;
        while (n5 <= n2) {
            if (object != null && categoryComparator.compare(object, objectArray[n5], n3, false) != 0) {
                arrayList.add(new MarkerCategory(this, n4, n5 - 1, this.getNameForIndex(markerList, n4)));
                n4 = n5;
            }
            object = objectArray[n5];
            ++n5;
        }
        if (n2 >= n4) {
            arrayList.add(new MarkerCategory(this, n4, n2, this.getNameForIndex(markerList, n4)));
        }
        MarkerCategory[] markerCategoryArray = new MarkerCategory[arrayList.size()];
        arrayList.toArray(markerCategoryArray);
        return markerCategoryArray;
    }

    private String getNameForIndex(MarkerList markerList, int n) {
        return this.getCategorySorter().getCategoryField().getValue(markerList.toArray()[n]);
    }

    public MarkerList getCurrentMarkers() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return new MarkerList();
        }
        return this.lastMarkers;
    }

    public Object[] getElements() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return Util.EMPTY_MARKER_ARRAY;
        }
        if (this.isShowingHierarchy() && this.categories != null) {
            return this.categories;
        }
        return this.lastMarkers.toArray();
    }

    public boolean hasNoMarkers() {
        return this.lastMarkers == null;
    }

    public MarkerCategory[] getCategories() {
        if (this.building) {
            return null;
        }
        return this.categories;
    }

    boolean isBuilding() {
        return this.building;
    }

    class MarkerCategory
    extends MarkerNode {
        MarkerAdapter markerAdapter;
        int start;
        int end;
        private ConcreteMarker[] children;
        private String name;

        MarkerCategory(MarkerAdapter markerAdapter2, int n, int n2, String string) {
            this.markerAdapter = markerAdapter2;
            this.start = n;
            this.end = n2;
            this.name = string;
        }

        public MarkerNode[] getChildren() {
            if (this.children == null) {
                if (MarkerAdapter.this.building) {
                    return Util.EMPTY_MARKER_ARRAY;
                }
                ConcreteMarker[] concreteMarkerArray = this.markerAdapter.lastMarkers.toArray();
                int n = this.getDisplayedSize();
                this.children = new ConcreteMarker[n];
                System.arraycopy(concreteMarkerArray, this.start, this.children, 0, n);
                MarkerAdapter.this.view.getTableSorter().sort((Viewer)MarkerAdapter.this.view.getViewer(), this.children);
                int n2 = 0;
                while (n2 < this.children.length) {
                    this.children[n2].setCategory(this);
                    ++n2;
                }
            }
            return this.children;
        }

        int getDisplayedSize() {
            if (MarkerAdapter.this.view.getMarkerLimit() > 0) {
                return Math.min(this.getTotalSize(), MarkerAdapter.this.view.getMarkerLimit());
            }
            return this.getTotalSize();
        }

        public MarkerNode getParent() {
            return null;
        }

        public String getDescription() {
            int n = this.end - this.start + 1;
            if (n <= MarkerAdapter.this.view.getMarkerLimit()) {
                if (n == 1) {
                    return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
                }
                return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize())});
            }
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize()), String.valueOf(this.getTotalSize())});
        }

        private int getTotalSize() {
            return this.end - this.start + 1;
        }

        public boolean isConcrete() {
            return false;
        }

        public ConcreteMarker getConcreteRepresentative() {
            return this.markerAdapter.lastMarkers.getMarker(this.start);
        }

        public String getName() {
            return this.name;
        }
    }
}

