/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerFilter
implements Cloneable {
    static final String TAG_ENABLED = "enabled";
    public static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_SELECTED_TYPES = "selectedType";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_TYPES_DELIMITER = ":";
    public static final String TAG_SELECTION_STATUS = "selectionStatus";
    public static final String SELECTED_FALSE = "false";
    private static final String SELECTED_TRUE = "true";
    public static final int ON_ANY = 0;
    public static final int ON_SELECTED_ONLY = 1;
    public static final int ON_SELECTED_AND_CHILDREN = 2;
    public static final int ON_ANY_IN_SAME_CONTAINER = 3;
    public static final int ON_WORKING_SET = 4;
    static final int DEFAULT_ON_RESOURCE = 0;
    static final boolean DEFAULT_ACTIVATION_STATUS = true;
    protected List rootTypes = new ArrayList();
    protected List selectedTypes = new ArrayList();
    protected IWorkingSet workingSet;
    protected int onResource;
    protected boolean enabled;
    private IResource[] focusResource;
    private Set cachedWorkingSet;
    private String name;
    static /* synthetic */ Class class$0;

    MarkerFilter(String string, String[] stringArray) {
        this.name = string;
        int n = 0;
        while (n < stringArray.length) {
            MarkerType markerType = MarkerTypesModel.getInstance().getType(stringArray[n]);
            if (!this.rootTypes.contains(markerType)) {
                this.rootTypes.add(markerType);
            }
            ++n;
        }
        this.resetState();
    }

    public void addAllSubTypes(List list) {
        int n = 0;
        while (n < this.rootTypes.size()) {
            MarkerType markerType = (MarkerType)this.rootTypes.get(n);
            this.addAllSubTypes(list, markerType);
            ++n;
        }
    }

    private void addAllSubTypes(List list, MarkerType markerType) {
        if (markerType == null) {
            return;
        }
        if (!list.contains(markerType)) {
            list.add(markerType);
        }
        MarkerType[] markerTypeArray = markerType.getSubtypes();
        int n = 0;
        while (n < markerTypeArray.length) {
            this.addAllSubTypes(list, markerTypeArray[n]);
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List findMarkers(IResource[] var1_1, int var2_2, int var3_3, IProgressMonitor var4_4, boolean var5_5) throws CoreException {
        if (var1_1 == null) {
            return Collections.EMPTY_LIST;
        }
        var6_6 = new ArrayList<ConcreteMarker>(var1_1.length * 2);
        var7_7 = new HashSet<E>(this.selectedTypes.size());
        var8_8 = new HashSet<Object>(this.selectedTypes.size());
        var7_7.addAll(this.selectedTypes);
        var9_9 = this.selectedTypes.iterator();
        while (var9_9.hasNext()) {
            var10_10 = (MarkerType)var9_9.next();
            var11_11 = Arrays.asList(var10_10.getAllSubTypes());
            if (!this.selectedTypes.containsAll(var11_11)) continue;
            var7_7.removeAll(var11_11);
            var8_8.add(var10_10);
        }
        var4_4.beginTask(MarkerMessages.MarkerFilter_searching, var7_7.size() * var1_1.length);
        var10_10 = new HashSet<E>();
        var11_12 = 0;
        while (var11_12 < var1_1.length) {
            var12_13 = var1_1[var11_12];
            if (var12_13.exists()) {
                if (var10_10.contains(var12_13)) {
                    var4_4.worked(var7_7.size());
                } else {
                    var10_10.add(var12_13);
                }
            }
            ++var11_12;
        }
        var11_12 = 0;
        while (var11_12 < var1_1.length) {
            block17: {
                var9_9 = var7_7.iterator();
                var12_13 = var1_1[var11_12];
                if (!var12_13.isAccessible()) break block17;
                if (var2_2 != 2) ** GOTO lbl66
                var13_14 = var12_13.getParent();
                var14_15 = false;
                while (var13_14 != null) {
                    if (var10_10.contains(var13_14)) {
                        var14_15 = true;
                    }
                    var13_14 = var13_14.getParent();
                }
                if (!var14_15) ** GOTO lbl66
                break block17;
lbl-1000:
                // 1 sources

                {
                    var13_14 = (MarkerType)var9_9.next();
                    var14_16 = var12_13.findMarkers(var13_14.getId(), var8_8.contains(var13_14), var2_2);
                    var4_4.worked(1);
                    var15_17 = 0;
                    while (var15_17 < var14_16.length) {
                        block16: {
                            try {
                                var16_18 = MarkerList.createMarker(var14_16[var15_17]);
                            }
                            catch (CoreException var17_19) {
                                if (!var5_5) {
                                    throw var17_19;
                                }
                                break block16;
                            }
                            if (var3_3 != -1 && var6_6.size() >= var3_3) {
                                return var6_6;
                            }
                            if (this.selectMarker(var16_18)) {
                                var6_6.add(var16_18);
                            }
                        }
                        ++var15_17;
                    }
lbl66:
                    // 3 sources

                    ** while (var9_9.hasNext())
                }
            }
            ++var11_12;
        }
        var4_4.done();
        return var6_6;
    }

    protected boolean selectMarker(ConcreteMarker concreteMarker) {
        return true;
    }

    Collection findMarkers(IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        List list = Collections.EMPTY_LIST;
        if (!this.isEnabled()) {
            list = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, -1, iProgressMonitor, bl);
        } else {
            int n = -1;
            switch (this.getOnResource()) {
                case 0: {
                    list = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, n, iProgressMonitor, bl);
                    break;
                }
                case 1: {
                    list = this.findMarkers(this.focusResource, 0, n, iProgressMonitor, bl);
                    break;
                }
                case 2: {
                    list = this.findMarkers(this.focusResource, 2, n, iProgressMonitor, bl);
                    break;
                }
                case 3: {
                    list = this.findMarkers((IResource[])MarkerFilter.getProjects(this.focusResource), 2, n, iProgressMonitor, bl);
                    break;
                }
                case 4: {
                    list = this.findMarkers(this.getResourcesInWorkingSet(), 2, n, iProgressMonitor, bl);
                }
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] iAdaptableArray = this.workingSet.getElements();
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            IResource iResource;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private Set getWorkingSetAsSetOfPaths() {
        if (this.cachedWorkingSet == null) {
            HashSet hashSet = new HashSet();
            this.addResourcesAndChildren(hashSet, this.getResourcesInWorkingSet());
            this.cachedWorkingSet = hashSet;
        }
        return this.cachedWorkingSet;
    }

    private void addResourcesAndChildren(HashSet hashSet, IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            hashSet.add(iResource.getFullPath().toString());
            if (iResource instanceof IContainer) {
                IContainer iContainer = (IContainer)iResource;
                try {
                    this.addResourcesAndChildren(hashSet, iContainer.members());
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
    }

    static IProject[] getProjects(IResource[] iResourceArray) {
        if (iResourceArray == null) {
            return new IProject[0];
        }
        Collection collection = MarkerFilter.getProjectsAsCollection(iResourceArray);
        return collection.toArray(new IProject[collection.size()]);
    }

    static Collection getProjectsAsCollection(Object[] objectArray) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                hashSet.add(((IResource)objectArray[n]).getProject());
            } else {
                IProject[] iProjectArray = ((ResourceMapping)objectArray[n]).getProjects();
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    hashSet.add(iProjectArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public boolean select(ConcreteMarker concreteMarker) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.selectByType(concreteMarker) && this.selectBySelection(concreteMarker) && this.selectMarker(concreteMarker);
    }

    private boolean selectByType(ConcreteMarker concreteMarker) {
        return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(concreteMarker.getType()));
    }

    private boolean selectBySelection(ConcreteMarker concreteMarker) {
        block12: {
            IResource iResource;
            block14: {
                block13: {
                    block11: {
                        if (this.onResource == 0 || concreteMarker == null) {
                            return true;
                        }
                        if (this.focusResource == null) {
                            return true;
                        }
                        iResource = concreteMarker.getResource();
                        if (this.onResource != 4) break block11;
                        if (iResource != null) {
                            return this.isEnclosed(iResource);
                        }
                        break block12;
                    }
                    if (this.onResource != 3) break block13;
                    IProject iProject = iResource.getProject();
                    if (iProject == null) {
                        return false;
                    }
                    int n = 0;
                    while (n < this.focusResource.length) {
                        IProject iProject2 = this.focusResource[n].getProject();
                        if (iProject2 != null && iProject.equals((Object)iProject2)) {
                            return true;
                        }
                        ++n;
                    }
                    break block12;
                }
                if (this.onResource != 1) break block14;
                int n = 0;
                while (n < this.focusResource.length) {
                    if (iResource.equals((Object)this.focusResource[n])) {
                        return true;
                    }
                    ++n;
                }
                break block12;
            }
            if (this.onResource != 2) break block12;
            int n = 0;
            while (n < this.focusResource.length) {
                IResource iResource2 = iResource;
                while (iResource2 != null) {
                    if (iResource2.equals((Object)this.focusResource[n])) {
                        return true;
                    }
                    iResource2 = iResource2.getParent();
                }
                ++n;
            }
        }
        return false;
    }

    private boolean isEnclosed(IResource iResource) {
        if (this.workingSet == null) {
            return false;
        }
        if (this.workingSet.isEmpty()) {
            return true;
        }
        Set set = this.getWorkingSetAsSetOfPaths();
        return set.contains(iResource.getFullPath().toString());
    }

    public int getOnResource() {
        return this.onResource;
    }

    void setOnResource(int n) {
        if (n >= 0 && n <= 4) {
            this.onResource = n;
        }
    }

    IResource[] getFocusResource() {
        return this.focusResource;
    }

    public void setFocusResource(IResource[] iResourceArray) {
        this.focusResource = iResourceArray;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getRootTypes() {
        return this.rootTypes;
    }

    public List getSelectedTypes() {
        return this.selectedTypes;
    }

    public MarkerType getMarkerType(String string) {
        return MarkerTypesModel.getInstance().getType(string);
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    void setWorkingSet(IWorkingSet iWorkingSet) {
        this.workingSet = iWorkingSet;
        this.cachedWorkingSet = null;
    }

    void resetState() {
        this.enabled = true;
        this.onResource = 0;
        this.selectedTypes.clear();
        this.addAllSubTypes(this.selectedTypes);
        this.setWorkingSet(null);
    }

    public final void restoreState(IMemento iMemento) {
        this.resetState();
        this.restoreFilterSettings(iMemento);
    }

    public void restoreFilterSettings(IDialogSettings iDialogSettings) {
        this.resetState();
        String string = iDialogSettings.get(TAG_ENABLED);
        if (string != null) {
            this.enabled = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_ON_RESOURCE)) != null) {
            try {
                this.onResource = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = iDialogSettings.get(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList arrayList = new ArrayList();
            this.addAllSubTypes(arrayList);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String string2 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String string3 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(string2)) == null) continue;
                arrayList.remove(markerType);
                if (SELECTED_FALSE.equals(string3) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int n = 0;
            while (n < arrayList.size()) {
                this.selectedTypes.add(arrayList.get(n));
                ++n;
            }
        } else {
            string = iDialogSettings.get(TAG_SELECTED_TYPES);
            if (string != null) {
                this.generateSelectedTypes(string);
            }
        }
        string = iDialogSettings.get(TAG_WORKING_SET);
        if (string != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string));
        }
    }

    void generateSelectedTypes(String string) {
        this.selectedTypes.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            MarkerType markerType = this.getMarkerType(stringTokenizer.nextToken(TAG_TYPES_DELIMITER));
            if (markerType == null || this.selectedTypes.contains(markerType)) continue;
            this.selectedTypes.add(markerType);
        }
    }

    MarkerType findMarkerType(String string) {
        return MarkerTypesModel.getInstance().getType(string);
    }

    protected void restoreFilterSettings(IMemento iMemento) {
        Integer n;
        String string = iMemento.getString(TAG_ENABLED);
        if (string != null) {
            this.enabled = Boolean.valueOf(string);
        }
        if ((n = iMemento.getInteger(TAG_ON_RESOURCE)) != null) {
            this.onResource = n;
        }
        if ((string = iMemento.getString(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList arrayList = new ArrayList();
            this.addAllSubTypes(arrayList);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String string2 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String string3 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(string2)) == null) continue;
                arrayList.remove(markerType);
                if (SELECTED_FALSE.equals(string3) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                this.selectedTypes.add(arrayList.get(n2));
                ++n2;
            }
        } else {
            string = iMemento.getString(TAG_SELECTED_TYPES);
            if (string != null) {
                this.generateSelectedTypes(string);
            }
        }
        string = iMemento.getString(TAG_WORKING_SET);
        if (string != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string));
        }
    }

    public void saveFilterSettings(IMemento iMemento) {
        iMemento.putString(TAG_ENABLED, String.valueOf(this.enabled));
        iMemento.putInteger(TAG_ON_RESOURCE, this.onResource);
        String string = "";
        ArrayList arrayList = new ArrayList();
        this.addAllSubTypes(arrayList);
        int n = 0;
        while (n < arrayList.size()) {
            MarkerType markerType = (MarkerType)arrayList.get(n);
            string = String.valueOf(string) + markerType.getId() + TAG_TYPES_DELIMITER;
            string = this.selectedTypes.contains(markerType) ? String.valueOf(string) + "true:" : String.valueOf(string) + "false:";
            ++n;
        }
        iMemento.putString(TAG_SELECTION_STATUS, string);
        if (this.workingSet != null) {
            iMemento.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public MarkerFilter makeClone() throws CloneNotSupportedException {
        return (MarkerFilter)this.clone();
    }

    public void setSelectedTypes(List list) {
        this.selectedTypes = list;
    }
}

