/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.TypeMarkerGroup;

public class MarkerGroup {
    private static MarkerGroupingEntry undefinedEntry = new MarkerGroupingEntry(MarkerMessages.FieldCategory_Uncategorized);
    protected IField field;
    protected MarkerField markerField;
    private Map typesToMappings = new HashMap();
    private IConfigurationElement configurationElement;
    private String id;

    public static MarkerGroup createMarkerGroup(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getAttribute("id").equals("org.eclipse.ui.ide.type")) {
            return new TypeMarkerGroup(iConfigurationElement.getAttribute("label"));
        }
        return new MarkerGroup(iConfigurationElement);
    }

    protected MarkerGroup(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
        if (iConfigurationElement != null) {
            this.id = iConfigurationElement.getAttribute("id");
        }
        this.createFields();
        this.processEntries();
    }

    private void processEntries() {
        Object object;
        if (this.configurationElement == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren("markerGroupingEntry");
        IConfigurationElement[] iConfigurationElementArray2 = this.configurationElement.getChildren("markerAttributeGrouping");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            object = new MarkerGroupingEntry(iConfigurationElementArray[n]);
            ((MarkerGroupingEntry)object).setGroup(this);
            hashMap.put(((MarkerGroupingEntry)object).getId(), object);
            ++n;
        }
        n = 0;
        while (n < iConfigurationElementArray2.length) {
            Object object2;
            object = new AttributeMarkerGrouping(iConfigurationElementArray2[n]);
            String string = ((AttributeMarkerGrouping)object).getDefaultGroupingEntry();
            if (string != null) {
                if (hashMap.containsKey(string)) {
                    object2 = (MarkerGroupingEntry)hashMap.get(string);
                    ((MarkerGroupingEntry)object2).setAsDefault(((AttributeMarkerGrouping)object).getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)string));
                }
            }
            object2 = ((AttributeMarkerGrouping)object).getElement().getChildren("markerAttributeMapping");
            int n2 = 0;
            while (n2 < ((IConfigurationElement[])object2).length) {
                String string2 = object2[n2].getAttribute("markerGroupingEntry");
                if (hashMap.containsKey(string2)) {
                    MarkerGroupingEntry markerGroupingEntry = (MarkerGroupingEntry)hashMap.get(string2);
                    markerGroupingEntry.getMarkerGroup().mapAttribute((AttributeMarkerGrouping)object, markerGroupingEntry, object2[n2].getAttribute("value"));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)string));
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void createFields() {
        this.field = new FieldGroup(this);
        this.markerField = new GroupMarkerField();
    }

    private void addEntry(String string, EntryMapping entryMapping) {
        MarkerType[] markerTypeArray = this.getMarkerTypes(string);
        int n = 0;
        while (n < markerTypeArray.length) {
            Collection<EntryMapping> collection = new HashSet<EntryMapping>();
            MarkerType markerType = markerTypeArray[n];
            collection = this.typesToMappings.containsKey(markerType.getId()) ? (Collection)this.typesToMappings.get(string) : new HashSet();
            collection.add(entryMapping);
            this.typesToMappings.put(markerType.getId(), collection);
            ++n;
        }
    }

    private MarkerGroupingEntry findGroupValue(ConcreteMarker concreteMarker) {
        String string = concreteMarker.getType();
        IMarker iMarker = concreteMarker.getMarker();
        return this.findGroupValue(string, iMarker);
    }

    public MarkerGroupingEntry findGroupValue(String string, IMarker iMarker) {
        if (this.typesToMappings.containsKey(string)) {
            EntryMapping entryMapping = null;
            Iterator iterator = ((Collection)this.typesToMappings.get(string)).iterator();
            while (iterator.hasNext()) {
                EntryMapping entryMapping2 = (EntryMapping)iterator.next();
                if (entryMapping2.hasAttributes()) {
                    MarkerGroupingEntry markerGroupingEntry = entryMapping2.testAttribute(iMarker);
                    if (markerGroupingEntry == null) continue;
                    return markerGroupingEntry;
                }
                entryMapping = entryMapping2;
            }
            if (entryMapping != null) {
                return entryMapping.groupingEntry;
            }
        }
        return undefinedEntry;
    }

    public IField getField() {
        return this.field;
    }

    public String getId() {
        return this.id;
    }

    private MarkerGroupingEntry getMapping(ConcreteMarker concreteMarker) {
        if (concreteMarker.getGroup() == null) {
            concreteMarker.setGroup(this.findGroupValue(concreteMarker));
        }
        return (MarkerGroupingEntry)concreteMarker.getGroup();
    }

    public MarkerField getMarkerField() {
        return this.markerField;
    }

    private MarkerType[] getMarkerTypes(String string) {
        MarkerType[] markerTypeArray;
        MarkerTypesModel markerTypesModel = MarkerTypesModel.getInstance();
        HashSet<MarkerType> hashSet = new HashSet<MarkerType>();
        MarkerType markerType = markerTypesModel.getType(string);
        if (markerType != null) {
            hashSet.add(markerType);
            markerTypeArray = markerType.getAllSubTypes();
            int n = 0;
            while (n < markerTypeArray.length) {
                hashSet.add(markerTypeArray[n]);
                ++n;
            }
        }
        if (hashSet.isEmpty()) {
            return new MarkerType[0];
        }
        markerTypeArray = new MarkerType[hashSet.size()];
        hashSet.toArray(markerTypeArray);
        return markerTypeArray;
    }

    public String getTitle() {
        return this.configurationElement.getAttribute("label");
    }

    public void mapAttribute(AttributeMarkerGrouping attributeMarkerGrouping, MarkerGroupingEntry markerGroupingEntry, String string) {
        this.addEntry(attributeMarkerGrouping.getMarkerType(), new AttributeMapping(markerGroupingEntry, attributeMarkerGrouping.getAttribute(), string, attributeMarkerGrouping));
        attributeMarkerGrouping.addGroup(this);
    }

    public void remove(MarkerGroupingEntry markerGroupingEntry) {
        Iterator iterator = this.typesToMappings.values().iterator();
        ArrayList<EntryMapping> arrayList = new ArrayList<EntryMapping>();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                EntryMapping entryMapping = (EntryMapping)iterator2.next();
                if (!entryMapping.groupingEntry.equals(markerGroupingEntry)) continue;
                arrayList.add(entryMapping);
            }
            collection.removeAll(arrayList);
            arrayList.clear();
        }
    }

    public void setAsDefault(String string, MarkerGroupingEntry markerGroupingEntry) {
        this.addEntry(string, new EntryMapping(markerGroupingEntry));
    }

    public void unmap(AttributeMarkerGrouping attributeMarkerGrouping) {
        String string = attributeMarkerGrouping.getMarkerType();
        ArrayList arrayList = new ArrayList();
        Collection collection = (Collection)this.typesToMappings.get(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AttributeMapping) || ((AttributeMapping)e).grouping != attributeMarkerGrouping) continue;
            arrayList.add(e);
        }
        collection.removeAll(arrayList);
        if (collection.size() == 0) {
            this.typesToMappings.remove(string);
        }
    }

    class AttributeMapping
    extends EntryMapping {
        String attribute;
        String attributeValue;
        AttributeMarkerGrouping grouping;

        AttributeMapping(MarkerGroupingEntry markerGroupingEntry, String string, String string2, AttributeMarkerGrouping attributeMarkerGrouping) {
            super(markerGroupingEntry);
            this.attribute = string;
            this.attributeValue = string2;
            this.grouping = attributeMarkerGrouping;
        }

        public boolean hasAttributes() {
            return true;
        }

        public MarkerGroupingEntry testAttribute(IMarker iMarker) {
            Object object;
            if (!iMarker.exists()) {
                return null;
            }
            try {
                object = iMarker.getAttribute(this.attribute);
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
                return null;
            }
            if (object != null && this.attributeValue.equals(object.toString())) {
                return this.groupingEntry;
            }
            return null;
        }
    }

    class EntryMapping {
        MarkerGroupingEntry groupingEntry;

        EntryMapping(MarkerGroupingEntry markerGroupingEntry) {
            this.groupingEntry = markerGroupingEntry;
        }

        public boolean hasAttributes() {
            return false;
        }

        public MarkerGroupingEntry testAttribute(IMarker iMarker) {
            return null;
        }
    }

    class FieldGroup
    implements IField {
        MarkerGroup markerGroup;
        private boolean showing;

        FieldGroup(MarkerGroup markerGroup2) {
            this.markerGroup = markerGroup2;
        }

        public int compare(Object object, Object object2) {
            MarkerGroupingEntry markerGroupingEntry = MarkerGroup.this.getMapping(((MarkerNode)object).getConcreteRepresentative());
            MarkerGroupingEntry markerGroupingEntry2 = MarkerGroup.this.getMapping(((MarkerNode)object2).getConcreteRepresentative());
            return markerGroupingEntry2.getPriority() - markerGroupingEntry.getPriority();
        }

        public Image getColumnHeaderImage() {
            return null;
        }

        public String getColumnHeaderText() {
            return this.markerGroup.getTitle();
        }

        public int getDefaultDirection() {
            return 1;
        }

        public String getDescription() {
            return this.markerGroup.getTitle();
        }

        public Image getDescriptionImage() {
            return null;
        }

        public Image getImage(Object object) {
            return null;
        }

        public int getPreferredWidth() {
            return 75;
        }

        public String getValue(Object object) {
            MarkerNode markerNode = (MarkerNode)object;
            if (markerNode.isConcrete()) {
                MarkerGroupingEntry markerGroupingEntry = this.markerGroup.getMapping((ConcreteMarker)markerNode);
                return markerGroupingEntry.getLabel();
            }
            return markerNode.getDescription();
        }

        public boolean isShowing() {
            return this.showing;
        }

        public void setShowing(boolean bl) {
            this.showing = bl;
        }
    }

    class GroupMarkerField
    extends MarkerField {
        GroupMarkerField() {
        }

        public String getValue(MarkerItem markerItem) {
            return MarkerSupportInternalUtilities.getGroupValue(MarkerGroup.this, markerItem);
        }

        public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
            if (markerItem.getMarker() == null) {
                if (markerItem2.getMarker() == null) {
                    return 0;
                }
                return 1;
            }
            if (markerItem2.getMarker() == null) {
                return -1;
            }
            try {
                return MarkerGroup.this.findGroupValue(markerItem2.getMarker().getType(), markerItem2.getMarker()).getPriority() - MarkerGroup.this.findGroupValue(markerItem.getMarker().getType(), markerItem.getMarker()).getPriority();
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
                return 0;
            }
        }

        public String getColumnHeaderText() {
            return MarkerGroup.this.getTitle();
        }
    }
}

