/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.BookmarkMarker;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class MarkerList {
    private int[] markerCounts = null;
    private ConcreteMarker[] markers;
    private Map markerTable;

    public MarkerList() {
        this(new ConcreteMarker[0]);
    }

    public MarkerList(Collection collection) {
        this(collection.toArray(new ConcreteMarker[collection.size()]));
    }

    public MarkerList(ConcreteMarker[] concreteMarkerArray) {
        this.markers = concreteMarkerArray;
    }

    public void clearCache() {
        int n = 0;
        while (n < this.markers.length) {
            ConcreteMarker concreteMarker = this.markers[n];
            concreteMarker.clearCache();
            ++n;
        }
        this.markerTable = null;
    }

    private Map getMarkerMap() {
        if (this.markerTable == null) {
            this.markerTable = new HashMap();
            int n = 0;
            while (n < this.markers.length) {
                ConcreteMarker concreteMarker = this.markers[n];
                this.markerTable.put(concreteMarker.getMarker(), concreteMarker);
                ++n;
            }
        }
        return this.markerTable;
    }

    public ConcreteMarker getMarker(IMarker iMarker) {
        return (ConcreteMarker)this.getMarkerMap().get(iMarker);
    }

    public IMarker[] getIMarkers() {
        IMarker[] iMarkerArray = new IMarker[this.markers.length];
        int n = 0;
        while (n < this.markers.length) {
            iMarkerArray[n] = this.markers[n].getMarker();
            ++n;
        }
        return iMarkerArray;
    }

    public static ConcreteMarker createMarker(IMarker iMarker) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return new TaskMarker(iMarker);
        }
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return new BookmarkMarker(iMarker);
        }
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return new ProblemMarker(iMarker);
        }
        return new ConcreteMarker(iMarker);
    }

    public void refresh() {
        int n = 0;
        while (n < this.markers.length) {
            ConcreteMarker concreteMarker = this.markers[n];
            concreteMarker.refresh();
            ++n;
        }
    }

    public List asList() {
        return Arrays.asList(this.markers);
    }

    public MarkerList findMarkers(Collection collection) {
        ArrayList<ConcreteMarker> arrayList = new ArrayList<ConcreteMarker>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IMarker iMarker = (IMarker)iterator.next();
            ConcreteMarker concreteMarker = this.getMarker(iMarker);
            if (concreteMarker == null) continue;
            arrayList.add(concreteMarker);
        }
        return new MarkerList(arrayList);
    }

    public static ConcreteMarker[] createMarkers(IMarker[] iMarkerArray) throws CoreException {
        ConcreteMarker[] concreteMarkerArray = new ConcreteMarker[iMarkerArray.length];
        int n = 0;
        while (n < iMarkerArray.length) {
            concreteMarkerArray[n] = MarkerList.createMarker(iMarkerArray[n]);
            ++n;
        }
        return concreteMarkerArray;
    }

    public static MarkerList compute(MarkerFilter[] markerFilterArray, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < markerFilterArray.length) {
            hashSet.addAll(markerFilterArray[n].findMarkers(iProgressMonitor, bl));
            ++n;
        }
        return new MarkerList(hashSet);
    }

    public static IMarker[] compute(String[] stringArray) throws CoreException {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < stringArray.length) {
            IMarker[] iMarkerArray = iWorkspaceRoot.findMarkers(stringArray[n], true, 2);
            arrayList.addAll(Arrays.asList(iMarkerArray));
            ++n;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public ConcreteMarker[] toArray() {
        return this.markers;
    }

    public int getItemCount() {
        return this.markers.length;
    }

    public int getErrors() {
        return this.getMarkerCounts()[2];
    }

    public int getInfos() {
        return this.getMarkerCounts()[0];
    }

    public int getWarnings() {
        return this.getMarkerCounts()[1];
    }

    private int[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = new int[3];
            int n = 0;
            while (n < this.markers.length) {
                int n2;
                ConcreteMarker concreteMarker = this.markers[n];
                if (concreteMarker instanceof ProblemMarker && (n2 = ((ProblemMarker)this.markers[n]).getSeverity()) >= 0 && n2 <= 2) {
                    int n3 = n2;
                    this.markerCounts[n3] = this.markerCounts[n3] + 1;
                }
                ++n;
            }
        }
        return this.markerCounts;
    }

    public Object[] getArray() {
        return this.markers;
    }

    public int getSize() {
        return this.getArray().length;
    }

    public ConcreteMarker getMarker(int n) {
        return this.markers[n];
    }

    public void updateMarkers(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(this.asList());
        arrayList.addAll(collection);
        arrayList.removeAll(collection2);
        this.markers = new ConcreteMarker[arrayList.size()];
        arrayList.toArray(this.markers);
    }

    public void refreshAll() {
        int n = 0;
        while (n < this.markers.length) {
            this.markers[n].refresh();
            ++n;
        }
    }

    public void clearGroups() {
        int n = 0;
        while (n < this.markers.length) {
            this.markers[n].setGroup(null);
            ++n;
        }
    }
}

