/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerResolutionDialog
extends TitleAreaDialog {
    private IMarker originalMarker;
    private IMarkerResolution[] resolutions;
    private CheckboxTableViewer markersTable;
    private ListViewer resolutionsList;
    private ProgressMonitorPart progressPart;
    private MarkerView markerView;
    private ViewerComparator resolutionsComparator;
    private boolean calculatingResolutions;
    private boolean progressCancelled = false;
    private Button addMatching;
    private Hashtable markerMap = new Hashtable(0);

    public MarkerResolutionDialog(Shell shell, IMarker iMarker, IMarkerResolution[] iMarkerResolutionArray, MarkerView markerView) {
        super(shell);
        this.initializeResolutionsSorter();
        this.resolutionsComparator.sort((Viewer)markerView.getViewer(), (Object[])iMarkerResolutionArray);
        this.resolutions = iMarkerResolutionArray;
        this.originalMarker = iMarker;
        this.markerView = markerView;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MarkerMessages.resolveMarkerAction_dialogTitle);
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        this.initializeDialogUnits((Control)composite);
        this.setTitleImage(JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG")));
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        formLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        formLayout.spacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)formLayout);
        Label label = new Label(composite3, 0);
        label.setText(MarkerMessages.MarkerResolutionDialog_Resolutions_List_Title);
        label.setLayoutData((Object)new FormData());
        this.resolutionsList = new ListViewer(composite3, 2564);
        this.resolutionsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return MarkerResolutionDialog.this.resolutions;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((IMarkerResolution)object).getLabel();
            }
        });
        this.resolutionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                WorkbenchMarkerResolution workbenchMarkerResolution = MarkerResolutionDialog.this.getSelectedWorkbenchResolution();
                if (workbenchMarkerResolution == null || MarkerResolutionDialog.this.markerMap.containsKey(workbenchMarkerResolution)) {
                    MarkerResolutionDialog.this.addMatching.setEnabled(false);
                } else {
                    MarkerResolutionDialog.this.addMatching.setEnabled(true);
                }
                MarkerResolutionDialog.this.markersTable.refresh();
            }
        });
        this.resolutionsList.setInput((Object)this);
        this.resolutionsList.setComparator(this.resolutionsComparator);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)label, 0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.convertHeightInCharsToPixels(10);
        this.resolutionsList.getControl().setLayoutData((Object)formData);
        Label label2 = new Label(composite3, 0);
        label2.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Title);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(this.resolutionsList.getControl(), 0);
        formData2.left = new FormAttachment(0);
        label2.setLayoutData((Object)formData2);
        Composite composite4 = this.createTableButtons(composite3);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)label2, 0);
        formData3.right = new FormAttachment(100);
        formData3.height = this.convertHeightInCharsToPixels(10);
        composite4.setLayoutData((Object)formData3);
        this.createMarkerTable(composite3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)composite4, 0, 128);
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment((Control)composite4, 0);
        formData4.height = this.convertHeightInCharsToPixels(10);
        this.markersTable.getControl().setLayoutData((Object)formData4);
        this.progressPart = new ProgressMonitorPart(composite3, (Layout)new GridLayout());
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment(this.markersTable.getControl(), 0);
        formData5.left = new FormAttachment(0);
        formData5.right = new FormAttachment(100, 0);
        this.progressPart.setLayoutData((Object)formData5);
        Dialog.applyDialogFont((Control)composite3);
        String string = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)Util.getProperty("message", this.originalMarker));
        if (string.length() > 50 && (n = this.chooseWhitespace(string)) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("\n");
            stringBuffer.append(string.substring(n, string.length()));
            string = stringBuffer.toString();
        }
        this.setMessage(string);
        return composite2;
    }

    private int chooseWhitespace(String string) {
        int n = string.length() / 2;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void initializeResolutionsSorter() {
        this.resolutionsComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((IMarkerResolution)object).getLabel().compareTo(((IMarkerResolution)object).getLabel());
            }
        };
    }

    private Composite createTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Button button = new Button(composite2, 8);
        button.setText(MarkerMessages.selectAllAction_title);
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerResolutionDialog.this.markersTable.setAllChecked(true);
                MarkerResolutionDialog.this.setComplete(!MarkerResolutionDialog.this.resolutionsList.getSelection().isEmpty());
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(MarkerMessages.filtersDialog_deselectAll);
        button2.setLayoutData((Object)new GridData(4, 0, false, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerResolutionDialog.this.markersTable.setAllChecked(false);
                MarkerResolutionDialog.this.setComplete(false);
            }
        });
        this.addMatching = new Button(composite2, 8);
        this.addMatching.setText(MarkerMessages.MarkerResolutionDialog_AddOthers);
        this.addMatching.setLayoutData((Object)new GridData(4, 0, false, false));
        this.addMatching.setEnabled(true);
        this.addMatching.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchMarkerResolution workbenchMarkerResolution = MarkerResolutionDialog.this.getSelectedWorkbenchResolution();
                if (workbenchMarkerResolution == null) {
                    return;
                }
                if (MarkerResolutionDialog.this.addMatchingMarkers(workbenchMarkerResolution)) {
                    MarkerResolutionDialog.this.addMatching.setEnabled(false);
                }
            }
        });
        return composite2;
    }

    private WorkbenchMarkerResolution getSelectedWorkbenchResolution() {
        IMarkerResolution iMarkerResolution = this.getSelectedResolution();
        if (iMarkerResolution == null || !(iMarkerResolution instanceof WorkbenchMarkerResolution)) {
            return null;
        }
        return (WorkbenchMarkerResolution)iMarkerResolution;
    }

    private IMarkerResolution getSelectedResolution() {
        ISelection iSelection = this.resolutionsList.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        return (IMarkerResolution)object;
    }

    protected boolean addMatchingMarkers(final WorkbenchMarkerResolution workbenchMarkerResolution) {
        this.calculatingResolutions = true;
        this.progressPart.beginTask(MarkerMessages.MarkerResolutionDialog_CalculatingTask, 100);
        this.progressPart.worked(10);
        if (this.progressCancelled()) {
            this.calculatingResolutions = false;
            return false;
        }
        this.progressPart.subTask(NLS.bind((String)MarkerMessages.MarkerResolutionDialog_WorkingSubTask, (Object)workbenchMarkerResolution.getLabel()));
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IMarker[] iMarkerArray = workbenchMarkerResolution.findOtherMarkers(MarkerResolutionDialog.this.markerView.getCurrentMarkers().getIMarkers());
                ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
                arrayList.add(MarkerResolutionDialog.this.originalMarker);
                int n = 0;
                while (n < iMarkerArray.length) {
                    arrayList.add(iMarkerArray[n]);
                    ++n;
                }
                MarkerResolutionDialog.this.markerMap.put(workbenchMarkerResolution, arrayList);
                MarkerResolutionDialog.this.progressPart.worked(90);
                MarkerResolutionDialog.this.progressPart.done();
                MarkerResolutionDialog.this.progressCancelled = false;
                MarkerResolutionDialog.this.calculatingResolutions = false;
                MarkerResolutionDialog.this.markersTable.refresh();
            }
        });
        return true;
    }

    private boolean progressCancelled() {
        this.getShell().getDisplay().readAndDispatch();
        if (this.progressCancelled) {
            this.progressCancelled = false;
            this.calculatingResolutions = false;
            this.progressPart.done();
            return true;
        }
        return false;
    }

    private void createMarkerTable(Composite composite) {
        this.markersTable = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        this.createTableColumns();
        this.markersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                IMarkerResolution iMarkerResolution = MarkerResolutionDialog.this.getSelectedResolution();
                if (iMarkerResolution == null) {
                    return new Object[0];
                }
                if (MarkerResolutionDialog.this.markerMap.containsKey(iMarkerResolution)) {
                    return ((Collection)MarkerResolutionDialog.this.markerMap.get(iMarkerResolution)).toArray();
                }
                return new IMarker[]{MarkerResolutionDialog.this.originalMarker};
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.markersTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                if (n == 0) {
                    return Util.getImage(((IMarker)object).getAttribute("severity", -1));
                }
                return null;
            }

            public String getColumnText(Object object, int n) {
                if (n == 0) {
                    return Util.getResourceName((IMarker)object);
                }
                int n2 = ((IMarker)object).getAttribute("lineNumber", -1);
                if (n2 < 0) {
                    return MarkerMessages.Unknown;
                }
                return NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(n2));
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        this.markersTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getChecked()) {
                    MarkerResolutionDialog.this.setComplete(true);
                } else {
                    MarkerResolutionDialog.this.setComplete(MarkerResolutionDialog.this.markersTable.getCheckedElements().length > 0);
                }
            }
        });
        this.markersTable.setInput((Object)this);
        this.markersTable.setAllChecked(true);
    }

    private void createTableColumns() {
        TableLayout tableLayout = new TableLayout();
        Table table = this.markersTable.getTable();
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        TableColumn tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Location);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Resource);
    }

    protected void setComplete(boolean bl) {
        this.getButton(0).setEnabled(bl);
    }

    public IMarkerResolution[] getResolutions() {
        return this.resolutions;
    }

    public void create() {
        super.create();
        this.setTitle(MarkerMessages.MarkerResolutionDialog_Title);
        this.resolutionsList.getList().select(0);
        this.markersTable.refresh();
        this.markersTable.setAllChecked(true);
        this.setComplete(true);
    }

    protected void okPressed() {
        IMarkerResolution iMarkerResolution = this.getSelectedResolution();
        if (iMarkerResolution == null) {
            return;
        }
        Object[] objectArray = this.markersTable.getCheckedElements();
        this.progressPart.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, objectArray.length + 1);
        this.progressPart.worked(1);
        this.calculatingResolutions = true;
        if (iMarkerResolution instanceof WorkbenchMarkerResolution) {
            IMarker[] iMarkerArray = new IMarker[objectArray.length];
            System.arraycopy(objectArray, 0, iMarkerArray, 0, objectArray.length);
            ((WorkbenchMarkerResolution)iMarkerResolution).run(iMarkerArray, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.progressPart, objectArray.length));
        } else {
            this.getShell().getDisplay().readAndDispatch();
            if (!this.progressCancelled() && objectArray.length == 1) {
                IMarker iMarker = (IMarker)objectArray[0];
                this.progressPart.subTask(Util.getProperty("message", iMarker));
                iMarkerResolution.run(iMarker);
                this.progressPart.worked(1);
            }
        }
        this.calculatingResolutions = false;
        this.progressPart.done();
        this.progressCancelled = false;
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.calculatingResolutions) {
            this.progressCancelled = true;
            this.progressPart.setCanceled(true);
            return;
        }
        super.cancelPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

