/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerNode;

public abstract class MarkerSelectionProviderAction
extends SelectionProviderAction {
    public MarkerSelectionProviderAction(ISelectionProvider iSelectionProvider, String string) {
        super(iSelectionProvider, string);
    }

    IMarker[] getSelectedMarkers() {
        return this.getSelectedMarkers(this.getStructuredSelection());
    }

    IMarker[] getSelectedMarkers(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (!(object instanceof MarkerNode)) {
                return new IMarker[0];
            }
            MarkerNode markerNode = (MarkerNode)object;
            if (markerNode.isConcrete()) {
                arrayList.add(((ConcreteMarker)object).getMarker());
            }
            ++n;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    IMarker getSelectedMarker() {
        ConcreteMarker concreteMarker = (ConcreteMarker)this.getStructuredSelection().getFirstElement();
        return concreteMarker.getMarker();
    }

    void execute(IUndoableOperation iUndoableOperation, String string, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(iUndoableOperation, iProgressMonitor, iAdaptable);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)WorkspaceUndoUtil.getShell(iAdaptable), (String)string, null, (IStatus)((CoreException)executionException.getCause()).getStatus());
            }
            IDEWorkbenchPlugin.log(string, executionException);
        }
    }
}

