/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableComparator;

public class MarkerSupportRegistry
implements IExtensionChangeHandler {
    private static final String DESCRIPTION = "onDescription";
    public static final String ENABLED = "enabled";
    private static final Object ERROR = "ERROR";
    private static final Object INFO = "INFO";
    private static final Object WARNING = "WARNING";
    private static final String MARKER_ID = "markerId";
    public static final String MARKER_SUPPORT = "markerSupport";
    private static final Object ON_ANY = "ON_ANY";
    private static final Object ON_ANY_IN_SAME_CONTAINER = "ON_ANY_IN_SAME_CONTAINER";
    private static final Object ON_SELECTED_AND_CHILDREN = "ON_SELECTED_AND_CHILDREN";
    private static final Object ON_SELECTED_ONLY = "ON_SELECTED_ONLY";
    private static final Object PROBLEM_FILTER = "problemFilter";
    private static final String SCOPE = "scope";
    private static final String SELECTED_TYPE = "selectedType";
    private static final String SEVERITY = "severity";
    public static final String MARKER_TYPE_REFERENCE = "markerTypeReference";
    private static final String MARKER_CATEGORY = "markerTypeCategory";
    public static final String ATTRIBUTE_MAPPING = "markerAttributeMapping";
    public static final String MARKER_GROUPING = "markerGrouping";
    public static final String VALUE = "value";
    public static final String LABEL = "label";
    public static final String MARKER_ATTRIBUTE_GROUPING = "markerAttributeGrouping";
    public static final String MARKER_GROUPING_ENTRY = "markerGroupingEntry";
    private static final Object SEVERITY_ID = "org.eclipse.ui.ide.severity";
    static final String MARKER_CONTENT_GENERATOR = "markerContentGenerator";
    private static final String MARKER_CONTENT_GENERATOR_EXTENSION = "markerContentGeneratorExtension";
    private static final String MARKER_FIELD = "markerField";
    private static final String ATTRIBUTE_CLASS = "class";
    public static final String BOOKMARKS_GENERATOR = "org.eclipse.ui.ide.bookmarksGenerator";
    public static final String TASKS_GENERATOR = "org.eclipse.ui.ide.tasksGenerator";
    public static final String PROBLEMS_GENERATOR = "org.eclipse.ui.ide.problemsGenerator";
    public static final String ALL_MARKERS_GENERATOR = "org.eclipse.ui.ide.allMarkersGenerator";
    public static final String MARKERS_ID = "org.eclipse.ui.ide.MarkersView";
    private static final String ATTRIBUTE_GENERATOR_ID = "generatorId";
    private static MarkerSupportRegistry singleton;
    private static Object creationLock;
    private Map registeredFilters = new HashMap();
    private Map markerGroups = new HashMap();
    private HashMap categories = new HashMap();
    private HashMap hierarchyOrders = new HashMap();
    private MarkerType rootType;
    private HashMap generators = new HashMap();
    private HashMap fields = new HashMap();

    static {
        creationLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarkerSupportRegistry getInstance() {
        if (singleton == null) {
            Object object = creationLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new MarkerSupportRegistry();
                }
            }
        }
        return singleton;
    }

    private MarkerSupportRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.ide", MARKER_SUPPORT);
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            this.processExtension(iExtensionTracker, iExtension, hashMap, hashMap3, hashSet, hashMap2);
            ++n;
        }
        this.postProcessExtensions(hashMap, hashMap3, hashSet, hashMap2);
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)iExtensionPoint));
    }

    private void processExtension(IExtensionTracker iExtensionTracker, IExtension iExtension, Map map, Map map2, Collection collection, Map map3) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            Object object;
            Object object2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals(PROBLEM_FILTER)) {
                object2 = this.newFilter(iConfigurationElement);
                this.registeredFilters.put(((ProblemFilter)object2).getId(), object2);
                iExtensionTracker.registerObject(iExtension, object2, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_GROUPING)) {
                object2 = MarkerGroup.createMarkerGroup(iConfigurationElement);
                this.markerGroups.put(((MarkerGroup)object2).getId(), object2);
                iExtensionTracker.registerObject(iExtension, object2, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_GROUPING_ENTRY)) {
                object2 = new MarkerGroupingEntry(iConfigurationElement);
                object = iConfigurationElement.getAttribute(MARKER_GROUPING);
                Collection collection2 = map.containsKey(object) ? (Collection)map.get(object) : new HashSet();
                collection2.add(object2);
                map.put(object, collection2);
                map2.put(((MarkerGroupingEntry)object2).getId(), object2);
                iExtensionTracker.registerObject(iExtension, object2, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_ATTRIBUTE_GROUPING)) {
                object2 = new AttributeMarkerGrouping(iConfigurationElement);
                collection.add(object2);
                iExtensionTracker.registerObject(iExtension, object2, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_CATEGORY)) {
                object2 = this.getMarkerTypes(iConfigurationElement);
                object = iConfigurationElement.getAttribute("name");
                int n2 = 0;
                while (n2 < ((String[])object2).length) {
                    this.categories.put(object2[n2], object);
                    ++n2;
                }
                iExtensionTracker.registerObject(iExtension, object, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_CONTENT_GENERATOR_EXTENSION)) {
                object2 = iConfigurationElement.getAttribute(ATTRIBUTE_GENERATOR_ID);
                object = map3.containsKey(object2) ? (Collection)map3.get(object2) : new ArrayList();
                object.add(iConfigurationElement);
                map3.put(object2, object);
                iExtensionTracker.registerObject(iExtension, (Object)iConfigurationElement, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_CONTENT_GENERATOR)) {
                object2 = new MarkerContentGenerator(iConfigurationElement);
                this.generators.put(((MarkerContentGenerator)object2).getId(), object2);
                iExtensionTracker.registerObject(iExtension, object2, 0);
            } else if (iConfigurationElement.getName().equals(MARKER_FIELD)) {
                this.processMarkerField(iExtensionTracker, iExtension, iConfigurationElement);
            }
            ++n;
        }
    }

    private void processMarkerField(IExtensionTracker iExtensionTracker, IExtension iExtension, IConfigurationElement iConfigurationElement) {
        MarkerField markerField = null;
        try {
            markerField = (MarkerField)IDEWorkbenchPlugin.createExtension(iConfigurationElement, ATTRIBUTE_CLASS);
            markerField.setConfigurationElement(iConfigurationElement);
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
        if (markerField != null) {
            this.fields.put(iConfigurationElement.getAttribute("id"), markerField);
        }
        iExtensionTracker.registerObject(iExtension, (Object)markerField, 0);
    }

    private void postProcessExtensions(Map map, Map map2, Collection collection, Map map3) {
        this.processGroupingEntries(map);
        this.processAttributeMappings(map2, collection);
        this.postProcessContentGenerators(map3);
    }

    private void postProcessContentGenerators(Map map) {
        Iterator iterator = this.generators.values().iterator();
        while (iterator.hasNext()) {
            MarkerContentGenerator markerContentGenerator = (MarkerContentGenerator)iterator.next();
            markerContentGenerator.initializeFromConfigurationElement(this);
            if (!map.containsKey(markerContentGenerator.getId())) continue;
            markerContentGenerator.addExtensions((Collection)map.get(markerContentGenerator.getId()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processGroupingEntries(Map var1_1) {
        var2_2 = var1_1.keySet().iterator();
        while (var2_2.hasNext()) {
            var3_3 = (String)var2_2.next();
            var4_4 = ((Collection)var1_1.get(var3_3)).iterator();
            if (!this.markerGroups.containsKey(var3_3)) ** GOTO lbl13
            while (var4_4.hasNext()) {
                var5_5 = (MarkerGroupingEntry)var4_4.next();
                var5_5.setGroup((MarkerGroup)this.markerGroups.get(var3_3));
            }
            continue;
lbl-1000:
            // 1 sources

            {
                var5_5 = (MarkerGroupingEntry)var4_4.next();
                IDEWorkbenchPlugin.log(NLS.bind((String)"markerGroupingEntry {0} defines invalid group {1}", (Object[])new String[]{var5_5.getId(), var3_3}));
lbl13:
                // 2 sources

                ** while (var4_4.hasNext())
            }
lbl14:
            // 1 sources

        }
    }

    private void processAttributeMappings(Map map, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            AttributeMarkerGrouping attributeMarkerGrouping = (AttributeMarkerGrouping)iterator.next();
            String string = attributeMarkerGrouping.getDefaultGroupingEntry();
            if (string != null) {
                if (map.containsKey(string)) {
                    object = (MarkerGroupingEntry)map.get(string);
                    ((MarkerGroupingEntry)object).setAsDefault(attributeMarkerGrouping.getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)string));
                }
            }
            object = attributeMarkerGrouping.getElement().getChildren(ATTRIBUTE_MAPPING);
            int n = 0;
            while (n < ((IConfigurationElement[])object).length) {
                String string2 = object[n].getAttribute(MARKER_GROUPING_ENTRY);
                if (map.containsKey(string2)) {
                    MarkerGroupingEntry markerGroupingEntry = (MarkerGroupingEntry)map.get(string2);
                    markerGroupingEntry.getMarkerGroup().mapAttribute(attributeMarkerGrouping, markerGroupingEntry, object[n].getAttribute(VALUE));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)string));
                }
                ++n;
            }
        }
    }

    private String[] getMarkerTypes(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(MARKER_TYPE_REFERENCE);
        String[] stringArray = new String[iConfigurationElementArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = iConfigurationElementArray[n].getAttribute("id");
            ++n;
        }
        return stringArray;
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashSet hashSet = new HashSet();
        this.processExtension(iExtensionTracker, iExtension, hashMap, hashMap2, hashSet, hashMap3);
        this.postProcessExtensions(hashMap, hashMap2, hashSet, hashMap3);
    }

    public Collection getRegisteredFilters() {
        ArrayList<ProblemFilter> arrayList = new ArrayList<ProblemFilter>();
        Iterator iterator = this.registeredFilters.values().iterator();
        while (iterator.hasNext()) {
            ProblemFilter problemFilter = (ProblemFilter)iterator.next();
            if (problemFilter.isFilteredOutByActivity()) continue;
            arrayList.add(problemFilter);
        }
        return arrayList;
    }

    private int getScopeValue(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(SCOPE);
        if (string == null) {
            return -1;
        }
        if (string.equals(ON_ANY)) {
            return 0;
        }
        if (string.equals(ON_SELECTED_ONLY)) {
            return 1;
        }
        if (string.equals(ON_SELECTED_AND_CHILDREN)) {
            return 2;
        }
        if (string.equals(ON_ANY_IN_SAME_CONTAINER)) {
            return 3;
        }
        return -1;
    }

    private int getSeverityValue(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(SEVERITY);
        if (string == null) {
            return -1;
        }
        if (string.equals(INFO)) {
            return 1;
        }
        if (string.equals(WARNING)) {
            return 2;
        }
        if (string.equals(ERROR)) {
            return 4;
        }
        return -1;
    }

    private ProblemFilter newFilter(IConfigurationElement iConfigurationElement) {
        int n;
        String string;
        ProblemFilter problemFilter = new ProblemFilter(iConfigurationElement.getAttribute("name"));
        problemFilter.createContributionFrom(iConfigurationElement);
        String string2 = iConfigurationElement.getAttribute(ENABLED);
        problemFilter.setEnabled(string2 == null || Boolean.valueOf(string2) != false);
        int n2 = this.getScopeValue(iConfigurationElement);
        if (n2 >= 0) {
            problemFilter.setOnResource(n2);
        }
        if ((string = iConfigurationElement.getAttribute(DESCRIPTION)) != null) {
            n = 1;
            if (string.charAt(0) == '!') {
                string = string.substring(1, string.length());
                n = 0;
            }
            problemFilter.setContains(n != 0);
            problemFilter.setDescription(string);
        }
        if ((n = this.getSeverityValue(iConfigurationElement)) > 0) {
            problemFilter.setSelectBySeverity(true);
            problemFilter.setSeverity(n);
        } else {
            problemFilter.setSelectBySeverity(false);
        }
        ArrayList<MarkerType> arrayList = new ArrayList<MarkerType>();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(SELECTED_TYPE);
        int n3 = 0;
        while (n3 < iConfigurationElementArray.length) {
            String string3 = iConfigurationElementArray[n3].getAttribute(MARKER_ID);
            if (string3 != null) {
                MarkerType markerType = problemFilter.getMarkerType(string3);
                if (markerType == null) {
                    Status status = new Status(2, "org.eclipse.ui.ide", 2, NLS.bind((String)MarkerMessages.ProblemFilterRegistry_nullType, (Object[])new Object[]{string3, problemFilter.getName()}), null);
                    IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                } else {
                    arrayList.add(markerType);
                }
            }
            ++n3;
        }
        if (arrayList.size() > 0) {
            problemFilter.setSelectedTypes(arrayList);
        }
        return problemFilter;
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if (objectArray[n] instanceof ProblemFilter) {
                this.registeredFilters.remove(objectArray[n]);
            } else if (objectArray[n] instanceof MarkerGroup) {
                this.markerGroups.remove(((MarkerGroup)objectArray[n]).getId());
            } else if (objectArray[n] instanceof MarkerGroupingEntry) {
                object = (MarkerGroupingEntry)objectArray[n];
                ((MarkerGroupingEntry)object).getMarkerGroup().remove((MarkerGroupingEntry)object);
            } else if (objectArray[n] instanceof AttributeMarkerGrouping) {
                object = (AttributeMarkerGrouping)objectArray[n];
                ((AttributeMarkerGrouping)object).unmap();
            } else if (objectArray[n] instanceof String) {
                this.removeValues(objectArray[n], this.categories);
            } else if (objectArray[n] instanceof MarkerField) {
                this.fields.remove(MarkerSupportInternalUtilities.getId((MarkerField)objectArray[n]));
            } else if (objectArray[n] instanceof MarkerContentGenerator) {
                this.generators.remove(((MarkerContentGenerator)objectArray[n]).getId());
            } else if (objectArray[n] instanceof IConfigurationElement) {
                object = (IConfigurationElement)objectArray[n];
                MarkerContentGenerator markerContentGenerator = (MarkerContentGenerator)this.generators.get(object.getAttribute(ATTRIBUTE_GENERATOR_ID));
                markerContentGenerator.removeExtension((IConfigurationElement)object);
            }
            ++n;
        }
    }

    private void removeValues(Object object, HashMap hashMap) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            Object v = hashMap.get(object2);
            if (v instanceof Collection) {
                Collection collection = (Collection)v;
                if (!collection.contains(object)) continue;
                collection.remove(object);
                if (!collection.isEmpty()) break;
                arrayList.add(object2);
                break;
            }
            if (!hashMap.get(object2).equals(object)) continue;
            arrayList.add(object2);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            hashMap.remove(object2.next());
        }
    }

    public String getCategory(IMarker iMarker) {
        try {
            return this.getCategory(iMarker.getType());
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return null;
        }
    }

    public String getCategory(String string) {
        if (this.categories.containsKey(string)) {
            return (String)this.categories.get(string);
        }
        return null;
    }

    public TableComparator getSorterFor(String string) {
        if (this.hierarchyOrders.containsKey(string)) {
            return (TableComparator)this.hierarchyOrders.get(string);
        }
        TableComparator tableComparator = this.findSorterInChildren(string, this.getRootType());
        if (tableComparator == null) {
            return new TableComparator(new IField[0], new int[0], new int[0]);
        }
        return tableComparator;
    }

    private MarkerType getRootType() {
        if (this.rootType == null) {
            this.rootType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker");
        }
        return this.rootType;
    }

    private TableComparator findSorterInChildren(String string, MarkerType markerType) {
        MarkerType[] markerTypeArray = markerType.getAllSubTypes();
        TableComparator tableComparator = null;
        if (this.hierarchyOrders.containsKey(markerType.getId())) {
            tableComparator = (TableComparator)this.hierarchyOrders.get(markerType.getId());
        }
        int n = 0;
        while (n < markerTypeArray.length) {
            MarkerType[] markerTypeArray2 = markerTypeArray[n].getAllSubTypes();
            int n2 = 0;
            while (n2 < markerTypeArray2.length) {
                TableComparator tableComparator2 = this.findSorterInChildren(string, markerTypeArray2[n2]);
                if (tableComparator2 != null) {
                    return tableComparator2;
                }
                ++n2;
            }
            ++n;
        }
        return tableComparator;
    }

    public Collection getMarkerGroups() {
        return this.markerGroups.values();
    }

    IField getDefaultGroupField() {
        return ((MarkerGroup)this.markerGroups.get(SEVERITY_ID)).getField();
    }

    public MarkerContentGenerator getGenerator(String string) {
        if (string != null && this.generators.containsKey(string)) {
            return (MarkerContentGenerator)this.generators.get(string);
        }
        return null;
    }

    public MarkerContentGenerator getDefaultGenerator() {
        return (MarkerContentGenerator)this.generators.get(PROBLEMS_GENERATOR);
    }

    public MarkerGroup getMarkerGroup(String string) {
        if (this.markerGroups.containsKey(string)) {
            return (MarkerGroup)this.markerGroups.get(string);
        }
        return null;
    }

    public MarkerField getField(String string) {
        if (this.fields.containsKey(string)) {
            return (MarkerField)this.fields.get(string);
        }
        return null;
    }

    public MarkerContentGenerator[] getGenerators() {
        MarkerContentGenerator[] markerContentGeneratorArray = new MarkerContentGenerator[this.generators.size()];
        this.generators.values().toArray(markerContentGeneratorArray);
        return markerContentGeneratorArray;
    }
}

