/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.markers.internal.ActionCopyMarker;
import org.eclipse.ui.views.markers.internal.ActionMarkerProperties;
import org.eclipse.ui.views.markers.internal.ActionOpenMarker;
import org.eclipse.ui.views.markers.internal.ActionPasteMarker;
import org.eclipse.ui.views.markers.internal.ActionRemoveMarker;
import org.eclipse.ui.views.markers.internal.ActionRevealMarker;
import org.eclipse.ui.views.markers.internal.ActionSelectAll;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DefaultMarkerResourceAdapter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.FilterEnablementAction;
import org.eclipse.ui.views.markers.internal.FiltersAction;
import org.eclipse.ui.views.markers.internal.MarkerAdapter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerViewPreferenceDialog;
import org.eclipse.ui.views.markers.internal.TableView;
import org.eclipse.ui.views.markers.internal.Util;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public abstract class MarkerView
extends TableView {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_ID = "id";
    private static final String TAG_FILTERS_SECTION = "filters";
    private static final String TAG_FILTER_ENTRY = "filter";
    private static final String MENU_FILTERS_GROUP = "group.filter";
    private static final String MENU_SHOW_IN_GROUP = "group.showIn";
    private static final String OLD_FILTER_SECTION = "filter";
    static final Object MARKER_UPDATE_FAMILY = new Object();
    MarkerProcessJob markerProcessJob = new MarkerProcessJob();
    private UpdateJob updateJob = new UpdateJob();
    private int preBusyMarkers = 0;
    protected Object[] focusElements;
    private Clipboard clipboard;
    IResourceChangeListener markerUpdateListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (!this.hasMarkerDelta(iResourceChangeEvent)) {
                return;
            }
            if (iResourceChangeEvent.getType() == 16) {
                MarkerView.this.scheduleMarkerUpdate(100);
                return;
            }
            IWorkbenchSiteProgressService iWorkbenchSiteProgressService = MarkerView.this.getProgressService();
            if (iWorkbenchSiteProgressService == null) {
                MarkerView.this.markerProcessJob.schedule(30000L);
            } else {
                MarkerView.this.getProgressService().schedule((Job)MarkerView.this.markerProcessJob, 30000L);
            }
        }

        private boolean hasMarkerDelta(IResourceChangeEvent iResourceChangeEvent) {
            String[] stringArray = MarkerView.this.getMarkerTypes();
            int n = 0;
            while (n < stringArray.length) {
                if (iResourceChangeEvent.findMarkerDeltas(stringArray[n], true).length > 0) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    };
    private ContextProvider contextProvider = new ContextProvider();
    protected ActionCopyMarker copyAction;
    protected ActionPasteMarker pasteAction;
    protected SelectionProviderAction revealAction;
    protected SelectionProviderAction openAction;
    protected SelectionProviderAction deleteAction;
    protected SelectionProviderAction selectAllAction;
    protected SelectionProviderAction propertiesAction;
    protected UndoActionHandler undoAction;
    protected RedoActionHandler redoAction;
    private ISelectionListener focusListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            MarkerView.this.focusSelectionChanged(iWorkbenchPart, iSelection);
        }
    };
    private int totalMarkers = 0;
    private MarkerFilter[] markerFilters = new MarkerFilter[0];
    private MarkerFilter[] enabledFilters = null;
    private MenuManager filtersMenu;
    private MenuManager showInMenu;
    private IPropertyChangeListener workingSetListener;
    private MarkerAdapter adapter;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals(MarkerView.this.getFiltersPreferenceName())) {
                MarkerView.this.loadFiltersPreferences();
                MarkerView.this.clearEnabledFilters();
                MarkerView.this.refreshForFocusUpdate();
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public MarkerView() {
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public MarkerList getCurrentMarkers() {
        return this.getMarkerAdapter().getCurrentMarkers();
    }

    protected MarkerAdapter getMarkerAdapter() {
        return this.adapter;
    }

    public void updateForContentsRefresh(IProgressMonitor iProgressMonitor) {
        this.updateJob.cancel();
        this.getMarkerAdapter().buildAllMarkers(iProgressMonitor);
        this.getProgressService().schedule((Job)this.updateJob);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        IWorkbenchSiteProgressService iWorkbenchSiteProgressService = this.getProgressService();
        if (iWorkbenchSiteProgressService != null) {
            this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            this.getProgressService().showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
            this.getProgressService().showBusyForFamily(MARKER_UPDATE_FAMILY);
        }
        this.loadFiltersPreferences();
    }

    private void loadFiltersPreferences() {
        String string = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(this.getFiltersPreferenceName());
        if (string.equals("")) {
            this.createDefaultFilter();
            return;
        }
        StringReader stringReader = new StringReader(string);
        try {
            this.restoreFilters((IMemento)XMLMemento.createReadRoot((Reader)stringReader));
        }
        catch (WorkbenchException workbenchException) {
            IDEWorkbenchPlugin.log(workbenchException.getLocalizedMessage(), workbenchException);
        }
    }

    void updateForFilterChanges() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeFiltersSettings(xMLMemento);
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(iOException));
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().putValue(this.getFiltersPreferenceName(), stringWriter.toString());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        this.clearEnabledFilters();
        this.refreshFilterMenu();
        this.refreshViewer();
    }

    protected void writeFiltersSettings(XMLMemento xMLMemento) {
        MarkerFilter[] markerFilterArray = this.getUserFilters();
        int n = 0;
        while (n < markerFilterArray.length) {
            IMemento iMemento = xMLMemento.createChild("filter", markerFilterArray[n].getName());
            markerFilterArray[n].saveFilterSettings(iMemento);
            ++n;
        }
    }

    abstract String getFiltersPreferenceName();

    void restoreFilters(IMemento iMemento) {
        IMemento[] iMementoArray = null;
        if (iMemento != null) {
            iMementoArray = iMemento.getChildren("filter");
        }
        if (iMementoArray == null) {
            IDialogSettings iDialogSettings = this.getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("filter");
            if (iDialogSettings2 != null) {
                MarkerFilter markerFilter = this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName);
                markerFilter.restoreFilterSettings(iDialogSettings2);
                this.setFilters(new MarkerFilter[]{markerFilter});
            }
        } else {
            MarkerFilter[] markerFilterArray = new MarkerFilter[iMementoArray.length];
            int n = 0;
            while (n < iMementoArray.length) {
                markerFilterArray[n] = this.createFilter(iMementoArray[n].getID());
                markerFilterArray[n].restoreState(iMementoArray[n]);
                ++n;
            }
            this.setFilters(markerFilterArray);
        }
        if (this.markerFilters.length == 0) {
            this.createDefaultFilter();
        }
    }

    private void createDefaultFilter() {
        MarkerFilter markerFilter = this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName);
        this.setFilters(new MarkerFilter[]{markerFilter});
    }

    protected abstract MarkerFilter createFilter(String var1);

    protected abstract String getSectionTag();

    public void createPartControl(Composite composite) {
        this.clipboard = new Clipboard(composite.getDisplay());
        super.createPartControl(composite);
        this.initDragAndDrop();
        this.getSite().getPage().addSelectionListener(this.focusListener);
        this.focusSelectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.getWorkingSetListener());
        this.getViewer().getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                IContext iContext = MarkerView.this.contextProvider.getContext(MarkerView.this.getViewer().getControl());
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(iContext);
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.markerUpdateListener, 25);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.contextProvider;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ISelection iSelection = MarkerView.this.getViewer().getSelection();
                    if (!(iSelection instanceof IStructuredSelection)) {
                        return null;
                    }
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    Iterator iterator = iStructuredSelection.iterator();
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    while (iterator.hasNext()) {
                        ConcreteMarker concreteMarker = (ConcreteMarker)iterator.next();
                        arrayList.add(concreteMarker.getResource());
                    }
                    return new ShowInContext(MarkerView.this.getViewer().getInput(), (ISelection)new StructuredSelection(arrayList));
                }
            };
        }
        return super.getAdapter(clazz);
    }

    protected void viewerSelectionChanged(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ConcreteMarker) {
                arrayList.add(((ConcreteMarker)objectArray[n]).getMarker());
            }
            ++n;
        }
        this.setSelection((IStructuredSelection)new StructuredSelection(arrayList));
        this.updateStatusMessage(iStructuredSelection);
    }

    public void dispose() {
        super.dispose();
        this.cancelJobs();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.markerUpdateListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        this.getSite().getPage().removeSelectionListener(this.focusListener);
        if (this.openAction != null) {
            this.openAction.dispose();
            this.copyAction.dispose();
            this.selectAllAction.dispose();
            this.deleteAction.dispose();
            this.revealAction.dispose();
            this.propertiesAction.dispose();
            this.undoAction.dispose();
            this.redoAction.dispose();
            this.clipboard.dispose();
        }
        if (this.showInMenu != null) {
            this.showInMenu.dispose();
        }
    }

    protected void createActions() {
        this.revealAction = new ActionRevealMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.openAction = new ActionOpenMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.copyAction = new ActionCopyMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.copyAction.setClipboard(this.clipboard);
        this.copyAction.setProperties(this.getSortingFields());
        this.pasteAction = new ActionPasteMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        this.pasteAction.setClipboard(this.clipboard);
        this.pasteAction.setPastableTypes(this.getMarkerTypes());
        this.deleteAction = new ActionRemoveMarker((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        this.selectAllAction = new ActionSelectAll(this);
        this.propertiesAction = new ActionMarkerProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer(), this.getMarkerName());
        IUndoContext iUndoContext = this.getUndoContext();
        this.undoAction = new UndoActionHandler(this.getSite(), iUndoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), iUndoContext);
        super.createActions();
        this.setFilterAction(new FiltersAction(this));
        this.setPreferencesAction(new ViewPreferencesAction(){

            public void openViewPreferencesDialog() {
                MarkerView.this.openPreferencesDialog(MarkerView.this.getMarkerEnablementPreferenceName(), MarkerView.this.getMarkerLimitPreferenceName());
            }
        });
    }

    private void openPreferencesDialog(String string, String string2) {
        MarkerViewPreferenceDialog markerViewPreferenceDialog = new MarkerViewPreferenceDialog(this.getSite().getWorkbenchWindow().getShell(), string, string2, MarkerMessages.MarkerPreferences_DialogTitle);
        if (markerViewPreferenceDialog.open() == 0) {
            this.refreshViewer();
        }
    }

    abstract String getMarkerLimitPreferenceName();

    abstract String[] getMarkerTypes();

    protected void initToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.deleteAction);
        iToolBarManager.add(this.getFilterAction());
        iToolBarManager.update(false);
    }

    protected void registerGlobalActions(IActionBars iActionBars) {
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected void initDragAndDrop() {
        int n = 1;
        Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter dragSourceAdapter = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                MarkerView.this.performDragSetData(dragSourceEvent);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }
        };
        this.getViewer().addDragSupport(n, transferArray, (DragSourceListener)dragSourceAdapter);
    }

    private void performDragSetData(DragSourceEvent dragSourceEvent) {
        if (MarkerTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            List list = ((IStructuredSelection)this.getViewer().getSelection()).toList();
            try {
                IMarker[] iMarkerArray = new IMarker[list.size()];
                list.toArray(iMarkerArray);
                if (iMarkerArray != null) {
                    dragSourceEvent.data = this.copyAction.createMarkerReport(iMarkerArray);
                }
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
    }

    private IMarker[] getSelectedMarkers() {
        Object[] objectArray = ((IStructuredSelection)this.getViewer().getSelection()).toArray();
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ConcreteMarker) {
                arrayList.add(((ConcreteMarker)objectArray[n]).getMarker());
            }
            ++n;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        if (iMenuManager == null) {
            return;
        }
        iMenuManager.add((IAction)this.openAction);
        this.createShowInMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.copyAction);
        this.pasteAction.updateEnablement();
        iMenuManager.add((IAction)this.pasteAction);
        if (this.canBeEditable()) {
            iMenuManager.add((IAction)this.deleteAction);
        }
        iMenuManager.add((IAction)this.selectAllAction);
        this.fillContextMenuAdditions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.propertiesAction);
    }

    boolean canBeEditable() {
        return true;
    }

    abstract void fillContextMenuAdditions(IMenuManager var1);

    protected final MarkerFilter[] getUserFilters() {
        return this.markerFilters;
    }

    protected void handleOpenEvent(OpenEvent openEvent) {
        if (this.openAction.isEnabled()) {
            this.openAction.run();
        }
    }

    protected void saveSelection(IMemento iMemento) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        IMemento iMemento2 = iMemento.createChild(TAG_SELECTION);
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ConcreteMarker)) continue;
            ConcreteMarker concreteMarker = (ConcreteMarker)e;
            IMemento iMemento3 = iMemento2.createChild(TAG_MARKER);
            iMemento3.putString(TAG_RESOURCE, concreteMarker.getMarker().getResource().getFullPath().toString());
            iMemento3.putString(TAG_ID, String.valueOf(concreteMarker.getMarker().getId()));
        }
    }

    protected abstract String[] getRootTypes();

    protected void focusSelectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        ArrayList<Object> arrayList;
        block15: {
            block13: {
                IFile iFile;
                block14: {
                    Object object;
                    arrayList = new ArrayList<Object>();
                    if (!(iWorkbenchPart instanceof IEditorPart)) break block13;
                    IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
                    iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
                    if (iFile != null) break block14;
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput == null) break block15;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((object = iEditorInput.getAdapter((Class)clazz)) == null) break block15;
                    arrayList.add(object);
                    break block15;
                }
                arrayList.add(iFile);
                break block15;
            }
            if (iSelection instanceof IStructuredSelection) {
                Iterator iterator = ((IStructuredSelection)iSelection).iterator();
                while (iterator.hasNext()) {
                    Object object;
                    ITaskListResourceAdapter iTaskListResourceAdapter;
                    IResource iResource;
                    Object e = iterator.next();
                    if (!(e instanceof IAdaptable)) continue;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.ui.views.tasklist.ITaskListResourceAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (iTaskListResourceAdapter = (object = iAdaptable.getAdapter((Class)clazz)) != null && object instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)object : DefaultMarkerResourceAdapter.getDefault()).getAffectedResource((IAdaptable)e)) == null) {
                        Object object2;
                        IAdaptable iAdaptable2 = (IAdaptable)e;
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((object2 = iAdaptable2.getAdapter((Class)clazz2)) == null) continue;
                        arrayList.add(object2);
                        continue;
                    }
                    arrayList.add(iResource);
                }
            }
        }
        this.updateFocusMarkers(arrayList.toArray());
    }

    protected final void updateFilterSelection(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                arrayList.add(objectArray[n]);
            } else {
                this.addResources(arrayList, (ResourceMapping)objectArray[n]);
            }
            ++n;
        }
        IResource[] iResourceArray = new IResource[arrayList.size()];
        arrayList.toArray(iResourceArray);
        int n2 = 0;
        while (n2 < this.markerFilters.length) {
            this.markerFilters[n2].setFocusResource(iResourceArray);
            ++n2;
        }
        Iterator iterator = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        while (iterator.hasNext()) {
            MarkerFilter markerFilter = (MarkerFilter)iterator.next();
            markerFilter.setFocusResource(iResourceArray);
        }
    }

    private void addResources(Collection collection, ResourceMapping resourceMapping) {
        try {
            ResourceTraversal[] resourceTraversalArray = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int n = 0;
            while (n < resourceTraversalArray.length) {
                ResourceTraversal resourceTraversal = resourceTraversalArray[n];
                IResource[] iResourceArray = resourceTraversal.getResources();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    collection.add(iResourceArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return;
        }
    }

    protected abstract String getStaticContextId();

    void updateFocusMarkers(Object[] objectArray) {
        boolean bl = this.updateNeeded(this.focusElements, objectArray);
        if (bl) {
            this.focusElements = objectArray;
            this.refreshForFocusUpdate();
        }
    }

    private boolean updateNeeded(Object[] objectArray, Object[] objectArray2) {
        MarkerFilter[] markerFilterArray = this.getEnabledFilters();
        boolean bl = false;
        int n = 0;
        while (n < markerFilterArray.length) {
            int n2;
            MarkerFilter markerFilter = markerFilterArray[n];
            if (markerFilter.isEnabled() && (n2 = markerFilter.getOnResource()) != 0 && n2 != 4 && objectArray2 != null && objectArray2.length >= 1) {
                if (objectArray == null || objectArray.length < 1) {
                    return true;
                }
                if (!Arrays.equals(objectArray, objectArray2)) {
                    if (n2 == 3) {
                        Collection collection = MarkerFilter.getProjectsAsCollection(objectArray);
                        Collection collection2 = MarkerFilter.getProjectsAsCollection(objectArray2);
                        if (collection.size() != collection2.size() || !collection2.containsAll(collection)) {
                            return true;
                        }
                    } else {
                        bl = true;
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    void updateTitle() {
        int n;
        String string = Util.EMPTY_STRING;
        int n2 = this.getCurrentMarkers().getItemCount();
        string = n2 == (n = this.getTotalMarkers()) ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)new Integer(n)) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)new Integer(n2), (Object)new Integer(n));
        this.setContentDescription(string);
    }

    protected void updateStatusMessage() {
        ISelection iSelection = this.getViewer().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.updateStatusMessage((IStructuredSelection)iSelection);
        } else {
            this.updateStatusMessage(null);
        }
    }

    protected void updateStatusMessage(IStructuredSelection iStructuredSelection) {
        String string = "";
        if (iStructuredSelection == null || iStructuredSelection.size() == 0) {
            string = this.updateSummaryVisible();
        } else if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ConcreteMarker) {
                string = ((ConcreteMarker)object).getDescription();
            }
        } else if (iStructuredSelection.size() > 1) {
            string = this.updateSummarySelected(iStructuredSelection);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    protected String updateSummarySelected(IStructuredSelection iStructuredSelection) {
        return MessageFormat.format(MarkerMessages.marker_statusSummarySelected, new Integer(iStructuredSelection.size()));
    }

    protected String updateSummaryVisible() {
        return "";
    }

    public final void openFiltersDialog() {
        DialogMarkerFilter dialogMarkerFilter = this.createFiltersDialog();
        if (dialogMarkerFilter.open() == 0) {
            MarkerFilter[] markerFilterArray = dialogMarkerFilter.getFilters();
            if (markerFilterArray == null) {
                return;
            }
            if (markerFilterArray.length == 0) {
                this.setFilters(new MarkerFilter[]{this.createFilter(MarkerMessages.MarkerFilter_defaultFilterName)});
            } else {
                this.setFilters(markerFilterArray);
            }
            this.updateForFilterChanges();
        }
    }

    public void refreshViewer() {
        this.scheduleMarkerUpdate(100);
    }

    void setFilters(MarkerFilter[] markerFilterArray) {
        this.markerFilters = markerFilterArray;
    }

    void clearEnabledFilters() {
        this.enabledFilters = null;
    }

    private void refreshFilterMenu() {
        if (this.filtersMenu == null) {
            return;
        }
        this.filtersMenu.removeAll();
        MarkerFilter[] markerFilterArray = this.getAllFilters();
        int n = 0;
        while (n < markerFilterArray.length) {
            this.filtersMenu.add((IAction)new FilterEnablementAction(markerFilterArray[n], this));
            ++n;
        }
    }

    protected abstract DialogMarkerFilter createFiltersDialog();

    public void setSelection(IStructuredSelection iStructuredSelection, boolean bl) {
        TreeViewer treeViewer = this.getViewer();
        ArrayList<ConcreteMarker> arrayList = new ArrayList<ConcreteMarker>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            ConcreteMarker concreteMarker;
            Object e = iterator.next();
            if (!(e instanceof IMarker) || (concreteMarker = this.getCurrentMarkers().getMarker((IMarker)e)) == null) continue;
            arrayList.add(concreteMarker);
        }
        if (treeViewer != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection(arrayList), bl);
        }
    }

    protected MarkerList getVisibleMarkers() {
        return this.getCurrentMarkers();
    }

    int getTotalMarkers() {
        return this.totalMarkers;
    }

    public void showBusy(boolean bl) {
        super.showBusy(bl);
        if (bl) {
            this.preBusyMarkers = this.totalMarkers;
        } else if (this.totalMarkers != this.preBusyMarkers) {
            this.getProgressService().warnOfContentChange();
        }
    }

    MarkerFilter[] getEnabledFilters() {
        if (this.enabledFilters == null) {
            Collection collection = this.findEnabledFilters();
            this.enabledFilters = new MarkerFilter[collection.size()];
            collection.toArray(this.enabledFilters);
        }
        return this.enabledFilters;
    }

    protected Collection findEnabledFilters() {
        MarkerFilter[] markerFilterArray = this.getAllFilters();
        ArrayList<MarkerFilter> arrayList = new ArrayList<MarkerFilter>(0);
        int n = 0;
        while (n < markerFilterArray.length) {
            if (markerFilterArray[n].isEnabled()) {
                arrayList.add(markerFilterArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    MarkerFilter[] getAllFilters() {
        return this.getUserFilters();
    }

    void addDropDownContributions(IMenuManager iMenuManager) {
        super.addDropDownContributions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator(MENU_FILTERS_GROUP));
        this.filtersMenu = new MenuManager(MarkerMessages.filtersSubMenu_title);
        this.refreshFilterMenu();
        iMenuManager.appendToGroup(MENU_FILTERS_GROUP, (IContributionItem)this.filtersMenu);
    }

    void createShowInMenu(IMenuManager iMenuManager) {
        String string;
        IBindingService iBindingService;
        ISelection iSelection = this.getViewer().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (!Util.isSingleConcreteSelection(iStructuredSelection)) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator(MENU_SHOW_IN_GROUP));
        String string2 = IDEWorkbenchMessages.Workbench_showIn;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null && (string = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            string2 = String.valueOf(string2) + '\t' + string;
        }
        this.showInMenu = new MenuManager(string2);
        this.showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
        iMenuManager.appendToGroup(MENU_SHOW_IN_GROUP, (IContributionItem)this.showInMenu);
    }

    void refreshMarkerCounts(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.subTask(MarkerMessages.MarkerView_refreshing_counts);
        try {
            this.totalMarkers = MarkerList.compute(this.getMarkerTypes()).length;
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return;
        }
    }

    int getMarkerLimit() {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(this.getMarkerEnablementPreferenceName())) {
            return IDEWorkbenchPlugin.getDefault().getPreferenceStore().getInt(this.getMarkerLimitPreferenceName());
        }
        return -1;
    }

    abstract String getMarkerEnablementPreferenceName();

    Object createViewerInput() {
        this.adapter = new MarkerAdapter(this);
        return this.adapter;
    }

    public void addUpdateFinishListener(IJobChangeListener iJobChangeListener) {
        this.updateJob.addJobChangeListener(iJobChangeListener);
    }

    public void removeUpdateFinishListener(IJobChangeListener iJobChangeListener) {
        this.updateJob.removeJobChangeListener(iJobChangeListener);
    }

    private IPropertyChangeListener getWorkingSetListener() {
        this.workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MarkerView.this.clearEnabledFilters();
                MarkerView.this.refreshViewer();
            }
        };
        return this.workingSetListener;
    }

    void scheduleMarkerUpdate(int n) {
        this.cancelJobs();
        this.getProgressService().schedule((Job)this.markerProcessJob, (long)n);
    }

    private void cancelJobs() {
        this.markerProcessJob.cancel();
        this.updateJob.cancel();
    }

    protected Tree createTree(Composite composite) {
        Tree tree = super.createTree(composite);
        tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent treeEvent) {
                MarkerView.this.updateJob.removeExpandedCategory((MarkerAdapter.MarkerCategory)treeEvent.item.getData());
            }

            public void treeExpanded(TreeEvent treeEvent) {
                MarkerView.this.updateJob.addExpandedCategory((MarkerAdapter.MarkerCategory)treeEvent.item.getData());
            }
        });
        return tree;
    }

    private void refreshForFocusUpdate() {
        if (this.focusElements != null) {
            this.updateFilterSelection(this.focusElements);
            this.refreshViewer();
        }
    }

    protected void preserveSelection() {
        this.updateJob.saveSelection(this.getViewer().getSelection());
    }

    protected abstract String getMarkerName();

    protected IUndoContext getUndoContext() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IUndoContext)iWorkspace.getAdapter((Class)clazz);
    }

    private class ContextProvider
    implements IContextProvider {
        private ContextProvider() {
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object object) {
            String string = null;
            ConcreteMarker concreteMarker = this.getSelectedConcreteMarker();
            if (concreteMarker != null) {
                string = IDE.getMarkerHelpRegistry().getHelp(concreteMarker.getMarker());
            }
            if (string == null) {
                string = MarkerView.this.getStaticContextId();
            }
            return HelpSystem.getContext(string);
        }

        private ConcreteMarker getSelectedConcreteMarker() {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)MarkerView.this.getViewer().getSelection();
            if (iStructuredSelection.isEmpty()) {
                return null;
            }
            if (iStructuredSelection.getFirstElement() instanceof ConcreteMarker) {
                return (ConcreteMarker)iStructuredSelection.getFirstElement();
            }
            return null;
        }

        public String getSearchExpression(Object object) {
            return null;
        }
    }

    class MarkerProcessJob
    extends Job {
        MarkerProcessJob() {
            super(MarkerMessages.MarkerView_processUpdates);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            MarkerView.this.updateForContentsRefresh(iProgressMonitor);
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return PlatformUI.isWorkbenchRunning();
        }

        public boolean belongsTo(Object object) {
            return MARKER_UPDATE_FAMILY == object;
        }
    }

    private class UpdateJob
    extends WorkbenchJob {
        private Collection categoriesToExpand = new HashSet();
        private Collection preservedSelection = new ArrayList();

        UpdateJob() {
            super(MarkerMessages.MarkerView_queueing_updates);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            Object object;
            int n;
            Object object2;
            MarkerAdapter.MarkerCategory[] markerCategoryArray;
            if (MarkerView.this.getViewer().getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            MarkerView.this.getViewer().refresh(true);
            Tree tree = MarkerView.this.getTree();
            if (tree != null && !tree.isDisposed()) {
                MarkerView.this.updateStatusMessage();
                MarkerView.this.updateTitle();
                if (MarkerView.this.getCurrentMarkers().getSize() < 20) {
                    MarkerView.this.getViewer().expandAll();
                } else {
                    markerCategoryArray = MarkerView.this.getMarkerAdapter().getCategories();
                    if (markerCategoryArray == null) {
                        this.categoriesToExpand.clear();
                    } else if (markerCategoryArray.length == 1) {
                        MarkerView.this.getViewer().expandAll();
                        this.categoriesToExpand.clear();
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        this.categoriesToExpand.add(markerCategoryArray[0].getName());
                    } else {
                        object2 = new HashSet();
                        n = 0;
                        while (n < markerCategoryArray.length) {
                            if (iProgressMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            object = markerCategoryArray[n];
                            if (this.categoriesToExpand.contains(((MarkerAdapter.MarkerCategory)object).getName())) {
                                MarkerView.this.getViewer().expandToLevel(object, -1);
                                object2.add(((MarkerAdapter.MarkerCategory)object).getName());
                            }
                            ++n;
                        }
                        this.categoriesToExpand = object2;
                    }
                }
            }
            if (this.preservedSelection.size() > 0) {
                markerCategoryArray = new ArrayList();
                object2 = MarkerView.this.getCurrentMarkers().toArray();
                n = 0;
                while (n < ((ConcreteMarker[])object2).length) {
                    object = this.preservedSelection.iterator();
                    while (object.hasNext()) {
                        MarkerDescriptor markerDescriptor = (MarkerDescriptor)object.next();
                        if (!markerDescriptor.isEquivalentTo(object2[n])) continue;
                        markerCategoryArray.add(object2[n]);
                    }
                    ++n;
                }
                MarkerView.this.getViewer().setSelection((ISelection)new StructuredSelection(markerCategoryArray.toArray()), true);
                this.preservedSelection.clear();
            }
            if (MarkerView.this.getViewer().getTree().getItemCount() > 0) {
                MarkerView.this.getViewer().getTree().setTopItem(MarkerView.this.getViewer().getTree().getItem(0));
            }
            return Status.OK_STATUS;
        }

        public void addExpandedCategory(MarkerAdapter.MarkerCategory markerCategory) {
            this.categoriesToExpand.add(markerCategory.getName());
        }

        public void removeExpandedCategory(MarkerAdapter.MarkerCategory markerCategory) {
            this.categoriesToExpand.remove(markerCategory.getName());
        }

        public boolean belongsTo(Object object) {
            return object == MARKER_UPDATE_FAMILY;
        }

        public void saveSelection(ISelection iSelection) {
            this.preservedSelection.clear();
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    MarkerNode markerNode = (MarkerNode)iterator.next();
                    if (!markerNode.isConcrete()) continue;
                    this.preservedSelection.add(new MarkerDescriptor(markerNode.getConcreteRepresentative()));
                }
            }
        }

        public boolean shouldRun() {
            return !MarkerView.this.getMarkerAdapter().isBuilding();
        }

        private class MarkerDescriptor {
            String description;
            String folder;
            String resource;
            int line;

            MarkerDescriptor(ConcreteMarker concreteMarker) {
                this.description = concreteMarker.getDescription();
                this.folder = concreteMarker.getFolder();
                this.resource = concreteMarker.getResourceName();
                this.line = concreteMarker.getLine();
            }

            boolean isEquivalentTo(ConcreteMarker concreteMarker) {
                return concreteMarker.getDescription().equals(this.description) && concreteMarker.getFolder().equals(this.folder) && concreteMarker.getResourceName().equals(this.resource) && concreteMarker.getLine() == this.line;
            }
        }
    }
}

