/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerViewPreferenceDialog
extends ViewSettingsDialog {
    String enablementKey;
    String limitKey;
    String dialogTitle;
    private IntegerFieldEditor limitEditor;
    private Button enablementButton;
    private Composite editArea;

    public MarkerViewPreferenceDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.enablementKey = string;
        this.limitKey = string2;
        this.dialogTitle = string3;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        boolean bl = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(this.enablementKey);
        this.enablementButton = new Button(composite2, 32);
        this.enablementButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.enablementButton.setSelection(bl);
        this.editArea = new Composite(composite2, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        this.editArea.setLayoutData((Object)gridData);
        this.limitEditor = new IntegerFieldEditor("limit", MarkerMessages.MarkerPreferences_VisibleItems, this.editArea){

            protected boolean checkState() {
                boolean bl = super.checkState();
                Button button = MarkerViewPreferenceDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(bl);
                }
                return bl;
            }
        };
        this.limitEditor.setPreferenceStore(IDEWorkbenchPlugin.getDefault().getPreferenceStore());
        this.limitEditor.setPreferenceName(this.limitKey);
        this.limitEditor.load();
        GridData gridData2 = new GridData(4, 0, true, false);
        gridData2.horizontalSpan = this.limitEditor.getNumberOfControls();
        this.enablementButton.setLayoutData((Object)gridData2);
        this.enablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerViewPreferenceDialog.this.setLimitEditorEnablement(MarkerViewPreferenceDialog.this.editArea, MarkerViewPreferenceDialog.this.enablementButton.getSelection());
            }
        });
        this.setLimitEditorEnablement(this.editArea, bl);
        return composite2;
    }

    private void setLimitEditorEnablement(Composite composite, boolean bl) {
        this.limitEditor.setEnabled(bl, composite);
    }

    protected void okPressed() {
        this.limitEditor.store();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(this.enablementKey, this.enablementButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.limitEditor.loadDefault();
        boolean bl = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getDefaultBoolean(this.enablementKey);
        this.enablementButton.setSelection(bl);
        this.setLimitEditorEnablement(this.editArea, bl);
    }
}

