/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;

public class ProblemFilter
extends MarkerFilter {
    public static final String TAG_CONTAINS = "contains";
    public static final String TAG_DESCRIPTION = "description";
    private static final String TAG_SELECT_BY_SEVERITY = "selectBySeverity";
    public static final String TAG_SEVERITY = "severity";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    static final boolean DEFAULT_SELECT_BY_SEVERITY = false;
    static final int DEFAULT_SEVERITY = 0;
    public static final int SEVERITY_ERROR = 4;
    public static final int SEVERITY_WARNING = 2;
    public static final int SEVERITY_INFO = 1;
    private boolean contains;
    private String description;
    private boolean selectBySeverity;
    private int severity;
    private IPluginContribution contributionDescriptor = null;
    private IIdentifier identifier;

    public ProblemFilter(String string) {
        super(string, new String[]{"org.eclipse.core.resources.problemmarker"});
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow;
        if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT") && (iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            this.setOnResource(4);
            this.setWorkingSet(iWorkbenchPage.getAggregateWorkingSet());
        }
    }

    public boolean selectMarker(ConcreteMarker concreteMarker) {
        if (!(concreteMarker instanceof ProblemMarker)) {
            return false;
        }
        ProblemMarker problemMarker = (ProblemMarker)concreteMarker;
        return !this.isEnabled() || super.selectMarker(problemMarker) && this.selectByDescription(problemMarker) && this.selectBySeverity(problemMarker);
    }

    private boolean selectByDescription(ConcreteMarker concreteMarker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String string = concreteMarker.getDescription();
        int n = string.indexOf(this.description);
        return this.contains ? n >= 0 : n < 0;
    }

    private boolean selectBySeverity(ProblemMarker problemMarker) {
        if (this.selectBySeverity) {
            int n = problemMarker.getSeverity();
            if (n == 2) {
                return (this.severity & 4) > 0;
            }
            if (n == 1) {
                return (this.severity & 2) > 0;
            }
            if (n == 0) {
                return (this.severity & 1) > 0;
            }
        }
        return true;
    }

    public boolean getContains() {
        return this.contains;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getSelectBySeverity() {
        return this.selectBySeverity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setContains(boolean bl) {
        this.contains = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setSelectBySeverity(boolean bl) {
        this.selectBySeverity = bl;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
        this.selectBySeverity = false;
        this.severity = 0;
    }

    public void restoreFilterSettings(IDialogSettings iDialogSettings) {
        super.restoreFilterSettings(iDialogSettings);
        String string = iDialogSettings.get(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
        if ((string = iDialogSettings.get(TAG_SELECT_BY_SEVERITY)) != null) {
            this.selectBySeverity = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_SEVERITY)) != null) {
            try {
                this.severity = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void restoreFilterSettings(IMemento iMemento) {
        super.restoreFilterSettings(iMemento);
        String string = iMemento.getString(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iMemento.getString(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
        if ((string = iMemento.getString(TAG_SELECT_BY_SEVERITY)) != null) {
            this.selectBySeverity = Boolean.valueOf(string);
        }
        Integer n = iMemento.getInteger(TAG_SEVERITY);
        if (string != null) {
            this.severity = n;
        }
    }

    public void saveFilterSettings(IMemento iMemento) {
        super.saveFilterSettings(iMemento);
        iMemento.putString(TAG_CONTAINS, String.valueOf(this.contains));
        iMemento.putString(TAG_DESCRIPTION, this.description);
        iMemento.putString(TAG_SELECT_BY_SEVERITY, String.valueOf(this.selectBySeverity));
        iMemento.putInteger(TAG_SEVERITY, this.severity);
    }

    public String getId() {
        if (this.contributionDescriptor == null) {
            return null;
        }
        return this.contributionDescriptor.getLocalId();
    }

    void createContributionFrom(IConfigurationElement iConfigurationElement) {
        final String string = iConfigurationElement.getAttribute("id");
        final String string2 = iConfigurationElement.getNamespace();
        this.contributionDescriptor = new IPluginContribution(){

            public String getLocalId() {
                return string;
            }

            public String getPluginId() {
                return string2;
            }
        };
    }

    public boolean isFilteredOutByActivity() {
        if (this.contributionDescriptor == null) {
            return false;
        }
        if (this.identifier == null) {
            this.identifier = WorkbenchActivityHelper.getIdentifier((IPluginContribution)this.contributionDescriptor);
        }
        return !this.identifier.isEnabled();
    }

    public boolean isEnabled() {
        return super.isEnabled() && !this.isFilteredOutByActivity();
    }
}

