/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.ActionProblemProperties;
import org.eclipse.ui.views.markers.internal.ActionResolveMarker;
import org.eclipse.ui.views.markers.internal.CategoryComparator;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogProblemFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldId;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.FieldSeverityAndMessage;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableComparator;

public class ProblemView
extends MarkerView {
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.problemmarker"};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
    private static final String TAG_SYSTEM_FILTER_ENTRY = "systemFilter";
    private ActionResolveMarker resolveMarkerAction;
    private IHandlerService handlerService;
    private IHandlerActivation resolveMarkerHandlerActivation;
    private IActivityManagerListener activityManagerListener;
    private IField severityAndMessage = new FieldSeverityAndMessage();
    private IField folder = new FieldFolder();
    private IField resource = new FieldResource();
    private IField lineNumber = new FieldLineNumber();
    private IField creationTime = new FieldCreationTime();
    private static IField id = new FieldId();
    static /* synthetic */ Class class$0;

    public ProblemView() {
        this.creationTime.setShowing(false);
    }

    public void dispose() {
        if (this.resolveMarkerAction != null) {
            this.resolveMarkerAction.dispose();
        }
        if (this.resolveMarkerHandlerActivation != null && this.handlerService != null) {
            this.handlerService.deactivateHandler(this.resolveMarkerHandlerActivation);
        }
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
        super.dispose();
    }

    protected IField[] getSortingFields() {
        return new IField[]{this.severityAndMessage, this.folder, this.resource, this.lineNumber, this.creationTime, id};
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return iDialogSettings2;
    }

    protected void createActions() {
        super.createActions();
        this.propertiesAction = new ActionProblemProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.resolveMarkerAction = new ActionResolveMarker(this, (ISelectionProvider)this.getViewer());
    }

    protected void registerGlobalActions(IActionBars iActionBars) {
        super.registerGlobalActions(iActionBars);
        String string = "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals";
        this.resolveMarkerAction.setActionDefinitionId(string);
        IViewSite iViewSite = this.getViewSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.handlerService = (IHandlerService)iViewSite.getService((Class)clazz);
        if (this.handlerService != null) {
            this.resolveMarkerHandlerActivation = this.handlerService.activateHandler(string, (IHandler)new ActionHandler((IAction)this.resolveMarkerAction));
        }
    }

    protected void fillContextMenuAdditions(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.resolveMarkerAction);
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected IField[] getAllFields() {
        return new IField[]{this.severityAndMessage, this.resource, this.folder, this.lineNumber, this.creationTime};
    }

    void updateTitle() {
        int n;
        MarkerList markerList = this.getVisibleMarkers();
        String string = this.formatSummaryBreakDown(markerList);
        int n2 = markerList.getItemCount();
        if (n2 != (n = this.getTotalMarkers())) {
            string = NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{string, new Integer(n2), new Integer(n)});
        }
        this.setContentDescription(string);
    }

    private String formatSummaryBreakDown(MarkerList markerList) {
        return MessageFormat.format((String)MarkerMessages.problem_statusSummaryBreakdown, (Object[])new Object[]{new Integer(markerList.getErrors()), new Integer(markerList.getWarnings()), new Integer(markerList.getInfos())});
    }

    private String getSummary(MarkerList markerList) {
        String string = MessageFormat.format((String)MarkerMessages.marker_statusSummarySelected, (Object[])new Object[]{new Integer(markerList.getItemCount()), this.formatSummaryBreakDown(markerList)});
        return string;
    }

    protected String updateSummarySelected(IStructuredSelection iStructuredSelection) {
        ArrayList<MarkerNode> arrayList = new ArrayList<MarkerNode>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            MarkerNode markerNode = (MarkerNode)iterator.next();
            if (!markerNode.isConcrete()) continue;
            arrayList.add(markerNode);
        }
        return this.getSummary(new MarkerList(arrayList));
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.problem_view_context";
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] markerFilterArray = this.getUserFilters();
        ProblemFilter[] problemFilterArray = new ProblemFilter[markerFilterArray.length];
        System.arraycopy(markerFilterArray, 0, problemFilterArray, 0, markerFilterArray.length);
        return new DialogProblemFilter(this.getSite().getShell(), problemFilterArray);
    }

    protected MarkerFilter createFilter(String string) {
        return new ProblemFilter(string);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_PROBLEMS";
    }

    String getMarkerLimitPreferenceName() {
        return "PROBLEMS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "PROBLEMS_FILTERS";
    }

    MarkerFilter[] getAllFilters() {
        MarkerFilter[] markerFilterArray = super.getAllFilters();
        Collection collection = MarkerSupportRegistry.getInstance().getRegisteredFilters();
        Iterator iterator = collection.iterator();
        MarkerFilter[] markerFilterArray2 = new MarkerFilter[markerFilterArray.length + collection.size()];
        System.arraycopy(markerFilterArray, 0, markerFilterArray2, 0, markerFilterArray.length);
        int n = markerFilterArray.length;
        while (iterator.hasNext()) {
            markerFilterArray2[n] = (MarkerFilter)iterator.next();
            ++n;
        }
        return markerFilterArray2;
    }

    void addDropDownContributions(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(MarkerMessages.ProblemView_GroupByMenu);
        Iterator iterator = MarkerSupportRegistry.getInstance().getMarkerGroups().iterator();
        while (iterator.hasNext()) {
            MarkerGroup markerGroup = (MarkerGroup)iterator.next();
            menuManager.add((IAction)new GroupingAction(markerGroup.getField().getDescription(), markerGroup.getField(), this));
        }
        menuManager.add((IAction)new GroupingAction(MarkerMessages.ProblemView_None, null, this));
        iMenuManager.add((IContributionItem)menuManager);
        super.addDropDownContributions(iMenuManager);
    }

    protected void regenerateLayout() {
        TableLayout tableLayout = new TableLayout();
        this.getViewer().getTree().setLayout((Layout)tableLayout);
        ColumnPixelData[] columnPixelDataArray = this.getDefaultColumnLayouts();
        int n = 0;
        while (n < columnPixelDataArray.length) {
            tableLayout.addColumnData((ColumnLayoutData)columnPixelDataArray[n]);
            ++n;
        }
        this.getViewer().getTree().layout(true);
    }

    void setComparator(TableComparator tableComparator) {
        this.getMarkerAdapter().getCategorySorter().setTableSorter(tableComparator);
        this.getMarkerAdapter().getCategorySorter().saveState(this.getDialogSettings());
        this.updateForNewComparator(tableComparator);
    }

    public TableComparator getTableSorter() {
        return ((CategoryComparator)this.getViewer().getComparator()).innerSorter;
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.createActivityManagerListener();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.activityManagerListener);
    }

    private void createActivityManagerListener() {
        this.activityManagerListener = new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                ProblemView.this.clearEnabledFilters();
                ProblemView.this.refreshViewer();
            }
        };
    }

    public IField findField(String string) {
        IField[] iFieldArray = this.getSortingFields();
        int n = 0;
        while (n < iFieldArray.length) {
            if (iFieldArray[n].getDescription().equals(string)) {
                return iFieldArray[n];
            }
            ++n;
        }
        return null;
    }

    protected ViewerComparator buildComparator() {
        TableComparator tableComparator = this.createTableComparator();
        CategoryComparator categoryComparator = new CategoryComparator(tableComparator);
        categoryComparator.restoreState(this.getDialogSettings(), this);
        return categoryComparator;
    }

    boolean canBeEditable() {
        return false;
    }

    protected void initToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add(this.getFilterAction());
        iToolBarManager.update(false);
    }

    public void selectCategory(String string, CategoryComparator categoryComparator) {
        if (string == null) {
            this.selectCategoryField(null, categoryComparator);
        }
        Iterator iterator = MarkerSupportRegistry.getInstance().getMarkerGroups().iterator();
        while (iterator.hasNext()) {
            MarkerGroup markerGroup = (MarkerGroup)iterator.next();
            if (!markerGroup.getField().getDescription().equals(string)) continue;
            this.selectCategoryField(markerGroup.getField(), categoryComparator);
            return;
        }
        this.selectCategoryField(null, categoryComparator);
    }

    void selectCategoryField(IField iField, CategoryComparator categoryComparator) {
        categoryComparator.setCategoryField(iField);
        if (this.getMarkerAdapter() != null) {
            this.getMarkerAdapter().getCurrentMarkers().clearGroups();
            this.refreshViewer();
        }
    }

    protected void writeFiltersSettings(XMLMemento xMLMemento) {
        super.writeFiltersSettings(xMLMemento);
        Iterator iterator = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        while (iterator.hasNext()) {
            MarkerFilter markerFilter = (MarkerFilter)iterator.next();
            IMemento iMemento = xMLMemento.createChild(TAG_SYSTEM_FILTER_ENTRY, markerFilter.getName());
            iMemento.putString("enabled", String.valueOf(markerFilter.isEnabled()));
        }
    }

    void restoreFilters(IMemento iMemento) {
        super.restoreFilters(iMemento);
        if (iMemento == null) {
            return;
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_SYSTEM_FILTER_ENTRY);
        Collection collection = MarkerSupportRegistry.getInstance().getRegisteredFilters();
        MarkerFilter[] markerFilterArray = new MarkerFilter[collection.size()];
        collection.toArray(markerFilterArray);
        if (iMementoArray != null) {
            int n = 0;
            while (n < iMementoArray.length) {
                String string = iMementoArray[n].getID();
                boolean bl = Boolean.valueOf(iMementoArray[n].getString("enabled"));
                this.setEnablement(string, bl, markerFilterArray);
                ++n;
            }
        }
    }

    private void setEnablement(String string, boolean bl, MarkerFilter[] markerFilterArray) {
        int n = 0;
        while (n < markerFilterArray.length) {
            if (markerFilterArray[n].getName().equals(string)) {
                markerFilterArray[n].setEnabled(bl);
                return;
            }
            ++n;
        }
    }

    protected String getMarkerName() {
        return MarkerMessages.problem_title;
    }

    private class GroupingAction
    extends Action {
        IField groupingField;
        ProblemView problemView;

        public GroupingAction(String string, IField iField, ProblemView problemView2) {
            super(string, 8);
            this.groupingField = iField;
            this.problemView = problemView2;
            IField iField2 = problemView2.getMarkerAdapter().getCategorySorter().getCategoryField();
            if (iField2 == null) {
                this.setChecked(this.groupingField == null);
            } else {
                this.setChecked(iField2.equals(this.groupingField));
            }
        }

        public void run() {
            if (this.isChecked()) {
                Job job = new Job(this, MarkerMessages.ProblemView_UpdateCategoryJob){
                    final /* synthetic */ GroupingAction this$1;
                    {
                        this.this$1 = groupingAction;
                    }

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            GroupingAction.access$0((GroupingAction)this.this$1).markerProcessJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                        this.this$1.problemView.selectCategoryField(this.this$1.groupingField, this.this$1.problemView.getMarkerAdapter().getCategorySorter());
                        GroupingAction.access$0(this.this$1).getMarkerAdapter().getCategorySorter().saveState(GroupingAction.access$0(this.this$1).getDialogSettings());
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                this.problemView.preserveSelection();
                IWorkbenchSiteProgressService iWorkbenchSiteProgressService = ProblemView.this.getProgressService();
                if (iWorkbenchSiteProgressService == null) {
                    job.schedule();
                } else {
                    ProblemView.this.getProgressService().schedule(job);
                }
            }
        }

        static /* synthetic */ ProblemView access$0(GroupingAction groupingAction) {
            return groupingAction.ProblemView.this;
        }
    }
}

