/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class SortUtil {
    SortUtil() {
    }

    public static MarkerList getFirst(MarkerList markerList, Comparator comparator, int n, IProgressMonitor iProgressMonitor) {
        List list = markerList.asList();
        ArrayList arrayList = new ArrayList(list.size());
        iProgressMonitor.beginTask(MarkerMessages.SortUtil_finding_first, 1000);
        SortUtil.getFirst(arrayList, list, comparator, n, iProgressMonitor, 1000);
        iProgressMonitor.done();
        return new MarkerList(arrayList);
    }

    private static void getFirst(Collection collection, Collection collection2, Comparator comparator, int n, IProgressMonitor iProgressMonitor, int n2) {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (collection2.size() <= n) {
            collection.addAll(collection2);
            iProgressMonitor.worked(n2);
            return;
        }
        Object e = collection2 instanceof ArrayList ? ((ArrayList)collection2).get(collection2.size() / 2) : collection2.iterator().next();
        ArrayList arrayList = new ArrayList(collection2.size());
        ArrayList arrayList2 = new ArrayList(collection2.size());
        ArrayList arrayList3 = new ArrayList();
        SortUtil.partitionHelper(arrayList2, arrayList, arrayList3, collection2, comparator, e, iProgressMonitor, n2 / 2);
        if (arrayList2.size() >= n) {
            SortUtil.getFirst(collection, arrayList2, comparator, n, iProgressMonitor, n2 / 2);
        } else if (arrayList2.size() + arrayList3.size() >= n) {
            int n3 = n - arrayList2.size();
            collection.addAll(arrayList2);
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext() && n3 > 0) {
                Object e2 = iterator.next();
                collection.add(e2);
                --n3;
            }
            iProgressMonitor.worked(n2 / 2);
        } else if (arrayList2.size() + arrayList3.size() + arrayList.size() >= n) {
            collection.addAll(arrayList2);
            collection.addAll(arrayList3);
            SortUtil.getFirst(collection, arrayList, comparator, n - arrayList2.size() - arrayList3.size(), iProgressMonitor, n2 / 2);
        }
    }

    private static void partitionHelper(Collection collection, Collection collection2, Collection collection3, Collection collection4, Comparator comparator, Object object, IProgressMonitor iProgressMonitor, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = collection4.size();
        Iterator iterator = collection4.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n5 = comparator.compare(e, object);
            if (n5 < 0) {
                collection.add(e);
            } else if (n5 > 0) {
                collection2.add(e);
            } else {
                collection3.add(e);
            }
            if (++n3 <= 100) continue;
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            int n6 = n3 * n2 / n4;
            iProgressMonitor.worked(n6);
            n2 -= n6;
            n4 -= n3;
            n3 = 0;
        }
        iProgressMonitor.worked(n2);
    }

    public static void partition(Collection collection, Collection collection2, Collection collection3, Collection collection4, Comparator comparator, Object object, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(MarkerMessages.SortUtil_partitioning, collection4.size());
        if (object == null || comparator == null) {
            int n = 0;
            Iterator iterator = collection4.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (++n >= 20) {
                    iProgressMonitor.worked(n);
                    n = 0;
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                }
                collection2.add(e);
            }
            iProgressMonitor.worked(n);
        } else {
            SortUtil.partitionHelper(collection, collection2, collection3, collection4, comparator, object, iProgressMonitor, collection4.size());
        }
        iProgressMonitor.done();
    }

    public static List removeFirst(Collection collection, int n) {
        int n2 = Math.min(collection.size(), n);
        ArrayList arrayList = new ArrayList(n2);
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (n3 < n2) {
            arrayList.add(iterator.next());
            iterator.remove();
            ++n3;
        }
        return arrayList;
    }

    public static Object findGreatest(Collection collection, Comparator comparator) {
        if (collection instanceof SortedSet && ((SortedSet)collection).comparator().equals(comparator)) {
            return ((SortedSet)collection).last();
        }
        Object t = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (t != null && comparator.compare(t, e) <= 0) continue;
            t = e;
        }
        return t;
    }
}

