/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerList;

public class TableComparator
extends ViewerComparator
implements Comparator {
    public static final int MAX_DEPTH = 4;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected IField[] fields;
    protected int[] priorities;
    protected int[] directions;
    protected int[] defaultPriorities;
    protected int[] defaultDirections;
    public static final String TAG_DIALOG_SECTION = "sorter";
    private static final String TAG_PRIORITY = "priority";
    private static final String TAG_DIRECTION = "direction";
    private static final String TAG_DEFAULT_PRIORITY = "defaultPriority";
    private static final String TAG_DEFAULT_DIRECTION = "defaultDirection";

    public TableComparator(TableComparator tableComparator) {
        this(tableComparator.getFields(), tableComparator.getDefaultPriorities(), tableComparator.getDefaultDirections());
        this.priorities = tableComparator.getPriorities();
        this.directions = tableComparator.getDirections();
    }

    public TableComparator(IField[] iFieldArray, int[] nArray, int[] nArray2) {
        this.fields = iFieldArray;
        if (iFieldArray == null || nArray == null || nArray2 == null || iFieldArray.length != nArray.length || iFieldArray.length != nArray2.length || !this.verifyPriorities(nArray) || !this.verifyDirections(nArray2)) {
            this.priorities = new int[0];
            this.directions = new int[0];
            this.defaultPriorities = new int[0];
            this.defaultDirections = new int[0];
        } else {
            this.priorities = new int[nArray.length];
            System.arraycopy(nArray, 0, this.priorities, 0, this.priorities.length);
            this.directions = new int[nArray2.length];
            System.arraycopy(nArray2, 0, this.directions, 0, this.directions.length);
            this.defaultPriorities = new int[nArray.length];
            System.arraycopy(nArray, 0, this.defaultPriorities, 0, nArray.length);
            this.defaultDirections = new int[nArray2.length];
            System.arraycopy(nArray2, 0, this.defaultDirections, 0, nArray2.length);
        }
    }

    static TableComparator createTableSorter(IField[] iFieldArray) {
        int[] nArray = new int[iFieldArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = n;
            ++n;
        }
        int[] nArray2 = new int[iFieldArray.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray2[n2] = iFieldArray[n2].getDefaultDirection();
            ++n2;
        }
        return new TableComparator(iFieldArray, nArray, nArray2);
    }

    protected void resetState() {
        System.arraycopy(this.defaultPriorities, 0, this.priorities, 0, this.priorities.length);
        System.arraycopy(this.defaultDirections, 0, this.directions, 0, this.directions.length);
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void setTopPriority(IField iField) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].equals(iField)) {
                this.setTopPriority(n);
                return;
            }
            ++n;
        }
    }

    public void setTopPriority(int n) {
        if (n < 0 || n >= this.priorities.length) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.priorities.length) {
            if (this.priorities[n3] == n) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            this.resetState();
            return;
        }
        n3 = n2;
        while (n3 > 0) {
            this.priorities[n3] = this.priorities[n3 - 1];
            --n3;
        }
        this.priorities[0] = n;
        this.directions[n] = this.defaultDirections[n];
    }

    public void setTopPriorityDirection(int n) {
        if (n == 1 || n == -1) {
            this.directions[this.priorities[0]] = n;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public IField getTopField() {
        return this.fields[this.getTopPriority()];
    }

    public int[] getPriorities() {
        int[] nArray = new int[this.priorities.length];
        System.arraycopy(this.priorities, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getDirections() {
        int[] nArray = new int[this.directions.length];
        System.arraycopy(this.directions, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getDefaultPriorities() {
        int[] nArray = new int[this.defaultPriorities.length];
        System.arraycopy(this.defaultPriorities, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getDefaultDirections() {
        int[] nArray = new int[this.defaultDirections.length];
        System.arraycopy(this.defaultDirections, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        return this.compare(object, object2, 0, true);
    }

    protected int compare(Object object, Object object2, int n, boolean bl) {
        if (n >= this.priorities.length) {
            return 0;
        }
        int n2 = this.priorities[n];
        IField iField = this.fields[n2];
        int n3 = iField.compare(object, object2);
        if (n3 == 0 && bl) {
            return this.compare(object, object2, n + 1, bl);
        }
        return n3 * this.directions[n2];
    }

    public IField[] getFields() {
        return this.fields;
    }

    private boolean verifyPriorities(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, false);
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 < 0 || n3 >= n) {
                return false;
            }
            if (blArray[n3]) {
                return false;
            }
            blArray[n3] = true;
            ++n2;
        }
        return true;
    }

    private boolean verifyDirections(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 1 && nArray[n] != -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int compare(Object object, Object object2) {
        return this.compare(null, object, object2);
    }

    public void saveState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        int n = 0;
        while (n < this.priorities.length) {
            iDialogSettings2.put(TAG_PRIORITY + n, this.priorities[n]);
            iDialogSettings2.put(TAG_DIRECTION + n, this.directions[n]);
            iDialogSettings2.put(TAG_DEFAULT_PRIORITY + n, this.defaultPriorities[n]);
            iDialogSettings2.put(TAG_DEFAULT_DIRECTION + n, this.defaultDirections[n]);
            ++n;
        }
    }

    public void restoreState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            this.resetState();
            return;
        }
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            this.resetState();
            return;
        }
        try {
            int n = 0;
            while (n < this.priorities.length) {
                String string;
                String string2 = iDialogSettings2.get(TAG_PRIORITY + n);
                if (string2 == null) {
                    this.resetState();
                    return;
                }
                int n2 = Integer.parseInt(string2);
                if (n2 < this.fields.length) {
                    this.priorities[n] = n2;
                }
                if ((string = iDialogSettings2.get(TAG_DIRECTION + n)) == null) {
                    this.resetState();
                    return;
                }
                this.directions[n] = Integer.parseInt(string);
                String string3 = iDialogSettings2.get(TAG_DEFAULT_PRIORITY + n);
                if (string3 == null) {
                    this.resetState();
                    return;
                }
                this.defaultPriorities[n] = Integer.parseInt(string3);
                String string4 = iDialogSettings2.get(TAG_DEFAULT_DIRECTION + n);
                if (string4 == null) {
                    this.resetState();
                    return;
                }
                this.defaultDirections[n] = Integer.parseInt(string4);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.resetState();
        }
    }

    public void sort(TreeViewer treeViewer, MarkerList markerList) {
        this.sort((Viewer)treeViewer, markerList.getArray());
    }

    public void sort(final Viewer viewer, Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2, new Comparator(){

            public int compare(Object object, Object object2) {
                return TableComparator.this.compare(viewer, object, object2);
            }
        });
    }
}

