/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.TableComparator;

public class TableSortDialog
extends TrayDialog {
    private TableComparator sorter;
    private Combo[] priorityCombos;
    private String[] propertyText;
    private IField[] properties;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private boolean dirty;
    private final Comparator columnComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            while (n3 < TableSortDialog.this.propertyText.length) {
                if (TableSortDialog.this.propertyText[n3].equals(object)) {
                    n = n3;
                }
                if (TableSortDialog.this.propertyText[n3].equals(object2)) {
                    n2 = n3;
                }
                ++n3;
            }
            return n - n2;
        }
    };

    public TableSortDialog(IShellProvider iShellProvider, TableComparator tableComparator) {
        super(iShellProvider);
        this.sorter = tableComparator;
        this.dirty = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MarkerMessages.sortDialog_title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.sorter == null) {
            return composite2;
        }
        this.initializeDialogUnits((Control)composite2);
        this.createPrioritiesArea(composite2);
        this.createRestoreDefaultsButton(composite2);
        this.createSeparatorLine(composite2);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createPrioritiesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        int[] nArray = this.sorter.getPriorities();
        this.ascendingButtons = new Button[nArray.length];
        this.descendingButtons = new Button[nArray.length];
        this.priorityCombos = new Combo[Math.min(nArray.length, 4)];
        this.initPriotityText();
        Label label = new Label(composite2, 0);
        label.setText(MarkerMessages.sortDialog_label);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        int n = 0;
        while (n < this.priorityCombos.length) {
            final int n2 = n;
            Label label2 = new Label(composite2, 0);
            label2.setText(NLS.bind((String)MarkerMessages.sortDialog_columnLabel, (Object)new Integer(n + 1)));
            this.priorityCombos[n] = new Combo(composite2, 8);
            this.priorityCombos[n].setLayoutData((Object)new GridData(768));
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[n] = new Button(composite3, 16);
            this.ascendingButtons[n].setText(this.getAscendingText(n));
            this.ascendingButtons[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TableSortDialog.this.markDirty();
                }
            });
            this.descendingButtons[n] = new Button(composite3, 16);
            this.descendingButtons[n].setText(this.getDescendingText(n));
            this.descendingButtons[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TableSortDialog.this.markDirty();
                }
            });
            if (n < this.priorityCombos.length - 1) {
                this.priorityCombos[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string;
                        int n = 1;
                        if (TableSortDialog.this.descendingButtons[n2].getSelection()) {
                            n = -1;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(TableSortDialog.this.priorityCombos[n2].getItems()));
                        arrayList.removeAll(Arrays.asList(TableSortDialog.this.priorityCombos[n2 + 1].getItems()));
                        if (arrayList.size() != 1) {
                            return;
                        }
                        String string2 = arrayList.get(0);
                        if (string2.equals(string = TableSortDialog.this.priorityCombos[n2].getItem(TableSortDialog.this.priorityCombos[n2].getSelectionIndex()))) {
                            return;
                        }
                        int n22 = n2 + 1;
                        while (n22 < TableSortDialog.this.priorityCombos.length) {
                            int n3;
                            int n4 = TableSortDialog.this.priorityCombos[n22].indexOf(string);
                            if (TableSortDialog.this.priorityCombos[n22].getSelectionIndex() == n4) {
                                TableSortDialog.this.priorityCombos[n22].remove(string);
                                n3 = -1 - Arrays.binarySearch(TableSortDialog.this.priorityCombos[n22].getItems(), string2, TableSortDialog.this.columnComparator);
                                if (n3 >= 0 && n3 <= TableSortDialog.this.priorityCombos[n22].getItemCount()) {
                                    TableSortDialog.this.priorityCombos[n22].add(string2, n3);
                                } else {
                                    TableSortDialog.this.priorityCombos[n22].add(string2);
                                }
                                TableSortDialog.this.priorityCombos[n22].select(TableSortDialog.this.priorityCombos[n22].indexOf(string2));
                                TableSortDialog.this.ascendingButtons[n2].setSelection(TableSortDialog.this.ascendingButtons[n22].getSelection());
                                TableSortDialog.this.descendingButtons[n2].setSelection(TableSortDialog.this.descendingButtons[n22].getSelection());
                                TableSortDialog.this.ascendingButtons[n22].setSelection(n == 1);
                                TableSortDialog.this.descendingButtons[n22].setSelection(n == -1);
                            } else if (n4 >= 0) {
                                TableSortDialog.this.priorityCombos[n22].remove(string);
                                n3 = -1 - Arrays.binarySearch(TableSortDialog.this.priorityCombos[n22].getItems(), string2, TableSortDialog.this.columnComparator);
                                if (n3 >= 0 && n3 <= TableSortDialog.this.priorityCombos[n22].getItemCount()) {
                                    TableSortDialog.this.priorityCombos[n22].add(string2, n3);
                                } else {
                                    TableSortDialog.this.priorityCombos[n22].add(string2);
                                }
                            }
                            ++n22;
                        }
                        TableSortDialog.this.markDirty();
                    }
                });
            } else {
                this.priorityCombos[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TableSortDialog.this.markDirty();
                    }
                });
            }
            ++n;
        }
        this.updateUIFromSorter();
    }

    private String getDescendingText(int n) {
        switch (n) {
            case 1: {
                return MarkerMessages.sortDirectionDescending_text2;
            }
            case 2: {
                return MarkerMessages.sortDirectionDescending_text3;
            }
            case 3: {
                return MarkerMessages.sortDirectionDescending_text4;
            }
        }
        return MarkerMessages.sortDirectionDescending_text;
    }

    private String getAscendingText(int n) {
        switch (n) {
            case 1: {
                return MarkerMessages.sortDirectionAscending_text2;
            }
            case 2: {
                return MarkerMessages.sortDirectionAscending_text3;
            }
            case 3: {
                return MarkerMessages.sortDirectionAscending_text4;
            }
        }
        return MarkerMessages.sortDirectionAscending_text;
    }

    private void createRestoreDefaultsButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(MarkerMessages.restoreDefaults_text);
        this.setButtonSize(button, new GridData(896));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableSortDialog.this.restoreDefaults();
                TableSortDialog.this.markDirty();
            }
        });
    }

    private void createSeparatorLine(Composite composite) {
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(772));
    }

    private void restoreDefaults() {
        this.updateUI(this.sorter.getDefaultPriorities(), this.sorter.getDefaultDirections());
    }

    private void updateUIFromSorter() {
        this.updateUI(this.sorter.getPriorities(), this.sorter.getDirections());
    }

    private void updateUI(int[] nArray, int[] nArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.propertyText));
        int n = 0;
        while (n < this.priorityCombos.length) {
            this.priorityCombos[n].removeAll();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                this.priorityCombos[n].add(arrayList.get(n2));
                ++n2;
            }
            this.priorityCombos[n].select(this.priorityCombos[n].indexOf(this.propertyText[nArray[n]]));
            arrayList.remove(this.propertyText[nArray[n]]);
            this.ascendingButtons[n].setSelection(nArray2[nArray[n]] == 1);
            this.descendingButtons[n].setSelection(nArray2[nArray[n]] == -1);
            ++n;
        }
    }

    protected void okPressed() {
        if (this.isDirty()) {
            int n = this.priorityCombos.length - 1;
            while (n >= 0) {
                String string = this.priorityCombos[n].getItem(this.priorityCombos[n].getSelectionIndex());
                int n2 = -1;
                int n3 = 0;
                while (n3 < this.propertyText.length && n2 == -1) {
                    if (this.propertyText[n3].equals(string)) {
                        n2 = n3;
                    }
                    ++n3;
                }
                if (n2 == -1) {
                    this.sorter.resetState();
                    return;
                }
                this.sorter.setTopPriority(this.properties[n2]);
                n3 = 1;
                if (this.descendingButtons[n].getSelection()) {
                    n3 = -1;
                }
                this.sorter.setTopPriorityDirection(n3);
                --n;
            }
        }
        super.okPressed();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void setButtonSize(Button button, GridData gridData) {
        button.setFont(button.getParent().getFont());
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
    }

    private void initPriotityText() {
        IField[] iFieldArray = this.sorter.getFields();
        this.properties = new IField[iFieldArray.length];
        System.arraycopy(iFieldArray, 0, this.properties, 0, this.properties.length);
        this.propertyText = new String[this.properties.length];
        int n = 0;
        while (n < this.properties.length) {
            this.propertyText[n] = this.properties[n].getDescription();
            ++n;
        }
    }

    public TableComparator getSorter() {
        return this.sorter;
    }
}

