/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.FiltersAction;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAdapter;
import org.eclipse.ui.views.markers.internal.MarkerTreeContentProvider;
import org.eclipse.ui.views.markers.internal.MarkerViewLabelProvider;
import org.eclipse.ui.views.markers.internal.TableComparator;
import org.eclipse.ui.views.markers.internal.TableSortAction;
import org.eclipse.ui.views.markers.internal.TableSortDialog;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class TableView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String TAG_COLUMN_ORDER = "columnOrder";
    private static final String TAG_COLUMN_ORDER_INDEX = "columnOrderIndex";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private TreeViewer viewer;
    private IMemento memento;
    private IAction sortAction;
    private IAction filtersAction;
    private IAction preferencesAction;
    private MarkerTreeContentProvider contentProvider;
    private ISelectionProvider selectionProvider = new MarkerSelectionProviderAdapter();
    static /* synthetic */ Class class$0;

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    protected abstract void viewerSelectionChanged(IStructuredSelection var1);

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.createTree(composite));
        this.createColumns(this.viewer.getTree());
        this.viewer.setComparator(this.buildComparator());
        this.setSortIndicators();
        this.contentProvider = new MarkerTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                TableView.this.viewerSelectionChanged(iStructuredSelection);
            }
        });
        this.createActions();
        this.viewer.setInput(this.createViewerInput());
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar scrollBar = scrollable.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(this.restoreVerticalScrollBarPosition(this.memento));
        }
        if ((scrollBar = scrollable.getHorizontalBar()) != null) {
            scrollBar.setSelection(this.restoreHorizontalScrollBarPosition(this.memento));
        }
        MenuManager menuManager = this.initContextMenu();
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, this.selectionProvider);
        this.getSite().setSelectionProvider(this.selectionProvider);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.initMenu(iActionBars.getMenuManager());
        this.initToolBar(iActionBars.getToolBarManager());
        this.registerGlobalActions(this.getViewSite().getActionBars());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                TableView.this.handleOpenEvent(openEvent);
            }
        });
    }

    abstract Object createViewerInput();

    void setComparator(TableComparator tableComparator) {
        this.viewer.setComparator((ViewerComparator)tableComparator);
        this.updateForNewComparator(tableComparator);
    }

    void updateForNewComparator(TableComparator tableComparator) {
        tableComparator.saveState(this.getDialogSettings());
        this.viewer.refresh();
        this.setSortIndicators();
    }

    protected Tree createTree(Composite composite) {
        Tree tree = new Tree(composite, 66306);
        tree.setLinesVisible(true);
        return tree;
    }

    public ColumnPixelData[] getSavedColumnData() {
        ColumnPixelData[] columnPixelDataArray = this.getDefaultColumnLayouts();
        ColumnPixelData[] columnPixelDataArray2 = new ColumnPixelData[columnPixelDataArray.length];
        int n = 0;
        while (n < columnPixelDataArray.length) {
            Integer n2;
            ColumnPixelData columnPixelData = columnPixelDataArray[n];
            boolean bl = columnPixelData.addTrim;
            int n3 = columnPixelData.width;
            if (columnPixelData.resizable && this.memento != null && (n2 = this.memento.getInteger(TAG_COLUMN_WIDTH + n)) != null && n2 > 0) {
                n3 = n2;
                bl = false;
            }
            columnPixelDataArray2[n] = new ColumnPixelData(n3, columnPixelData.resizable, bl);
            ++n;
        }
        return columnPixelDataArray2;
    }

    public ColumnPixelData[] getColumnData() {
        ColumnPixelData[] columnPixelDataArray = this.getSavedColumnData();
        Tree tree = this.getTree();
        if (tree != null && (tree.isDisposed() || tree.getBounds().width == 0)) {
            tree = null;
        }
        TreeColumn[] treeColumnArray = null;
        if (tree != null) {
            treeColumnArray = tree.getColumns();
        }
        ColumnPixelData[] columnPixelDataArray2 = new ColumnPixelData[columnPixelDataArray.length];
        int n = 0;
        while (n < columnPixelDataArray.length) {
            TreeColumn treeColumn;
            ColumnPixelData columnPixelData = columnPixelDataArray[n];
            int n2 = columnPixelDataArray[n].width;
            if (treeColumnArray != null && n < treeColumnArray.length && (treeColumn = treeColumnArray[n]).getWidth() > 0) {
                n2 = treeColumn.getWidth();
            }
            columnPixelDataArray2[n] = new ColumnPixelData(n2, columnPixelData.resizable, columnPixelData.addTrim);
            ++n;
        }
        return columnPixelDataArray2;
    }

    protected void createColumns(Tree tree) {
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        tree.setHeaderVisible(true);
        IField[] iFieldArray = this.getAllFields();
        ColumnPixelData[] columnPixelDataArray = this.getSavedColumnData();
        int n = 0;
        while (n < iFieldArray.length) {
            tableLayout.addColumnData((ColumnLayoutData)columnPixelDataArray[n]);
            TreeColumn treeColumn = new TreeColumn(tree, 0, n);
            IField iField = iFieldArray[n];
            treeColumn.setText(iField.getColumnHeaderText());
            treeColumn.setImage(iField.getColumnHeaderImage());
            treeColumn.setResizable(columnPixelDataArray[n].resizable);
            treeColumn.setMoveable(true);
            treeColumn.addSelectionListener(this.getHeaderListener());
            treeColumn.setData((Object)iField);
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, treeColumn);
            treeViewerColumn.setLabelProvider((CellLabelProvider)new MarkerViewLabelProvider(iField));
            ++n;
        }
        int[] nArray = this.restoreColumnOrder(this.memento);
        if (nArray != null && nArray.length == iFieldArray.length) {
            tree.setColumnOrder(nArray);
        }
    }

    protected void createActions() {
        if (this.getSortDialog() != null) {
            this.sortAction = new TableSortAction(this, this.getSortDialog());
        }
    }

    protected MenuManager initContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TableView.this.getViewer().cancelEditing();
                TableView.this.fillContextMenu(iMenuManager);
            }
        });
        return menuManager;
    }

    protected abstract void initToolBar(IToolBarManager var1);

    protected void initMenu(IMenuManager iMenuManager) {
        if (this.sortAction != null) {
            iMenuManager.add(this.sortAction);
        }
        this.addDropDownContributions(iMenuManager);
        if (this.filtersAction != null) {
            iMenuManager.add(this.filtersAction);
        }
        if (this.preferencesAction != null) {
            iMenuManager.add(this.preferencesAction);
        }
    }

    void addDropDownContributions(IMenuManager iMenuManager) {
    }

    protected abstract void registerGlobalActions(IActionBars var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    public void setFocus() {
        TreeViewer treeViewer = this.getViewer();
        if (treeViewer != null && !treeViewer.getControl().isDisposed()) {
            treeViewer.getControl().setFocus();
        }
    }

    protected ViewerComparator buildComparator() {
        return this.createTableComparator();
    }

    TableComparator createTableComparator() {
        TableComparator tableComparator = TableComparator.createTableSorter(this.getSortingFields());
        tableComparator.restoreState(this.getDialogSettings());
        return tableComparator;
    }

    protected abstract IField[] getSortingFields();

    protected abstract IField[] getAllFields();

    protected abstract IDialogSettings getDialogSettings();

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    protected Tree getTree() {
        return this.getViewer().getTree();
    }

    protected SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
                IField iField = (IField)treeColumn.getData();
                try {
                    IWorkbenchSiteProgressService iWorkbenchSiteProgressService = TableView.this.getProgressService();
                    if (iWorkbenchSiteProgressService == null) {
                        BusyIndicator.showWhile((Display)TableView.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this, treeColumn, iField){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ TreeColumn val$column;
                            private final /* synthetic */ IField val$field;
                            {
                                this.this$1 = var1_1;
                                this.val$column = treeColumn;
                                this.val$field = iField;
                            }

                            public void run() {
                                4.access$0(this.this$1, this.val$column, this.val$field, (IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    } else {
                        TableView.this.getProgressService().busyCursorWhile(new IRunnableWithProgress(this, treeColumn, iField){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ TreeColumn val$column;
                            private final /* synthetic */ IField val$field;
                            {
                                this.this$1 = var1_1;
                                this.val$column = treeColumn;
                                this.val$field = iField;
                            }

                            public void run(IProgressMonitor iProgressMonitor) {
                                4.access$0(this.this$1, this.val$column, this.val$field, iProgressMonitor);
                            }
                        });
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(invocationTargetException));
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            private void resortTable(TreeColumn treeColumn, IField iField, IProgressMonitor iProgressMonitor) {
                TableComparator tableComparator = TableView.this.getTableSorter();
                iProgressMonitor.beginTask(MarkerMessages.sortDialog_title, 100);
                iProgressMonitor.worked(10);
                if (iField.equals(tableComparator.getTopField())) {
                    tableComparator.reverseTopPriority();
                } else {
                    tableComparator.setTopPriority(iField);
                }
                iProgressMonitor.worked(15);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this, treeColumn){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ TreeColumn val$column;
                    {
                        this.this$1 = var1_1;
                        this.val$column = treeColumn;
                    }

                    public void run() {
                        TableView.access$0(4.access$1(this.this$1)).refresh();
                        4.access$1(this.this$1).updateDirectionIndicator(this.val$column);
                    }
                });
                iProgressMonitor.done();
            }

            static /* synthetic */ void access$0(4 var0, TreeColumn treeColumn, IField iField, IProgressMonitor iProgressMonitor) {
                var0.resortTable(treeColumn, iField, iProgressMonitor);
            }

            static /* synthetic */ TableView access$1(4 var0) {
                return var0.TableView.this;
            }
        };
    }

    protected ColumnPixelData[] getDefaultColumnLayouts() {
        IField[] iFieldArray = this.getAllFields();
        ColumnPixelData[] columnPixelDataArray = new ColumnPixelData[iFieldArray.length];
        int n = 0;
        while (n < iFieldArray.length) {
            int n2 = this.getWidth(iFieldArray[n]);
            boolean bl = n2 > 0;
            columnPixelDataArray[n] = new ColumnPixelData(n2, bl, bl);
            ++n;
        }
        return columnPixelDataArray;
    }

    private int getWidth(IField iField) {
        if (!iField.isShowing()) {
            return 0;
        }
        return iField.getPreferredWidth();
    }

    protected TableSortDialog getSortDialog() {
        return new TableSortDialog((IShellProvider)this.getSite(), this.getTableSorter());
    }

    TableComparator getTableSorter() {
        return (TableComparator)this.viewer.getComparator();
    }

    protected abstract void handleOpenEvent(OpenEvent var1);

    public void saveState(IMemento iMemento) {
        IMemento iMemento2;
        Object object;
        super.saveState(iMemento);
        ColumnPixelData[] columnPixelDataArray = this.getColumnData();
        int n = 0;
        while (n < columnPixelDataArray.length) {
            object = columnPixelDataArray[n];
            iMemento.putInteger(TAG_COLUMN_WIDTH + n, object.width);
            ++n;
        }
        Tree tree = this.getTree();
        object = tree.getColumnOrder();
        int n2 = 0;
        while (n2 < ((ColumnPixelData)object).length) {
            iMemento2 = iMemento.createChild(TAG_COLUMN_ORDER);
            iMemento2.putInteger(TAG_COLUMN_ORDER_INDEX, (int)object[n2]);
            ++n2;
        }
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        iMemento2 = scrollable.getVerticalBar();
        int n3 = iMemento2 != null ? iMemento2.getSelection() : 0;
        iMemento.putInteger(TAG_VERTICAL_POSITION, n3);
        iMemento2 = scrollable.getHorizontalBar();
        n3 = iMemento2 != null ? iMemento2.getSelection() : 0;
        iMemento.putInteger(TAG_HORIZONTAL_POSITION, n3);
    }

    private int[] restoreColumnOrder(IMemento iMemento) {
        if (iMemento == null) {
            return null;
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_COLUMN_ORDER);
        if (iMementoArray != null) {
            int n = iMementoArray.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                Integer n3 = iMementoArray[n2].getInteger(TAG_COLUMN_ORDER_INDEX);
                if (n3 == null) {
                    return null;
                }
                nArray[n2] = n3;
                ++n2;
            }
            return nArray;
        }
        return null;
    }

    private int restoreVerticalScrollBarPosition(IMemento iMemento) {
        if (iMemento == null) {
            return 0;
        }
        Integer n = iMemento.getInteger(TAG_VERTICAL_POSITION);
        return n == null ? 0 : n;
    }

    private int restoreHorizontalScrollBarPosition(IMemento iMemento) {
        if (iMemento == null) {
            return 0;
        }
        Integer n = iMemento.getInteger(TAG_HORIZONTAL_POSITION);
        return n == null ? 0 : n;
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object object;
        IWorkbenchSiteProgressService iWorkbenchSiteProgressService = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            iWorkbenchSiteProgressService = (IWorkbenchSiteProgressService)object;
        }
        return iWorkbenchSiteProgressService;
    }

    void setFilterAction(FiltersAction filtersAction) {
        this.filtersAction = filtersAction;
    }

    IAction getFilterAction() {
        return this.filtersAction;
    }

    IAction getPreferencesAction() {
        return this.preferencesAction;
    }

    void setPreferencesAction(ViewPreferencesAction viewPreferencesAction) {
        this.preferencesAction = viewPreferencesAction;
    }

    MarkerTreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Object getViewerInput() {
        return this.getViewer().getInput();
    }

    void setSortIndicators() {
        IField iField = this.getTableSorter().getTopField();
        TreeColumn[] treeColumnArray = this.getViewer().getTree().getColumns();
        int n = 0;
        while (n < treeColumnArray.length) {
            TreeColumn treeColumn = treeColumnArray[n];
            if (treeColumn.getData().equals(iField)) {
                this.updateDirectionIndicator(treeColumn);
                return;
            }
            ++n;
        }
    }

    void updateDirectionIndicator(TreeColumn treeColumn) {
        this.getViewer().getTree().setSortColumn(treeColumn);
        if (this.getTableSorter().getTopPriorityDirection() == 1) {
            this.getViewer().getTree().setSortDirection(128);
        } else {
            this.getViewer().getTree().setSortDirection(1024);
        }
    }

    protected void setSelection(IStructuredSelection iStructuredSelection) {
        this.selectionProvider.setSelection((ISelection)iStructuredSelection);
    }

    static /* synthetic */ TreeViewer access$0(TableView tableView) {
        return tableView.viewer;
    }
}

