/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class TaskFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    public static final String TAG_DONE = "done";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_SELECT_BY_DONE = "selectByDone";
    public static final String TAG_SELECT_BY_PRIORITY = "selectByPriority";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    static final boolean DEFAULT_DONE = false;
    static final int DEFAULT_PRIORITY = 0;
    static final boolean DEFAULT_SELECT_BY_DONE = false;
    static final boolean DEFAULT_SELECT_BY_PRIORITY = false;
    static final int PRIORITY_HIGH = 4;
    static final int PRIORITY_NORMAL = 2;
    static final int PRIORITY_LOW = 1;
    private boolean contains;
    private String description;
    private boolean done;
    private int priority;
    private boolean selectByPriority = false;
    private boolean selectByDone = false;

    public TaskFilter() {
        this(MarkerMessages.MarkerFilter_defaultFilterName);
    }

    public TaskFilter(String string) {
        super(string, new String[]{"org.eclipse.core.resources.taskmarker"});
    }

    public boolean selectMarker(ConcreteMarker concreteMarker) {
        if (!(concreteMarker instanceof TaskMarker)) {
            return false;
        }
        TaskMarker taskMarker = (TaskMarker)concreteMarker;
        return !this.isEnabled() || super.selectMarker(taskMarker) && this.selectByDescription(taskMarker) && this.selectByDone(taskMarker) && this.selectByPriority(taskMarker);
    }

    private boolean selectByDescription(ConcreteMarker concreteMarker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        int n = concreteMarker.getDescription().indexOf(this.description);
        return this.contains ? n >= 0 : n < 0;
    }

    private boolean selectByDone(TaskMarker taskMarker) {
        if (this.selectByDone) {
            return this.done == (taskMarker.getDone() == 1);
        }
        return true;
    }

    private boolean selectByPriority(TaskMarker taskMarker) {
        if (this.priority != 0 && this.selectByPriority) {
            int n = taskMarker.getPriority();
            if (n == 2) {
                return (this.priority & 4) > 0;
            }
            if (n == 1) {
                return (this.priority & 2) > 0;
            }
            if (n == 0) {
                return (this.priority & 1) > 0;
            }
        }
        return true;
    }

    public boolean getContains() {
        return this.contains;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDone() {
        return this.done;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean getSelectByDone() {
        return this.selectByDone;
    }

    public boolean getSelectByPriority() {
        return this.selectByPriority;
    }

    public void setContains(boolean bl) {
        this.contains = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setSelectByDone(boolean bl) {
        this.selectByDone = bl;
    }

    public void setSelectByPriority(boolean bl) {
        this.selectByPriority = bl;
    }

    public void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
        this.done = false;
        this.priority = 0;
        this.selectByDone = false;
        this.selectByPriority = false;
    }

    public void restoreFilterSettings(IDialogSettings iDialogSettings) {
        super.restoreFilterSettings(iDialogSettings);
        String string = iDialogSettings.get(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
        if ((string = iDialogSettings.get(TAG_DONE)) != null) {
            this.done = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_PRIORITY)) != null) {
            try {
                this.priority = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = iDialogSettings.get(TAG_SELECT_BY_DONE)) != null) {
            this.selectByDone = Boolean.valueOf(string);
        }
        if ((string = iDialogSettings.get(TAG_SELECT_BY_PRIORITY)) != null) {
            this.selectByPriority = Boolean.valueOf(string);
        }
    }

    protected void restoreFilterSettings(IMemento iMemento) {
        super.restoreFilterSettings(iMemento);
        String string = iMemento.getString(TAG_CONTAINS);
        if (string != null) {
            this.contains = Boolean.valueOf(string);
        }
        if ((string = iMemento.getString(TAG_DESCRIPTION)) != null) {
            this.description = new String(string);
        }
        if ((string = iMemento.getString(TAG_DONE)) != null) {
            this.done = Boolean.valueOf(string);
        }
        Integer n = iMemento.getInteger(TAG_PRIORITY);
        if (string != null) {
            this.priority = n;
        }
        if ((string = iMemento.getString(TAG_SELECT_BY_DONE)) != null) {
            this.selectByDone = Boolean.valueOf(string);
        }
        if ((string = iMemento.getString(TAG_SELECT_BY_PRIORITY)) != null) {
            this.selectByPriority = Boolean.valueOf(string);
        }
    }

    public void saveFilterSettings(IMemento iMemento) {
        super.saveFilterSettings(iMemento);
        iMemento.putString(TAG_CONTAINS, String.valueOf(this.contains));
        iMemento.putString(TAG_DESCRIPTION, this.description);
        iMemento.putString(TAG_DONE, String.valueOf(this.done));
        iMemento.putInteger(TAG_PRIORITY, this.priority);
        iMemento.putString(TAG_SELECT_BY_DONE, String.valueOf(this.selectByDone));
        iMemento.putString(TAG_SELECT_BY_PRIORITY, String.valueOf(this.selectByPriority));
    }
}

